/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import androidx.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public class RGBFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_RED = "red";
    public static final String UNIFORM_GREEN = "green";
    public static final String UNIFORM_BLUE = "blue";
    public static final String RGB_FRAGMENT_SHADER = "precision mediump float; \n  varying highp vec2 vTextureCoord;\n  \n  uniform sampler2D uTextureSampler;\n  uniform highp float red;\n  uniform highp float green;\n  uniform highp float blue;\n uniform float uAlpha;\n  \n  void main() {\n        highp vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n      \n      gl_FragColor = vec4(textureColor.r * red, textureColor.g * green, textureColor.b * blue, textureColor.w);\n    gl_FragColor *= uAlpha;\n  }\n";
    private float red;
    private float green;
    private float blue;

    public RGBFilter(@FloatRange(from=0.0, to=1.0) float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setRed(@FloatRange(from=0.0, to=1.0) float value) {
        this.red = value;
    }

    public void setGreen(float value) {
        this.green = value;
    }

    public void setBlue(float value) {
        this.blue = value;
    }

    @Override
    public String getFragmentShader() {
        return RGB_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_RED), this.red);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_GREEN), this.green);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_BLUE), this.blue);
    }

    @Override
    public void setValue(float value) {
        this.setRed(value);
        this.setGreen(value);
        this.setBlue(value);
    }
}

