/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.FilterGroup;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.util.ArrayList;

public class GaussianBlurFilter
extends FilterGroup {
    public GaussianBlurFilter(float blurSize) {
        super(new ArrayList<TextureFilter>());
        this.mFilters.add(new GaussianFilter(0, blurSize));
        this.mFilters.add(new GaussianFilter(1, blurSize));
        this.updateMergedFilters();
    }

    public void setBlurSize(float blurSize) {
        for (TextureFilter textureFilter : this.mFilters) {
            if (!(textureFilter instanceof GaussianFilter)) continue;
            GaussianFilter gaussianFilter = (GaussianFilter)textureFilter;
            gaussianFilter.setBlurSize(blurSize);
        }
    }

    public static class GaussianFilter
    extends BasicTextureFilter {
        private float blurSize;
        private int dir;
        public static final String TEXEL_WIDTH_OFFSET = "texelWidthOffset";
        public static final String TEXEL_HEIGHT_OFFSET = "texelHeightOffset";
        public static final String BLUR_COORDINATES = "blurCoordinates";
        public static final String VERTEX_SHADER = "precision mediump float;\nuniform mat4 uMatrix;\nuniform mat4 uTextureMatrix;\nattribute vec2 aPosition;\nconst int GAUSSIAN_SAMPLES = 9;\n\nuniform float texelWidthOffset;\nuniform float texelHeightOffset;\n\nvarying vec2 vTextureCoord;\nvarying vec2 blurCoordinates[GAUSSIAN_SAMPLES];\n\nvoid main()\n{\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n\tgl_Position = uMatrix* pos;\nvTextureCoord = (uTextureMatrix * pos).xy;\n\t\n\tint multiplier = 0;\n\tvec2 blurStep;\n   vec2 singleStepOffset = vec2(texelHeightOffset, texelWidthOffset);\n    \n\tfor (int i = 0; i < GAUSSIAN_SAMPLES; i++)\n   {\n\t\tmultiplier = (i - ((GAUSSIAN_SAMPLES - 1) / 2));\n       // Blur in x (horizontal)\n       blurStep = float(multiplier) * singleStepOffset;\n\t\tblurCoordinates[i] = vTextureCoord.xy + blurStep;\n\t}\n}\n";
        public static final String FRAGMENT_SHADER = "uniform sampler2D uTextureSampler;\n\nconst lowp int GAUSSIAN_SAMPLES = 9;\n\nvarying highp vec2 vTextureCoord;\nvarying highp vec2 blurCoordinates[GAUSSIAN_SAMPLES];\n\nvoid main()\n{\n\tlowp vec3 sum = vec3(0.0);\n   lowp vec4 fragColor=texture2D(uTextureSampler,vTextureCoord);\n\t\n    sum += texture2D(uTextureSampler, blurCoordinates[0]).rgb * 0.05;\n    sum += texture2D(uTextureSampler, blurCoordinates[1]).rgb * 0.09;\n    sum += texture2D(uTextureSampler, blurCoordinates[2]).rgb * 0.12;\n    sum += texture2D(uTextureSampler, blurCoordinates[3]).rgb * 0.15;\n    sum += texture2D(uTextureSampler, blurCoordinates[4]).rgb * 0.18;\n    sum += texture2D(uTextureSampler, blurCoordinates[5]).rgb * 0.15;\n    sum += texture2D(uTextureSampler, blurCoordinates[6]).rgb * 0.12;\n    sum += texture2D(uTextureSampler, blurCoordinates[7]).rgb * 0.09;\n    sum += texture2D(uTextureSampler, blurCoordinates[8]).rgb * 0.05;\n\n\tgl_FragColor = vec4(sum,fragColor.a);\n}";

        public GaussianFilter(int dir, float blurSize) {
            this.dir = dir;
            this.blurSize = blurSize;
        }

        public GaussianFilter(int dir) {
            this(dir, 1.0f);
        }

        @Override
        public String getVertexShader() {
            return VERTEX_SHADER;
        }

        @Override
        public String getFragmentShader() {
            return FRAGMENT_SHADER;
        }

        @Override
        public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
            super.onPreDraw(program, texture, canvas);
            int widthOffsetLocation = GLES20.glGetUniformLocation((int)program, (String)TEXEL_WIDTH_OFFSET);
            int heightOffsetLocation = GLES20.glGetUniformLocation((int)program, (String)TEXEL_HEIGHT_OFFSET);
            if (this.dir == 0) {
                OpenGLUtil.setFloat(widthOffsetLocation, this.blurSize / (float)texture.getWidth());
                OpenGLUtil.setFloat(heightOffsetLocation, 0.0f);
            } else {
                OpenGLUtil.setFloat(widthOffsetLocation, 0.0f);
                OpenGLUtil.setFloat(heightOffsetLocation, this.blurSize / (float)texture.getHeight());
            }
        }

        public void setBlurSize(float blurSize) {
            this.blurSize = blurSize;
        }
    }
}

