/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache;

import com.danikula.videocache.Preconditions;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

class IgnoreHostProxySelector
extends ProxySelector {
    private static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private final ProxySelector defaultProxySelector;
    private final String hostToIgnore;
    private final int portToIgnore;

    IgnoreHostProxySelector(ProxySelector defaultProxySelector, String hostToIgnore, int portToIgnore) {
        this.defaultProxySelector = Preconditions.checkNotNull(defaultProxySelector);
        this.hostToIgnore = Preconditions.checkNotNull(hostToIgnore);
        this.portToIgnore = portToIgnore;
    }

    static void install(String hostToIgnore, int portToIgnore) {
        ProxySelector defaultProxySelector = ProxySelector.getDefault();
        IgnoreHostProxySelector ignoreHostProxySelector = new IgnoreHostProxySelector(defaultProxySelector, hostToIgnore, portToIgnore);
        ProxySelector.setDefault(ignoreHostProxySelector);
    }

    @Override
    public List<Proxy> select(URI uri) {
        boolean ignored = this.hostToIgnore.equals(uri.getHost()) && this.portToIgnore == uri.getPort();
        return ignored ? NO_PROXY_LIST : this.defaultProxySelector.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress address, IOException failure) {
        this.defaultProxySelector.connectFailed(uri, address, failure);
    }
}

