/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.shuyu.gsyvideoplayer.model.GSYVideoModel;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoPlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.codeest.enviews.ENDownloadView;

public class ListGSYVideoPlayer
extends StandardGSYVideoPlayer {
    protected List<GSYVideoModel> mUriList = new ArrayList<GSYVideoModel>();
    protected int mPlayPosition;

    public ListGSYVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public ListGSYVideoPlayer(Context context) {
        super(context);
    }

    public ListGSYVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position) {
        return this.setUp(url, cacheWithPlay, position, null, new HashMap<String, String>());
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath) {
        return this.setUp(url, cacheWithPlay, position, cachePath, new HashMap<String, String>());
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath, Map<String, String> mapHeadData) {
        return this.setUp(url, cacheWithPlay, position, cachePath, mapHeadData, true);
    }

    protected boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath, Map<String, String> mapHeadData, boolean changeState) {
        this.mUriList = url;
        this.mPlayPosition = position;
        this.mMapHeadData = mapHeadData;
        GSYVideoModel gsyVideoModel = url.get(position);
        boolean set = this.setUp(gsyVideoModel.getUrl(), cacheWithPlay, cachePath, gsyVideoModel.getTitle(), changeState);
        if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle()) && this.mTitleTextView != null) {
            this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
        }
        return set;
    }

    @Override
    protected void cloneParams(GSYBaseVideoPlayer from, GSYBaseVideoPlayer to) {
        super.cloneParams(from, to);
        ListGSYVideoPlayer sf = (ListGSYVideoPlayer)from;
        ListGSYVideoPlayer st = (ListGSYVideoPlayer)to;
        st.mPlayPosition = sf.mPlayPosition;
        st.mUriList = sf.mUriList;
    }

    @Override
    public GSYBaseVideoPlayer startWindowFullscreen(Context context, boolean actionBar, boolean statusBar) {
        GSYBaseVideoPlayer gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar);
        if (gsyBaseVideoPlayer != null) {
            ListGSYVideoPlayer listGSYVideoPlayer = (ListGSYVideoPlayer)gsyBaseVideoPlayer;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle()) && this.mTitleTextView != null) {
                listGSYVideoPlayer.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
        }
        return gsyBaseVideoPlayer;
    }

    @Override
    protected void resolveNormalVideoShow(View oldF, ViewGroup vp, GSYVideoPlayer gsyVideoPlayer) {
        if (gsyVideoPlayer != null) {
            ListGSYVideoPlayer listGSYVideoPlayer = (ListGSYVideoPlayer)gsyVideoPlayer;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle()) && this.mTitleTextView != null) {
                this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
        }
        super.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
    }

    @Override
    public void onCompletion() {
        this.releaseNetWorkState();
        if (this.mPlayPosition < this.mUriList.size()) {
            this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
            return;
        }
        super.onCompletion();
    }

    @Override
    public void onAutoCompletion() {
        if (this.playNext()) {
            return;
        }
        super.onAutoCompletion();
    }

    @Override
    protected void releaseVideos() {
        super.onCompletion();
        super.releaseVideos();
    }

    @Override
    protected void prepareVideo() {
        super.prepareVideo();
        if (this.mHadPlay && this.mPlayPosition < this.mUriList.size()) {
            this.setViewShowState(this.mLoadingProgressBar, 0);
            if (this.mLoadingProgressBar instanceof ENDownloadView) {
                ((ENDownloadView)this.mLoadingProgressBar).start();
            }
        }
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
    }

    @Override
    protected void changeUiToNormal() {
        super.changeUiToNormal();
        if (this.mHadPlay && this.mPlayPosition < this.mUriList.size()) {
            this.setViewShowState((View)this.mThumbImageViewLayout, 8);
            this.setViewShowState((View)this.mTopContainer, 4);
            this.setViewShowState((View)this.mBottomContainer, 4);
            this.setViewShowState(this.mStartButton, 8);
            this.setViewShowState(this.mLoadingProgressBar, 0);
            this.setViewShowState((View)this.mBottomProgressBar, 4);
            this.setViewShowState((View)this.mLockScreen, 8);
            if (this.mLoadingProgressBar instanceof ENDownloadView) {
                ((ENDownloadView)this.mLoadingProgressBar).start();
            }
        }
    }

    public boolean playNext() {
        if (this.mPlayPosition < this.mUriList.size() - 1) {
            ++this.mPlayPosition;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            this.mSaveChangeViewTIme = 0L;
            this.setUp(this.mUriList, this.mCache, this.mPlayPosition, null, this.mMapHeadData, false);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle()) && this.mTitleTextView != null) {
                this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
            this.startPlayLogic();
            return true;
        }
        return false;
    }
}

