/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import com.shuyu.gsyvideoplayer.GSYPreViewManager;
import com.shuyu.gsyvideoplayer.GSYTextureView;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;

public class CustomGSYVideoPlayer
extends StandardGSYVideoPlayer {
    private RelativeLayout mPreviewLayout;
    private GSYTextureView mPreviewTexture;
    private boolean mIsFromUser;
    private boolean mOpenPreView;
    private int mPreProgress = -2;

    public CustomGSYVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public CustomGSYVideoPlayer(Context context) {
        super(context);
    }

    public CustomGSYVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.initView();
    }

    private void initView() {
        this.mPreviewLayout = (RelativeLayout)this.findViewById(R.id.preview_layout);
    }

    @Override
    public int getLayoutId() {
        return R.layout.video_layout_custom;
    }

    @Override
    protected void addTextureView() {
        super.addTextureView();
        if (this.mPreviewLayout.getChildCount() > 0) {
            this.mPreviewLayout.removeAllViews();
        }
        this.mPreviewTexture = null;
        this.mPreviewTexture = new GSYTextureView(this.getActivityContext());
        this.mPreviewTexture.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                GSYPreViewManager.instance().setDisplay(new Surface(surface));
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                GSYPreViewManager.instance().setDisplay(null);
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        this.mPreviewTexture.setRotation(this.mRotate);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.mPreviewLayout.addView((View)this.mPreviewTexture, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    protected void prepareVideo() {
        GSYPreViewManager.instance().prepare(this.mUrl, this.mMapHeadData, this.mLooping, this.mSpeed);
        super.prepareVideo();
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        super.onProgressChanged(seekBar, progress, fromUser);
        if (fromUser && this.mOpenPreView) {
            int width = seekBar.getWidth();
            int offset = (int)((float)width - this.getResources().getDimension(R.dimen.seek_bar_image) / 2.0f) / 100 * progress;
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mPreviewLayout.getLayoutParams();
            layoutParams.leftMargin = offset;
            this.mPreviewLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (GSYPreViewManager.instance().getMediaPlayer() != null && this.mHadPlay && this.mOpenPreView && GSYPreViewManager.instance().isSeekToComplete()) {
                GSYPreViewManager.instance().setSeekToComplete(false);
                int time = progress * this.getDuration() / 100;
                GSYPreViewManager.instance().getMediaPlayer().seekTo((long)time);
                this.mPreProgress = progress;
            }
        }
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        super.onStartTrackingTouch(seekBar);
        if (this.mOpenPreView) {
            this.mIsFromUser = true;
            this.mPreviewLayout.setVisibility(0);
            this.mPreProgress = -2;
        }
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mOpenPreView) {
            if (this.mPreProgress >= 0) {
                seekBar.setProgress(this.mPreProgress);
            }
            super.onStopTrackingTouch(seekBar);
            this.mIsFromUser = false;
            this.mPreviewLayout.setVisibility(8);
        } else {
            super.onStopTrackingTouch(seekBar);
        }
    }

    @Override
    protected void setTextAndProgress(int secProgress) {
        if (this.mIsFromUser) {
            return;
        }
        super.setTextAndProgress(secProgress);
    }

    @Override
    public GSYBaseVideoPlayer startWindowFullscreen(Context context, boolean actionBar, boolean statusBar) {
        GSYBaseVideoPlayer gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar);
        CustomGSYVideoPlayer customGSYVideoPlayer = (CustomGSYVideoPlayer)gsyBaseVideoPlayer;
        customGSYVideoPlayer.mOpenPreView = this.mOpenPreView;
        return gsyBaseVideoPlayer;
    }

    public boolean isOpenPreView() {
        return this.mOpenPreView;
    }

    public void setOpenPreView(boolean localFile) {
        this.mOpenPreView = localFile;
    }
}

