/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLException;
import android.opengl.GLSurfaceView;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.opengles.GL10;

@SuppressLint(value={"ViewConstructor"})
public abstract class GSYVideoGLViewBaseRender
implements GLSurfaceView.Renderer,
SurfaceTexture.OnFrameAvailableListener {
    protected boolean mHighShot = false;
    protected GSYVideoGLView.onGSYSurfaceListener mGSYSurfaceListener;
    protected GLSurfaceView mSurfaceView;

    public abstract void releaseAll();

    public void setSurfaceView(GLSurfaceView surfaceView) {
        this.mSurfaceView = surfaceView;
    }

    public void sendSurfaceForPlayer(Surface surface) {
        if (this.mGSYSurfaceListener != null) {
            this.mGSYSurfaceListener.onSurfaceAvailable(surface);
        }
    }

    protected int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                Debuger.printfError("Could not compile shader " + shaderType + ":");
                Debuger.printfError(GLES20.glGetShaderInfoLog((int)shader));
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    protected int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = this.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertexShader);
            this.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)program, (int)pixelShader);
            this.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                Debuger.printfError("Could not link program: ");
                Debuger.printfError(GLES20.glGetProgramInfoLog((int)program));
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    protected void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            Debuger.printfError(op + ": glError " + error);
            throw new RuntimeException(op + ": glError " + error);
        }
    }

    protected Bitmap createBitmapFromGLSurface(int x, int y, int w, int h, GL10 gl) {
        int[] bitmapBuffer = new int[w * h];
        int[] bitmapSource = new int[w * h];
        IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
        intBuffer.position(0);
        try {
            gl.glReadPixels(x, y, w, h, 6408, 5121, (Buffer)intBuffer);
            for (int i = 0; i < h; ++i) {
                int offset1 = i * w;
                int offset2 = (h - i - 1) * w;
                for (int j = 0; j < w; ++j) {
                    int pixel;
                    int texturePixel = bitmapBuffer[offset1 + j];
                    int blue = texturePixel >> 16 & 0xFF;
                    int red = texturePixel << 16 & 0xFF0000;
                    bitmapSource[offset2 + j] = pixel = texturePixel & 0xFF00FF00 | red | blue;
                }
            }
        }
        catch (GLException e) {
            return null;
        }
        if (this.mHighShot) {
            return Bitmap.createBitmap((int[])bitmapSource, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return Bitmap.createBitmap((int[])bitmapSource, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    public void setGSYSurfaceListener(GSYVideoGLView.onGSYSurfaceListener onSurfaceListener) {
        this.mGSYSurfaceListener = onSurfaceListener;
    }

    public void setMVPMatrix(float[] MVPMatrix) {
    }

    public void takeShotPic() {
    }

    public void setGSYVideoShotListener(GSYVideoShotListener listener, boolean high) {
    }

    public void setEffect(GSYVideoGLView.ShaderInterface shaderEffect) {
    }
}

