/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;

public class SmallVideoTouch
implements View.OnTouchListener {
    private int mDownX;
    private int mDownY;
    private int mMarginLeft;
    private int mMarginTop;
    private int _xDelta;
    private int _yDelta;
    private GSYBaseVideoPlayer mGsyBaseVideoPlayer;

    public SmallVideoTouch(GSYBaseVideoPlayer gsyBaseVideoPlayer, int marginLeft, int marginTop) {
        this.mMarginLeft = marginLeft;
        this.mMarginTop = marginTop;
        this.mGsyBaseVideoPlayer = gsyBaseVideoPlayer;
    }

    public boolean onTouch(View view, MotionEvent event) {
        int X = (int)event.getRawX();
        int Y = (int)event.getRawY();
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mDownX = X;
                this.mDownY = Y;
                FrameLayout.LayoutParams lParams = (FrameLayout.LayoutParams)this.mGsyBaseVideoPlayer.getLayoutParams();
                this._xDelta = X - lParams.leftMargin;
                this._yDelta = Y - lParams.topMargin;
                break;
            }
            case 1: {
                return Math.abs(this.mDownY - Y) >= 5 || Math.abs(this.mDownX - X) >= 5;
            }
            case 2: {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mGsyBaseVideoPlayer.getLayoutParams();
                layoutParams.leftMargin = X - this._xDelta;
                layoutParams.topMargin = Y - this._yDelta;
                if (layoutParams.leftMargin >= this.mMarginLeft) {
                    layoutParams.leftMargin = this.mMarginLeft;
                }
                if (layoutParams.topMargin >= this.mMarginTop) {
                    layoutParams.topMargin = this.mMarginTop;
                }
                if (layoutParams.leftMargin <= 0) {
                    layoutParams.leftMargin = 0;
                }
                if (layoutParams.topMargin <= 0) {
                    layoutParams.topMargin = 0;
                }
                this.mGsyBaseVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        return false;
    }
}

