/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.PixelCopy;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.render.GSYRenderView;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.render.view.IGSYRenderView;
import com.shuyu.gsyvideoplayer.render.view.listener.IGSYSurfaceListener;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;
import java.io.File;

public class GSYSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback2,
IGSYRenderView,
MeasureHelper.MeasureFormVideoParamsListener {
    private IGSYSurfaceListener mIGSYSurfaceListener;
    private MeasureHelper.MeasureFormVideoParamsListener mVideoParamsListener;
    private MeasureHelper measureHelper;

    public GSYSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GSYSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.measureHelper = new MeasureHelper((View)this, this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureHelper.prepareMeasure(widthMeasureSpec, heightMeasureSpec, (int)this.getRotation());
        this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceAvailable(holder.getSurface());
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceSizeChanged(holder.getSurface(), width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceDestroyed(holder.getSurface());
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
    }

    @Override
    public IGSYSurfaceListener getIGSYSurfaceListener() {
        return this.mIGSYSurfaceListener;
    }

    @Override
    public void setIGSYSurfaceListener(IGSYSurfaceListener surfaceListener) {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mIGSYSurfaceListener = surfaceListener;
    }

    @Override
    public int getSizeH() {
        return this.getHeight();
    }

    @Override
    public int getSizeW() {
        return this.getWidth();
    }

    @Override
    public Bitmap initCover() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getSizeW(), (int)this.getSizeH(), (Bitmap.Config)Bitmap.Config.RGB_565);
        return bitmap;
    }

    @Override
    public Bitmap initCoverHigh() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getSizeW(), (int)this.getSizeH(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return bitmap;
    }

    @Override
    public void taskShotPic(final GSYVideoShotListener gsyVideoShotListener, boolean shotHigh) {
        final Bitmap bitmap = shotHigh ? this.initCoverHigh() : this.initCover();
        try {
            final HandlerThread handlerThread = new HandlerThread("PixelCopier");
            handlerThread.start();
            if (Build.VERSION.SDK_INT >= 24) {
                PixelCopy.request((SurfaceView)this, (Bitmap)bitmap, (PixelCopy.OnPixelCopyFinishedListener)new PixelCopy.OnPixelCopyFinishedListener(){

                    public void onPixelCopyFinished(int copyResult) {
                        if (copyResult == 0) {
                            gsyVideoShotListener.getBitmap(bitmap);
                        }
                        handlerThread.quitSafely();
                    }
                }, (Handler)new Handler());
            } else {
                Debuger.printfLog(this.getClass().getSimpleName() + " Build.VERSION.SDK_INT < Build.VERSION_CODES.N not support taskShotPic now");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveFrame(File file, boolean high, GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support saveFrame now, use taskShotPic");
    }

    @Override
    public View getRenderView() {
        return this;
    }

    @Override
    public void onRenderResume() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support onRenderResume now");
    }

    @Override
    public void onRenderPause() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support onRenderPause now");
    }

    @Override
    public void releaseRenderAll() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support releaseRenderAll now");
    }

    @Override
    public void setRenderMode(int mode) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setRenderMode now");
    }

    @Override
    public void setRenderTransform(Matrix transform) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setRenderTransform now");
    }

    @Override
    public void setGLRenderer(GSYVideoGLViewBaseRender renderer) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setGLRenderer now");
    }

    @Override
    public void setGLMVPMatrix(float[] MVPMatrix) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setGLMVPMatrix now");
    }

    @Override
    public void setGLEffectFilter(GSYVideoGLView.ShaderInterface effectFilter) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setGLEffectFilter now");
    }

    @Override
    public void setVideoParamsListener(MeasureHelper.MeasureFormVideoParamsListener listener) {
        this.mVideoParamsListener = listener;
    }

    @Override
    public int getCurrentVideoWidth() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getCurrentVideoWidth();
        }
        return 0;
    }

    @Override
    public int getCurrentVideoHeight() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getCurrentVideoHeight();
        }
        return 0;
    }

    @Override
    public int getVideoSarNum() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getVideoSarNum();
        }
        return 0;
    }

    @Override
    public int getVideoSarDen() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getVideoSarDen();
        }
        return 0;
    }

    public static GSYSurfaceView addSurfaceView(Context context, ViewGroup textureViewContainer, int rotate, IGSYSurfaceListener gsySurfaceListener, MeasureHelper.MeasureFormVideoParamsListener videoParamsListener) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYSurfaceView showSurfaceView = new GSYSurfaceView(context);
        showSurfaceView.setIGSYSurfaceListener(gsySurfaceListener);
        showSurfaceView.setVideoParamsListener(videoParamsListener);
        showSurfaceView.setRotation(rotate);
        GSYRenderView.addToParent(textureViewContainer, (View)showSurfaceView);
        return showSurfaceView;
    }
}

