/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.builder.GSYVideoOptionBuilder;
import com.shuyu.gsyvideoplayer.listener.VideoAllCallBack;
import com.shuyu.gsyvideoplayer.utils.OrientationOption;
import com.shuyu.gsyvideoplayer.utils.OrientationUtils;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoControlView;

public abstract class GSYBaseActivityDetail<T extends GSYBaseVideoPlayer>
extends AppCompatActivity
implements VideoAllCallBack {
    protected boolean isPlay;
    protected boolean isPause;
    protected OrientationUtils orientationUtils;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void initVideo() {
        this.orientationUtils = new OrientationUtils((Activity)this, (GSYBaseVideoPlayer)this.getGSYVideoPlayer(), this.getOrientationOption());
        this.orientationUtils.setEnable(false);
        if (((GSYVideoControlView)this.getGSYVideoPlayer()).getFullscreenButton() != null) {
            ((GSYVideoControlView)this.getGSYVideoPlayer()).getFullscreenButton().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYBaseActivityDetail.this.showFull();
                    GSYBaseActivityDetail.this.clickForFullScreen();
                }
            });
        }
    }

    public void initVideoBuilderMode() {
        this.initVideo();
        this.getGSYVideoOptionBuilder().setVideoAllCallBack(this).build((GSYBaseVideoPlayer)this.getGSYVideoPlayer());
    }

    public void showFull() {
        if (this.orientationUtils.getIsLand() != 1) {
            this.orientationUtils.resolveByClick();
        }
        ((GSYBaseVideoPlayer)this.getGSYVideoPlayer()).startWindowFullscreen((Context)this, this.hideActionBarWhenFull(), this.hideStatusBarWhenFull());
    }

    public void onBackPressed() {
        if (this.orientationUtils != null) {
            this.orientationUtils.backToProtVideo();
        }
        if (GSYVideoManager.backFromWindowFull((Context)this)) {
            return;
        }
        super.onBackPressed();
    }

    protected void onPause() {
        super.onPause();
        ((GSYBaseVideoPlayer)this.getGSYVideoPlayer()).getCurrentPlayer().onVideoPause();
        if (this.orientationUtils != null) {
            this.orientationUtils.setIsPause(true);
        }
        this.isPause = true;
    }

    protected void onResume() {
        super.onResume();
        ((GSYBaseVideoPlayer)this.getGSYVideoPlayer()).getCurrentPlayer().onVideoResume();
        if (this.orientationUtils != null) {
            this.orientationUtils.setIsPause(false);
        }
        this.isPause = false;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.isPlay) {
            ((GSYBaseVideoPlayer)this.getGSYVideoPlayer()).getCurrentPlayer().release();
        }
        if (this.orientationUtils != null) {
            this.orientationUtils.releaseListener();
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.isPlay && !this.isPause) {
            ((GSYBaseVideoPlayer)this.getGSYVideoPlayer()).onConfigurationChanged((Activity)this, newConfig, this.orientationUtils, this.hideActionBarWhenFull(), this.hideStatusBarWhenFull());
        }
    }

    @Override
    public void onStartPrepared(String url, Object ... objects) {
    }

    @Override
    public void onPrepared(String url, Object ... objects) {
        if (this.orientationUtils == null) {
            throw new NullPointerException("initVideo() or initVideoBuilderMode() first");
        }
        this.orientationUtils.setEnable(this.getDetailOrientationRotateAuto() && !this.isAutoFullWithSize());
        this.isPlay = true;
    }

    @Override
    public void onClickStartIcon(String url, Object ... objects) {
    }

    @Override
    public void onClickStartError(String url, Object ... objects) {
    }

    @Override
    public void onClickStop(String url, Object ... objects) {
    }

    @Override
    public void onClickStopFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onClickResume(String url, Object ... objects) {
    }

    @Override
    public void onClickResumeFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onClickSeekbar(String url, Object ... objects) {
    }

    @Override
    public void onClickSeekbarFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onAutoComplete(String url, Object ... objects) {
    }

    @Override
    public void onEnterFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onQuitFullscreen(String url, Object ... objects) {
        if (this.orientationUtils != null) {
            this.orientationUtils.backToProtVideo();
        }
    }

    @Override
    public void onQuitSmallWidget(String url, Object ... objects) {
    }

    @Override
    public void onEnterSmallWidget(String url, Object ... objects) {
    }

    @Override
    public void onTouchScreenSeekVolume(String url, Object ... objects) {
    }

    @Override
    public void onTouchScreenSeekPosition(String url, Object ... objects) {
    }

    @Override
    public void onTouchScreenSeekLight(String url, Object ... objects) {
    }

    @Override
    public void onPlayError(String url, Object ... objects) {
    }

    @Override
    public void onClickStartThumb(String url, Object ... objects) {
    }

    @Override
    public void onClickBlank(String url, Object ... objects) {
    }

    @Override
    public void onClickBlankFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onComplete(String url, Object ... objects) {
    }

    public boolean hideActionBarWhenFull() {
        return true;
    }

    public boolean hideStatusBarWhenFull() {
        return true;
    }

    public OrientationOption getOrientationOption() {
        return null;
    }

    public abstract T getGSYVideoPlayer();

    public abstract GSYVideoOptionBuilder getGSYVideoOptionBuilder();

    public abstract void clickForFullScreen();

    public abstract boolean getDetailOrientationRotateAuto();

    public boolean isAutoFullWithSize() {
        return false;
    }
}

