/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.waveview;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class FileUtils {
    public static final String NAME = "audioWave";

    public static String getAppPath(Context context) {
        StringBuilder sb = new StringBuilder();
        File externalFilesDir = context.getExternalFilesDir(null);
        if (externalFilesDir != null && Environment.getExternalStorageState().equals("mounted")) {
            sb.append(externalFilesDir.getPath());
        } else {
            sb.append(context.getFilesDir().getPath());
        }
        sb.append(File.separator);
        sb.append(NAME);
        sb.append(File.separator);
        File dir = new File(sb.toString());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return sb.toString();
    }

    @Deprecated
    public static String getAppPath() {
        StringBuilder sb = new StringBuilder();
        String sdState = Environment.getExternalStorageState();
        if (sdState.equals("mounted")) {
            sb.append(Environment.getExternalStorageDirectory().getPath());
        } else {
            sb.append(Environment.getDataDirectory().getPath());
        }
        sb.append(File.separator);
        sb.append(NAME);
        sb.append(File.separator);
        return sb.toString();
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                String[] filePaths = file.list();
                if (filePaths != null) {
                    for (String path : filePaths) {
                        FileUtils.deleteFile(filePath + File.separator + path);
                    }
                }
                file.delete();
            }
        }
    }
}

