/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.waveview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewTreeObserver;
import com.BaseRecorder;
import com.shuyu.waveview.R;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class AudioWaveTextureView
extends TextureView {
    public static final String MAX = "max_volume";
    public static final String MIN = "min_volume";
    protected final Object mLock = new Object();
    private Context mContext;
    private Bitmap mBackgroundBitmap;
    private Paint mPaint;
    private Canvas mBackCanVans = new Canvas();
    private ArrayList<Short> mRecDataList = new ArrayList();
    private drawThread mInnerThread;
    private BaseRecorder mBaseRecorder;
    private int mWidthSpecSize;
    private int mHeightSpecSize;
    private int mScale = 1;
    private int mBaseLine;
    private int mOffset = -11;
    private boolean mAlphaByVolume;
    private boolean mIsDraw = true;
    private boolean mDrawBase = true;
    private boolean mDrawReverse = false;
    private boolean mDataReverse = false;
    private int mWaveCount = 2;
    private int mWaveColor = -1;
    private int mColorPoint = 1;
    private int mPreFFtCurrentFrequency;
    private int mColorChangeFlag;
    private int mColorBack = 0;
    private int mColor1 = Color.argb((int)250, (int)111, (int)255, (int)129);
    private int mColor2 = Color.argb((int)250, (int)255, (int)255, (int)255);
    private int mColor3 = Color.argb((int)250, (int)66, (int)255, (int)255);
    private int mDrawStartOffset = 0;
    private Surface mSurface;
    private Rect mRect = new Rect();

    public AudioWaveTextureView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AudioWaveTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AudioWaveTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsDraw = false;
        if (this.mBackgroundBitmap != null && !this.mBackgroundBitmap.isRecycled()) {
            this.mBackgroundBitmap.recycle();
        }
    }

    public void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        if (this.isInEditMode()) {
            return;
        }
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.waveView);
            this.mOffset = ta.getInt(R.styleable.waveView_gsyWaveOffset, this.dip2px(context, -11.0f));
            this.mWaveColor = ta.getColor(R.styleable.waveView_gsyWaveColor, -1);
            this.mColorBack = ta.getColor(R.styleable.waveView_gsyTexture_bg_waveColor, 0);
            this.mWaveCount = ta.getInt(R.styleable.waveView_gsyWaveCount, 2);
            ta.recycle();
        }
        if (this.mOffset == this.dip2px(context, -11.0f)) {
            this.mOffset = this.dip2px(context, 1.0f);
        }
        if (this.mWaveCount < 1) {
            this.mWaveCount = 1;
        } else if (this.mWaveCount > 2) {
            this.mWaveCount = 2;
        }
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mWaveColor);
        this.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                AudioWaveTextureView.this.mSurface = new Surface(surface);
                AudioWaveTextureView.this.updateBackground();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                Object object = AudioWaveTextureView.this.mLock;
                synchronized (object) {
                    AudioWaveTextureView.this.mSurface = null;
                }
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.creatBackGroundBitmap();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mRect.top = top;
        this.mRect.left = left;
        this.mRect.right = right;
        this.mRect.bottom = bottom;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0 && this.mBackgroundBitmap == null) {
            this.creatBackGroundBitmap();
        }
    }

    private void creatBackGroundBitmap() {
        ViewTreeObserver vto = this.getViewTreeObserver();
        vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (AudioWaveTextureView.this.getWidth() > 0 && AudioWaveTextureView.this.getHeight() > 0) {
                    AudioWaveTextureView.this.mWidthSpecSize = AudioWaveTextureView.this.getWidth();
                    AudioWaveTextureView.this.mHeightSpecSize = AudioWaveTextureView.this.getHeight();
                    AudioWaveTextureView.this.mBaseLine = AudioWaveTextureView.this.mHeightSpecSize / 2;
                    AudioWaveTextureView.this.mBackgroundBitmap = Bitmap.createBitmap((int)AudioWaveTextureView.this.mWidthSpecSize, (int)AudioWaveTextureView.this.mHeightSpecSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    AudioWaveTextureView.this.mBackCanVans.setBitmap(AudioWaveTextureView.this.mBackgroundBitmap);
                    ViewTreeObserver vto = AudioWaveTextureView.this.getViewTreeObserver();
                    vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBackground() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSurface != null) {
                Canvas canvas = this.mSurface.lockCanvas(this.mRect);
                canvas.drawColor(this.mColorBack);
                this.mSurface.unlockCanvasAndPost(canvas);
            }
        }
    }

    private void drawNow(Short sh, int j) {
        if (sh != null) {
            short max = (short)(this.mBaseLine - sh / this.mScale);
            short min = this.mWaveCount == 2 ? (short)(sh / this.mScale + this.mBaseLine) : (short)this.mBaseLine;
            this.mBackCanVans.drawLine((float)j, (float)this.mBaseLine, (float)j, (float)max, this.mPaint);
            this.mBackCanVans.drawLine((float)j, (float)min, (float)j, (float)this.mBaseLine, this.mPaint);
        }
    }

    public List deepCopy(List src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(src);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        List dest = (List)in.readObject();
        return dest;
    }

    private void resolveToWaveData(ArrayList<Short> list) {
        short allMax = 0;
        for (int i = 0; i < list.size(); ++i) {
            Short sh = list.get(i);
            if (sh == null || sh <= allMax) continue;
            allMax = sh;
        }
        int curScale = allMax / this.mBaseLine;
        if (curScale > this.mScale) {
            this.mScale = curScale == 0 ? 1 : curScale;
        }
    }

    public void startView() {
        if (this.mInnerThread != null && this.mInnerThread.isAlive()) {
            this.mIsDraw = false;
            while (this.mInnerThread.isAlive()) {
            }
            this.mBackCanVans.drawColor(this.mColorBack, PorterDuff.Mode.CLEAR);
        }
        this.mIsDraw = true;
        this.mInnerThread = new drawThread();
        this.mInnerThread.start();
    }

    public void stopView() {
        this.mIsDraw = false;
        this.mRecDataList.clear();
        if (this.mInnerThread != null) {
            while (this.mInnerThread.isAlive()) {
            }
        }
        this.mBackCanVans.drawColor(this.mColorBack, PorterDuff.Mode.CLEAR);
    }

    private void updateColor() {
        if (this.mBaseRecorder == null) {
            return;
        }
        int volume = this.mBaseRecorder.getRealVolume();
        int scale = volume / 100;
        if (scale < 5) {
            this.mPreFFtCurrentFrequency = scale;
            return;
        }
        int fftScale = 0;
        if (this.mPreFFtCurrentFrequency != 0) {
            fftScale = scale / this.mPreFFtCurrentFrequency;
        }
        if (this.mColorChangeFlag == 4 || fftScale > 10) {
            this.mColorChangeFlag = 0;
        }
        if (this.mColorChangeFlag == 0) {
            if (this.mColorPoint == 1) {
                this.mColorPoint = 2;
            } else if (this.mColorPoint == 2) {
                this.mColorPoint = 3;
            } else if (this.mColorPoint == 3) {
                this.mColorPoint = 1;
            }
            int color = this.mColorPoint == 1 ? Color.argb((int)(this.mAlphaByVolume ? 50 * scale : 255), (int)Color.red((int)this.mColor1), (int)Color.green((int)this.mColor1), (int)Color.blue((int)this.mColor1)) : (this.mColorPoint == 2 ? Color.argb((int)(this.mAlphaByVolume ? 50 * scale : 255), (int)Color.red((int)this.mColor2), (int)Color.green((int)this.mColor2), (int)Color.blue((int)this.mColor2)) : Color.argb((int)(this.mAlphaByVolume ? 50 * scale : 255), (int)Color.red((int)this.mColor3), (int)Color.green((int)this.mColor3), (int)Color.blue((int)this.mColor3)));
            this.mPaint.setColor(color);
        }
        ++this.mColorChangeFlag;
        if (scale != 0) {
            this.mPreFFtCurrentFrequency = scale;
        }
    }

    public void setChangeColor(int color1, int color2, int color3) {
        this.mColor1 = color1;
        this.mColor2 = color2;
        this.mColor3 = color3;
    }

    public boolean isAlphaByVolume() {
        return this.mAlphaByVolume;
    }

    public void setAlphaByVolume(boolean alphaByVolume) {
        this.mAlphaByVolume = alphaByVolume;
    }

    public void setBaseRecorder(BaseRecorder baseRecorder) {
        this.mBaseRecorder = baseRecorder;
    }

    public ArrayList<Short> getRecList() {
        return this.mRecDataList;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public int getWaveColor() {
        return this.mWaveColor;
    }

    public void setWaveColor(int waveColor) {
        this.mWaveColor = waveColor;
        if (this.mPaint != null) {
            this.mPaint.setColor(this.mWaveColor);
        }
    }

    public void setWaveCount(int waveCount) {
        this.mWaveCount = waveCount;
        if (this.mWaveCount < 1) {
            this.mWaveCount = 1;
        } else if (this.mWaveCount > 2) {
            this.mWaveCount = 2;
        }
    }

    public void setLinePaint(Paint paint) {
        if (paint != null) {
            this.mPaint = paint;
        }
    }

    private int dip2px(Context context, float dipValue) {
        float fontScale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * fontScale + 0.5f);
    }

    public void setDrawBase(boolean drawBase) {
        this.mDrawBase = drawBase;
    }

    public void setDrawReverse(boolean drawReverse) {
        this.mDrawReverse = drawReverse;
    }

    public void setDataReverse(boolean dataReverse) {
        this.mDataReverse = dataReverse;
    }

    public void setDrawStartOffset(int drawStartOffset) {
        this.mDrawStartOffset = drawStartOffset;
    }

    public void setColorBack(int colorBack) {
        this.mColorBack = colorBack;
        this.updateBackground();
    }

    private class drawThread
    extends Thread {
        private drawThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AudioWaveTextureView.this.mIsDraw) {
                ArrayList dataList = new ArrayList();
                ArrayList arrayList = AudioWaveTextureView.this.mRecDataList;
                synchronized (arrayList) {
                    if (AudioWaveTextureView.this.mRecDataList.size() != 0) {
                        try {
                            dataList = (ArrayList)AudioWaveTextureView.this.deepCopy(AudioWaveTextureView.this.mRecDataList);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                }
                if (AudioWaveTextureView.this.mBackgroundBitmap == null) continue;
                AudioWaveTextureView.this.resolveToWaveData(dataList);
                if (dataList.size() > 0) {
                    AudioWaveTextureView.this.updateColor();
                }
                if (AudioWaveTextureView.this.mBackCanVans != null) {
                    Short sh;
                    int j;
                    int i;
                    int jOffset;
                    AudioWaveTextureView.this.mBackCanVans.drawColor(AudioWaveTextureView.this.mColorBack, PorterDuff.Mode.CLEAR);
                    AudioWaveTextureView.this.mBackCanVans.drawColor(AudioWaveTextureView.this.mColorBack);
                    int drawBufsize = dataList.size();
                    int startPosition = AudioWaveTextureView.this.mDrawReverse ? AudioWaveTextureView.this.mWidthSpecSize - AudioWaveTextureView.this.mDrawStartOffset : AudioWaveTextureView.this.mDrawStartOffset;
                    int n = jOffset = AudioWaveTextureView.this.mDrawReverse ? -AudioWaveTextureView.this.mOffset : AudioWaveTextureView.this.mOffset;
                    if (AudioWaveTextureView.this.mDrawBase) {
                        if (AudioWaveTextureView.this.mDataReverse) {
                            AudioWaveTextureView.this.mBackCanVans.drawLine((float)startPosition, (float)AudioWaveTextureView.this.mBaseLine, 0.0f, (float)AudioWaveTextureView.this.mBaseLine, AudioWaveTextureView.this.mPaint);
                        } else {
                            AudioWaveTextureView.this.mBackCanVans.drawLine((float)startPosition, (float)AudioWaveTextureView.this.mBaseLine, (float)AudioWaveTextureView.this.mWidthSpecSize, (float)AudioWaveTextureView.this.mBaseLine, AudioWaveTextureView.this.mPaint);
                        }
                    }
                    if (AudioWaveTextureView.this.mDataReverse) {
                        i = drawBufsize - 1;
                        j = startPosition;
                        while (i >= 0) {
                            sh = (Short)dataList.get(i);
                            AudioWaveTextureView.this.drawNow(sh, j);
                            --i;
                            j += jOffset;
                        }
                    } else {
                        i = 0;
                        j = startPosition;
                        while (i < drawBufsize) {
                            sh = (Short)dataList.get(i);
                            AudioWaveTextureView.this.drawNow(sh, j);
                            ++i;
                            j += jOffset;
                        }
                    }
                    if (AudioWaveTextureView.this.mSurface != null) {
                        Object object = AudioWaveTextureView.this.mLock;
                        synchronized (object) {
                            if (AudioWaveTextureView.this.mSurface != null && AudioWaveTextureView.this.mIsDraw) {
                                Canvas canvas = AudioWaveTextureView.this.mSurface.lockCanvas(AudioWaveTextureView.this.mRect);
                                canvas.drawColor(AudioWaveTextureView.this.mColorBack, PorterDuff.Mode.CLEAR);
                                canvas.drawBitmap(AudioWaveTextureView.this.mBackgroundBitmap, 0.0f, 0.0f, AudioWaveTextureView.this.mPaint);
                                AudioWaveTextureView.this.mSurface.unlockCanvasAndPost(canvas);
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

