/*
 * Decompiled with CFR 0.152.
 */
package com.piterwilson.audio;

import android.content.Context;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.BaseRecorder;
import com.piterwilson.audio.MP3RadioStreamDelegate;
import com.shuyu.waveview.Manager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class MP3RadioStreamPlayer
extends BaseRecorder {
    public final String LOG_TAG = "MP3RadioStreamPlayer";
    protected MediaExtractor extractor;
    protected MediaCodec codec;
    protected AudioTrack audioTrack;
    protected int inputBufIndex;
    protected int bufIndexCheck;
    protected int lastInputBufIndex;
    protected Boolean doStop = false;
    protected MP3RadioStreamDelegate mDelegate;
    private ArrayList<Short> dataList;
    private int maxSize;
    private int seekOffset = 0;
    private boolean seekOffsetFlag = false;
    private boolean isLoop = false;
    private boolean hadPlay = false;
    private boolean pause;
    private long duration;
    private long curPosition;
    private long startWaveTime = 0L;
    State mState = State.Retrieving;
    private String mUrlString;
    private DelegateHandler mDelegateHandler = new DelegateHandler();
    Timer myTimer;
    CheckProgressTimerTask myTimerTask;

    public void setDelegate(MP3RadioStreamDelegate mDelegate) {
        this.mDelegate = mDelegate;
    }

    public MP3RadioStreamDelegate getDelegate() {
        return this.mDelegate;
    }

    public State getState() {
        return this.mState;
    }

    public void setUrlString(String urlString) {
        this.setUrlString(null, false, urlString);
    }

    public void setUrlString(Context context, boolean cache, String urlString) {
        String url = urlString;
        if (context != null && cache && !TextUtils.isEmpty((CharSequence)urlString) && urlString.startsWith("http")) {
            url = Manager.newInstance().getProxy(context).getProxyUrl(urlString);
        }
        this.mUrlString = url;
    }

    public String getUrlString() {
        return this.mUrlString;
    }

    public MP3RadioStreamPlayer() {
        this.mState = State.Stopped;
    }

    public void play() throws IOException {
        this.mState = State.Retrieving;
        this.mDelegateHandler.onRadioPlayerBuffering(this);
        this.doStop = false;
        this.bufIndexCheck = 0;
        this.lastInputBufIndex = -1;
        if (this.startWaveTime > 0L) {
            this.seekOffsetFlag = true;
        }
        this.myTimerTask = new CheckProgressTimerTask();
        this.myTimer = new Timer();
        this.myTimer.scheduleAtFixedRate((TimerTask)this.myTimerTask, 0L, 1000L);
        new DecodeOperation().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void decodeLoop() {
        this.extractor = new MediaExtractor();
        try {
            this.extractor.setDataSource(this.mUrlString);
        }
        catch (Exception e) {
            this.mDelegateHandler.onRadioPlayerError(this);
            return;
        }
        MediaFormat format = this.extractor.getTrackFormat(0);
        String mime = format.getString("mime");
        if (!mime.startsWith("audio/")) {
            Log.e((String)"MP3RadioStreamPlayer", (String)"\u4e0d\u662f\u97f3\u9891\u6587\u4ef6!");
            return;
        }
        int channels = format.getInteger("channel-count");
        this.duration = format.getLong("durationUs");
        try {
            this.codec = MediaCodec.createDecoderByType((String)mime);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.codec.configure(format, null, null, 0);
        this.codec.start();
        ByteBuffer[] codecInputBuffers = this.codec.getInputBuffers();
        ByteBuffer[] codecOutputBuffers = this.codec.getOutputBuffers();
        int sampleRate = format.getInteger("sample-rate");
        int channelConfiguration = channels == 1 ? 4 : 12;
        Log.i((String)"MP3RadioStreamPlayer", (String)("mime " + mime));
        Log.i((String)"MP3RadioStreamPlayer", (String)("sampleRate " + sampleRate));
        this.audioTrack = new AudioTrack(3, sampleRate, channelConfiguration, 2, AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfiguration, (int)2), 1);
        this.audioTrack.play();
        this.extractor.selectTrack(0);
        long kTimeOutUs = 10000L;
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        boolean sawInputEOS = false;
        boolean sawOutputEOS = false;
        int noOutputCounter = 0;
        int noOutputCounterLimit = 50;
        while (!sawOutputEOS && noOutputCounter < noOutputCounterLimit && !this.doStop.booleanValue()) {
            int res;
            if (this.pause) {
                this.mState = State.Pause;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            ++noOutputCounter;
            if (!sawInputEOS) {
                if (this.seekOffsetFlag) {
                    this.seekOffsetFlag = false;
                    long seek = this.startWaveTime > (long)this.seekOffset ? this.startWaveTime : (long)this.seekOffset;
                    this.extractor.seekTo(seek, 0);
                }
                this.inputBufIndex = this.codec.dequeueInputBuffer(10000L);
                ++this.bufIndexCheck;
                if (this.inputBufIndex >= 0) {
                    ByteBuffer dstBuf = codecInputBuffers[this.inputBufIndex];
                    int sampleSize = this.extractor.readSampleData(dstBuf, 0);
                    long presentationTimeUs = 0L;
                    if (sampleSize < 0) {
                        Log.d((String)"MP3RadioStreamPlayer", (String)"saw input EOS.");
                        sawInputEOS = true;
                        sampleSize = 0;
                    } else {
                        presentationTimeUs = this.extractor.getSampleTime();
                    }
                    this.curPosition = presentationTimeUs;
                    this.codec.queueInputBuffer(this.inputBufIndex, 0, sampleSize, presentationTimeUs, sawInputEOS ? 4 : 0);
                    if (!sawInputEOS) {
                        this.extractor.advance();
                    }
                } else {
                    Log.e((String)"MP3RadioStreamPlayer", (String)("inputBufIndex " + this.inputBufIndex));
                }
            }
            if ((res = this.codec.dequeueOutputBuffer(info, 10000L)) >= 0) {
                if (info.size > 0) {
                    noOutputCounter = 0;
                }
                int outputBufIndex = res;
                ByteBuffer buf = codecOutputBuffers[outputBufIndex];
                byte[] chunk = new byte[info.size];
                buf.get(chunk);
                buf.clear();
                if (chunk.length > 0 && this.audioTrack != null && !this.doStop.booleanValue()) {
                    this.audioTrack.write(chunk, 0, chunk.length);
                    short[] music = !this.isBigEnd() ? this.byteArray2ShortArrayLittle(chunk, chunk.length / 2) : this.byteArray2ShortArrayBig(chunk, chunk.length / 2);
                    this.sendData(music, music.length);
                    this.calculateRealVolume(music, music.length);
                    if (this.mState != State.Playing) {
                        this.mDelegateHandler.onRadioPlayerPlaybackStarted(this);
                    }
                    this.mState = State.Playing;
                    this.hadPlay = true;
                }
                this.codec.releaseOutputBuffer(outputBufIndex, false);
                if ((info.flags & 4) == 0) continue;
                Log.d((String)"MP3RadioStreamPlayer", (String)"saw output EOS.");
                sawOutputEOS = true;
                continue;
            }
            if (res == -3) {
                codecOutputBuffers = this.codec.getOutputBuffers();
                Log.d((String)"MP3RadioStreamPlayer", (String)"output buffers have changed.");
                continue;
            }
            if (res == -2) {
                MediaFormat oformat = this.codec.getOutputFormat();
                Log.d((String)"MP3RadioStreamPlayer", (String)("output format has changed to " + oformat));
                continue;
            }
            Log.d((String)"MP3RadioStreamPlayer", (String)("dequeueOutputBuffer returned " + res));
        }
        Log.d((String)"MP3RadioStreamPlayer", (String)"stopping...");
        this.relaxResources(true);
        this.mState = State.Stopped;
        this.doStop = true;
        if (sawOutputEOS) {
            try {
                if (this.isLoop || !this.hadPlay) {
                    this.play();
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (noOutputCounter >= noOutputCounterLimit) {
            this.mDelegateHandler.onRadioPlayerError(this);
        } else {
            this.mDelegateHandler.onRadioPlayerStopped(this);
        }
    }

    public void release() {
        this.stop();
        this.relaxResources(false);
    }

    private void relaxResources(Boolean release) {
        if (this.codec != null && release.booleanValue()) {
            this.codec.stop();
            this.codec.release();
            this.codec = null;
        }
        if (this.audioTrack != null) {
            if (!this.doStop.booleanValue()) {
                this.audioTrack.flush();
            }
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    public void stop() {
        this.pause = false;
        this.doStop = true;
        this.seekOffset = 0;
        this.seekOffsetFlag = false;
        if (this.myTimer != null) {
            this.myTimer.cancel();
            this.myTimer = null;
        }
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
            this.myTimerTask = null;
        }
    }

    private boolean isBigEnd() {
        int i = 1;
        boolean bRet = i >> 8 == 1;
        return bRet;
    }

    private short[] byteArray2ShortArrayBig(byte[] data, int items) {
        short[] retVal = new short[items];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = (short)(data[i * 2 + 1] & 0xFF | (data[i * 2] & 0xFF) << 8);
        }
        return retVal;
    }

    private short[] byteArray2ShortArrayLittle(byte[] data, int items) {
        short[] retVal = new short[items];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = (short)(data[i * 2] & 0xFF | (data[i * 2 + 1] & 0xFF) << 8);
        }
        return retVal;
    }

    private void sendData(short[] shorts, int readSize) {
        if (this.dataList != null && this.getCurPosition() >= this.startWaveTime) {
            int length = readSize / 300;
            short resultMax = 0;
            short resultMin = 0;
            int i = 0;
            int k = 0;
            while (i < length) {
                short max = 0;
                short min = 1000;
                for (int j = k; j < k + 300; j = (int)((short)(j + 1))) {
                    if (shorts[j] > max) {
                        resultMax = max = shorts[j];
                        continue;
                    }
                    if (shorts[j] >= min) continue;
                    resultMin = min = shorts[j];
                }
                if (this.dataList.size() > this.maxSize) {
                    this.dataList.remove(0);
                }
                this.dataList.add(resultMax);
                i = (short)(i + 1);
                k = (short)(k + 300);
            }
        }
    }

    @Override
    public int getRealVolume() {
        return this.mVolume;
    }

    public void setDataList(ArrayList<Short> dataList, int maxSize) {
        this.dataList = dataList;
        this.maxSize = maxSize;
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public void setLoop(boolean loop) {
        this.isLoop = loop;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public void seekTo(int time) {
        if ((long)time >= this.duration || this.pause) {
            return;
        }
        this.stop();
        this.seekOffsetFlag = true;
        this.seekOffset = time;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    MP3RadioStreamPlayer.this.play();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 300L);
    }

    public long getCurPosition() {
        return this.curPosition;
    }

    public long getStartWaveTime() {
        return this.startWaveTime;
    }

    public void setStartWaveTime(long startWaveTime) {
        this.startWaveTime = startWaveTime * 1000L;
    }

    private class DecodeOperation
    extends AsyncTask<Void, Void, Void> {
        private DecodeOperation() {
        }

        protected Void doInBackground(Void ... values) {
            MP3RadioStreamPlayer.this.decodeLoop();
            return null;
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    private class CheckProgressTimerTask
    extends TimerTask {
        private CheckProgressTimerTask() {
        }

        @Override
        public void run() {
            if (MP3RadioStreamPlayer.this.lastInputBufIndex == MP3RadioStreamPlayer.this.bufIndexCheck) {
                Log.d((String)"MP3RadioStreamPlayer", (String)("----lastInputBufIndex " + MP3RadioStreamPlayer.this.lastInputBufIndex));
                Log.d((String)"MP3RadioStreamPlayer", (String)("----bufIndexCheck " + MP3RadioStreamPlayer.this.bufIndexCheck));
                if (MP3RadioStreamPlayer.this.mState == State.Playing) {
                    Log.d((String)"MP3RadioStreamPlayer", (String)"buffering???? onRadioPlayerBuffering");
                    MP3RadioStreamPlayer.this.mDelegateHandler.onRadioPlayerBuffering(MP3RadioStreamPlayer.this);
                }
                MP3RadioStreamPlayer.this.mState = State.Retrieving;
            }
            MP3RadioStreamPlayer.this.lastInputBufIndex = MP3RadioStreamPlayer.this.bufIndexCheck;
            Log.d((String)"MP3RadioStreamPlayer", (String)("lastInputBufIndex " + MP3RadioStreamPlayer.this.lastInputBufIndex));
            if (MP3RadioStreamPlayer.this.bufIndexCheck > 9999) {
                MP3RadioStreamPlayer.this.bufIndexCheck = 0;
            }
        }
    }

    class DelegateHandler
    extends Handler {
        DelegateHandler() {
        }

        public void handleMessage(Message msg) {
        }

        public void onRadioPlayerPlaybackStarted(MP3RadioStreamPlayer player) {
            if (MP3RadioStreamPlayer.this.mDelegate != null) {
                MP3RadioStreamPlayer.this.mDelegate.onRadioPlayerPlaybackStarted(player);
            }
        }

        public void onRadioPlayerStopped(MP3RadioStreamPlayer player) {
            if (MP3RadioStreamPlayer.this.mDelegate != null) {
                MP3RadioStreamPlayer.this.mDelegate.onRadioPlayerStopped(player);
            }
        }

        public void onRadioPlayerError(MP3RadioStreamPlayer player) {
            if (MP3RadioStreamPlayer.this.mDelegate != null) {
                MP3RadioStreamPlayer.this.mDelegate.onRadioPlayerError(player);
            }
        }

        public void onRadioPlayerBuffering(MP3RadioStreamPlayer player) {
            if (MP3RadioStreamPlayer.this.mDelegate != null) {
                MP3RadioStreamPlayer.this.mDelegate.onRadioPlayerBuffering(player);
            }
        }
    }

    public static enum State {
        Retrieving,
        Stopped,
        Playing,
        Pause;

    }
}

