/*
 * Decompiled with CFR 0.152.
 */
package com.czt.mp3recorder;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.Process;
import com.BaseRecorder;
import com.czt.mp3recorder.DataEncodeThread;
import com.czt.mp3recorder.PCMFormat;
import com.czt.mp3recorder.util.LameUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MP3Recorder
extends BaseRecorder {
    private static final int DEFAULT_AUDIO_SOURCE = 1;
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_CHANNEL_CONFIG = 16;
    private static final PCMFormat DEFAULT_AUDIO_FORMAT = PCMFormat.PCM_16BIT;
    private static final int DEFAULT_LAME_MP3_QUALITY = 7;
    private static final int DEFAULT_LAME_IN_CHANNEL = 1;
    private static final int DEFAULT_LAME_MP3_BIT_RATE = 32;
    private static final int FRAME_COUNT = 160;
    public static final int ERROR_TYPE = 22;
    private AudioRecord mAudioRecord = null;
    private DataEncodeThread mEncodeThread;
    private File mRecordFile;
    private ArrayList<Short> dataList;
    private Handler errorHandler;
    private int mBufferSize;
    private short[] mPCMBuffer;
    private boolean mIsRecording = false;
    private int mMaxSize;
    private boolean mSendError;
    private boolean mPause;
    private static final int MAX_VOLUME = 2000;

    public MP3Recorder(File recordFile) {
        this.mRecordFile = recordFile;
    }

    public void start() throws IOException {
        if (this.mIsRecording) {
            return;
        }
        this.mIsRecording = true;
        this.initAudioRecorder();
        try {
            this.mAudioRecord.startRecording();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        new Thread(){
            boolean isError = false;

            @Override
            public void run() {
                Process.setThreadPriority((int)-19);
                while (MP3Recorder.this.mIsRecording) {
                    int readSize = MP3Recorder.this.mAudioRecord.read(MP3Recorder.this.mPCMBuffer, 0, MP3Recorder.this.mBufferSize);
                    if (readSize == -3 || readSize == -2) {
                        if (MP3Recorder.this.errorHandler == null || MP3Recorder.this.mSendError) continue;
                        MP3Recorder.this.mSendError = true;
                        MP3Recorder.this.errorHandler.sendEmptyMessage(22);
                        MP3Recorder.this.mIsRecording = false;
                        this.isError = true;
                        continue;
                    }
                    if (readSize > 0) {
                        if (MP3Recorder.this.mPause) continue;
                        MP3Recorder.this.mEncodeThread.addTask(MP3Recorder.this.mPCMBuffer, readSize);
                        MP3Recorder.this.calculateRealVolume(MP3Recorder.this.mPCMBuffer, readSize);
                        MP3Recorder.this.sendData(MP3Recorder.this.mPCMBuffer, readSize);
                        continue;
                    }
                    if (MP3Recorder.this.errorHandler == null || MP3Recorder.this.mSendError) continue;
                    MP3Recorder.this.mSendError = true;
                    MP3Recorder.this.errorHandler.sendEmptyMessage(22);
                    MP3Recorder.this.mIsRecording = false;
                    this.isError = true;
                }
                try {
                    MP3Recorder.this.mAudioRecord.stop();
                    MP3Recorder.this.mAudioRecord.release();
                    MP3Recorder.this.mAudioRecord = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.isError) {
                    MP3Recorder.this.mEncodeThread.sendErrorMessage();
                } else {
                    MP3Recorder.this.mEncodeThread.sendStopMessage();
                }
            }
        }.start();
    }

    @Override
    public int getRealVolume() {
        return this.mVolume;
    }

    public int getVolume() {
        if (this.mVolume >= 2000) {
            return 2000;
        }
        return this.mVolume;
    }

    public int getMaxVolume() {
        return 2000;
    }

    public void stop() {
        this.mPause = false;
        this.mIsRecording = false;
    }

    public boolean isRecording() {
        return this.mIsRecording;
    }

    private void initAudioRecorder() throws IOException {
        this.mBufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)DEFAULT_AUDIO_FORMAT.getAudioFormat());
        int bytesPerFrame = DEFAULT_AUDIO_FORMAT.getBytesPerFrame();
        int frameSize = this.mBufferSize / bytesPerFrame;
        if (frameSize % 160 != 0) {
            frameSize += 160 - frameSize % 160;
            this.mBufferSize = frameSize * bytesPerFrame;
        }
        this.mAudioRecord = new AudioRecord(1, 44100, 16, DEFAULT_AUDIO_FORMAT.getAudioFormat(), this.mBufferSize);
        this.mPCMBuffer = new short[this.mBufferSize];
        LameUtil.init(44100, 1, 44100, 32, 7);
        this.mEncodeThread = new DataEncodeThread(this.mRecordFile, this.mBufferSize);
        this.mEncodeThread.start();
        this.mAudioRecord.setRecordPositionUpdateListener((AudioRecord.OnRecordPositionUpdateListener)this.mEncodeThread, this.mEncodeThread.getHandler());
        this.mAudioRecord.setPositionNotificationPeriod(160);
    }

    private void sendData(short[] shorts, int readSize) {
        if (this.dataList != null) {
            int length = readSize / 300;
            short resultMax = 0;
            short resultMin = 0;
            int i = 0;
            int k = 0;
            while (i < length) {
                short max = 0;
                short min = 1000;
                for (int j = k; j < k + 300; j = (int)((short)(j + 1))) {
                    if (shorts[j] > max) {
                        resultMax = max = shorts[j];
                        continue;
                    }
                    if (shorts[j] >= min) continue;
                    resultMin = min = shorts[j];
                }
                if (this.dataList.size() > this.mMaxSize) {
                    this.dataList.remove(0);
                }
                this.dataList.add(resultMax);
                i = (short)(i + 1);
                k = (short)(k + 300);
            }
        }
    }

    public void setDataList(ArrayList<Short> dataList, int maxSize) {
        this.dataList = dataList;
        this.mMaxSize = maxSize;
    }

    public boolean isPause() {
        return this.mPause;
    }

    public void setPause(boolean pause) {
        this.mPause = pause;
    }

    public void setErrorHandler(Handler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                String[] filePaths;
                for (String path : filePaths = file.list()) {
                    MP3Recorder.deleteFile(filePath + File.separator + path);
                }
                file.delete();
            }
        }
    }
}

