/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.waveview;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class AudioPlayer
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener {
    public static final int HANDLER_CUR_TIME = 1;
    public static final int HANDLER_PREPARED = 2;
    public static final int HANDLER_COMPLETE = 0;
    public static final int HANDLER_ERROR = -28;
    private MediaPlayer mMediaPlayer;
    private Handler mRemoteHandler;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private AudioManager mAudioManager;

    public AudioPlayer(Context context, Handler handler) {
        this.mRemoteHandler = handler;
        try {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play() {
        this.mAudioManager.setMode(0);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.start();
        }
    }

    public int playUrl(String url) {
        try {
            this.mAudioManager.setMode(0);
            this.mMediaPlayer.reset();
            this.mMediaPlayer.setDataSource(url);
            this.mMediaPlayer.prepareAsync();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        this.mTimer = new Timer();
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                if (AudioPlayer.this.mMediaPlayer == null || !AudioPlayer.this.mMediaPlayer.isPlaying()) {
                    return;
                }
                Message msg = new Message();
                msg.obj = AudioPlayer.this.mMediaPlayer.getCurrentPosition();
                msg.what = 1;
                AudioPlayer.this.mRemoteHandler.sendMessageAtTime(msg, 0L);
            }
        };
        this.mTimer.schedule(this.mTimerTask, 0L, 10L);
        return 100;
    }

    public void pause() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.pause();
        }
    }

    public void stop() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public void seekTo(int time) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(time);
            this.mMediaPlayer.start();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        if (this.mRemoteHandler != null) {
            Message msg = new Message();
            msg.obj = this.mMediaPlayer.getDuration();
            msg.what = 2;
            this.mRemoteHandler.sendMessageAtTime(msg, 0L);
        }
        mp.start();
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.mRemoteHandler != null) {
            Message msg = new Message();
            msg.what = 0;
            this.mRemoteHandler.sendMessageAtTime(msg, 0L);
        }
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        if (this.mRemoteHandler != null) {
            Message msg = new Message();
            msg.what = -28;
            this.mRemoteHandler.sendMessageAtTime(msg, 0L);
        }
        return false;
    }

    public long getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    public static long getDurationLocation(Context context, String path) {
        MediaPlayer player = MediaPlayer.create((Context)context, (Uri)Uri.fromFile((File)new File(path)));
        if (player != null) {
            return player.getDuration();
        }
        return 0L;
    }
}

