/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper.utils;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0012"}, d2={"copy", "", "source", "Ljava/io/InputStream;", "target", "Ljava/io/OutputStream;", "getFileExtension", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getFileFromContentUri", "Ljava/io/File;", "contentUri", "uniqueName", "", "getFilePathFromUri", "cropper_release"})
public final class GetFilePathFromUriKt {
    @NotNull
    public static final String getFilePathFromUri(@NotNull Context context, @NotNull Uri uri, boolean uniqueName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string3 = uri.getPath();
        if (string3 == null ? false : StringsKt.contains$default((CharSequence)string3, (CharSequence)"file://", (boolean)false, (int)2, null)) {
            String string4 = uri.getPath();
            Intrinsics.checkNotNull((Object)string4);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri.path!!");
            string2 = string3;
        } else {
            string3 = GetFilePathFromUriKt.getFileFromContentUri(context, uri, uniqueName).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileFromContentUri(context, uri, uniqueName).path");
            string2 = string3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File getFileFromContentUri(Context context, Uri contentUri, boolean uniqueName) {
        File tempFile;
        block9: {
            Closeable closeable;
            FileOutputStream oStream;
            block8: {
                String string2 = GetFilePathFromUriKt.getFileExtension(context, contentUri);
                String fileExtension = string2 == null ? "" : string2;
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
                String fileName = "temp_file_" + (uniqueName ? timeStamp : "") + "." + fileExtension;
                tempFile = new File(context.getCacheDir(), fileName);
                tempFile.createNewFile();
                oStream = null;
                InputStream inputStream = null;
                try {
                    oStream = new FileOutputStream(tempFile);
                    inputStream = context.getContentResolver().openInputStream(contentUri);
                    closeable = inputStream;
                    if (closeable != null) {
                        InputStream inputStream2 = closeable;
                        boolean bl = false;
                        boolean bl2 = false;
                        InputStream it = inputStream2;
                        boolean bl3 = false;
                        GetFilePathFromUriKt.copy(inputStream, oStream);
                    }
                    oStream.flush();
                    closeable = inputStream;
                    if (closeable == null) break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block9;
                }
                finally {
                    Closeable closeable2 = inputStream;
                    if (closeable2 != null) {
                        ((InputStream)closeable2).close();
                    }
                    closeable2 = oStream;
                    if (closeable2 != null) {
                        ((FileOutputStream)closeable2).close();
                    }
                }
                ((InputStream)closeable).close();
            }
            closeable = oStream;
            ((FileOutputStream)closeable).close();
        }
        return tempFile;
    }

    private static final String getFileExtension(Context context, Uri uri) {
        String string2;
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
            string2 = MimeTypeMap.getSingleton().getExtensionFromMimeType(context.getContentResolver().getType(uri));
        } else {
            String string3 = uri.getPath();
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                string2 = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(it)).toString());
            }
        }
        return string2;
    }

    private static final void copy(InputStream source, OutputStream target) throws IOException {
        byte[] buf = new byte[8192];
        int length = 0;
        while (true) {
            int n = source.read(buf);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            length = it;
            if (n <= 0) break;
            target.write(buf, 0, length);
        }
    }
}

