/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import com.canhub.cropper.CropImage;
import com.canhub.cropper.CropImageActivity$WhenMappings;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.R;
import com.canhub.cropper.common.CommonVersionCheck;
import com.canhub.cropper.databinding.CropImageActivityBinding;
import com.canhub.cropper.utils.GetUriForFileKt;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001c\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\"\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0017J\b\u0010%\u001a\u00020\u0018H\u0016J\u0012\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0016J+\u00104\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020 2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u000209H\u0016\u00a2\u0006\u0002\u0010:J(\u0010;\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\b2\u000e\u0010\u001c\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001eH\u0016J\b\u0010<\u001a\u00020\u0018H\u0016J\b\u0010=\u001a\u00020\u0018H\u0016J\u0010\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020 H\u0016J\u0010\u0010@\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010A\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001c\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010B\u001a\u00020\u0018H\u0016J \u0010C\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006F"}, d2={"Lcom/canhub/cropper/CropImageActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/canhub/cropper/CropImageView$OnSetImageUriCompleteListener;", "Lcom/canhub/cropper/CropImageView$OnCropImageCompleteListener;", "()V", "binding", "Lcom/canhub/cropper/databinding/CropImageActivityBinding;", "cropImageUri", "Landroid/net/Uri;", "getCropImageUri", "()Landroid/net/Uri;", "setCropImageUri", "(Landroid/net/Uri;)V", "cropImageView", "Lcom/canhub/cropper/CropImageView;", "options", "Lcom/canhub/cropper/CropImageOptions;", "getOptions", "()Lcom/canhub/cropper/CropImageOptions;", "setOptions", "(Lcom/canhub/cropper/CropImageOptions;)V", "outputUri", "getOutputUri", "cropImage", "", "getResultIntent", "Landroid/content/Intent;", "uri", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sampleSize", "", "onActivityResult", "requestCode", "resultCode", "data", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onCropImageComplete", "view", "result", "Lcom/canhub/cropper/CropImageView$CropResult;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onSetImageUriComplete", "onStart", "onStop", "rotateImage", "degrees", "setCropImageView", "setResult", "setResultCancel", "updateMenuItemIconColor", "itemId", "color", "cropper_release"})
public class CropImageActivity
extends AppCompatActivity
implements CropImageView.OnSetImageUriCompleteListener,
CropImageView.OnCropImageCompleteListener {
    @Nullable
    private Uri cropImageUri;
    public CropImageOptions options;
    private CropImageView cropImageView;
    private CropImageActivityBinding binding;

    @Nullable
    public final Uri getCropImageUri() {
        return this.cropImageUri;
    }

    public final void setCropImageUri(@Nullable Uri uri) {
        this.cropImageUri = uri;
    }

    @NotNull
    public final CropImageOptions getOptions() {
        CropImageOptions cropImageOptions = this.options;
        if (cropImageOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        return cropImageOptions;
    }

    public final void setOptions(@NotNull CropImageOptions cropImageOptions) {
        Intrinsics.checkNotNullParameter((Object)cropImageOptions, (String)"<set-?>");
        this.options = cropImageOptions;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        block14: {
            block12: {
                block13: {
                    super.onCreate(savedInstanceState);
                    v0 = CropImageActivityBinding.inflate(this.getLayoutInflater());
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"CropImageActivityBinding.inflate(layoutInflater)");
                    v1 = this.binding = v0;
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    }
                    this.setContentView((View)v1.getRoot());
                    v2 = this.binding;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    }
                    v3 = v2.cropImageView;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"binding.cropImageView");
                    this.setCropImageView(v3);
                    v4 = bundle = this.getIntent().getBundleExtra("CROP_IMAGE_EXTRA_BUNDLE");
                    this.cropImageUri = v4 != null ? (Uri)v4.getParcelable("CROP_IMAGE_EXTRA_SOURCE") : null;
                    v5 /* !! */  = bundle;
                    if (v5 /* !! */  == null || (v5 /* !! */  = (CropImageOptions)v5 /* !! */ .getParcelable("CROP_IMAGE_EXTRA_OPTIONS")) == null) {
                        v5 /* !! */  = this.options = new CropImageOptions();
                    }
                    if (savedInstanceState != null) break block12;
                    if (this.cropImageUri != null && !Intrinsics.areEqual((Object)this.cropImageUri, (Object)Uri.EMPTY)) break block13;
                    if (CropImage.INSTANCE.isExplicitCameraPermissionRequired((Context)this)) {
                        this.requestPermissions(new String[]{"android.permission.CAMERA"}, 2011);
                    } else {
                        CropImage.INSTANCE.startPickImageActivity((Activity)this);
                    }
                    break block12;
                }
                v6 = this.cropImageUri;
                if (v6 == null) ** GOTO lbl-1000
                var3_3 = v6;
                var4_4 = false;
                var5_5 = false;
                it = var3_3;
                $i$a$-let-CropImageActivity$onCreate$1 = false;
                if (!CropImage.isReadExternalStoragePermissionsRequired((Context)this, (Uri)it)) ** GOTO lbl-1000
                if (CommonVersionCheck.INSTANCE.isAtLeastM23()) {
                    this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
                } else lbl-1000:
                // 3 sources

                {
                    v7 = this.cropImageView;
                    if (v7 != null) {
                        v7.setImageUriAsync(this.cropImageUri);
                    }
                }
            }
            v8 = this.getSupportActionBar();
            if (v8 == null) break block14;
            var3_3 = v8;
            var4_4 = false;
            var5_5 = false;
            it = var3_3;
            $i$a$-let-CropImageActivity$onCreate$2 = false;
            v9 = this.options;
            if (v9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            var8_8 = v9.activityTitle;
            var9_9 = false;
            if (var8_8.length() > 0) {
                v10 = this.options;
                if (v10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                }
                v11 = v10.activityTitle;
            } else {
                v11 = this.getResources().getString(R.string.crop_image_activity_title);
            }
            this.setTitle(v11);
            it.setDisplayHomeAsUpEnabled(true);
        }
    }

    public void onStart() {
        block1: {
            super.onStart();
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.setOnSetImageUriCompleteListener(this);
            }
            CropImageView cropImageView2 = this.cropImageView;
            if (cropImageView2 == null) break block1;
            cropImageView2.setOnCropImageCompleteListener(this);
        }
    }

    public void onStop() {
        block1: {
            super.onStop();
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.setOnSetImageUriCompleteListener(null);
            }
            CropImageView cropImageView2 = this.cropImageView;
            if (cropImageView2 == null) break block1;
            cropImageView2.setOnCropImageCompleteListener(null);
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.crop_image_menu, menu2);
        CropImageOptions cropImageOptions = this.options;
        if (cropImageOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        if (!cropImageOptions.allowRotation) {
            menu2.removeItem(R.id.ic_rotate_left_24);
            menu2.removeItem(R.id.ic_rotate_right_24);
        } else {
            CropImageOptions cropImageOptions2 = this.options;
            if (cropImageOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            if (cropImageOptions2.allowCounterRotation) {
                MenuItem menuItem = menu2.findItem(R.id.ic_rotate_left_24);
                Intrinsics.checkNotNullExpressionValue((Object)menuItem, (String)"menu.findItem(R.id.ic_rotate_left_24)");
                menuItem.setVisible(true);
            }
        }
        CropImageOptions cropImageOptions3 = this.options;
        if (cropImageOptions3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        if (!cropImageOptions3.allowFlipping) {
            menu2.removeItem(R.id.ic_flip_24);
        }
        CropImageOptions cropImageOptions4 = this.options;
        if (cropImageOptions4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        if (cropImageOptions4.cropMenuCropButtonTitle != null) {
            MenuItem menuItem = menu2.findItem(R.id.crop_image_menu_crop);
            Intrinsics.checkNotNullExpressionValue((Object)menuItem, (String)"menu.findItem(R.id.crop_image_menu_crop)");
            CropImageOptions cropImageOptions5 = this.options;
            if (cropImageOptions5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            menuItem.setTitle(cropImageOptions5.cropMenuCropButtonTitle);
        }
        Drawable cropIcon = null;
        try {
            CropImageOptions cropImageOptions6 = this.options;
            if (cropImageOptions6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            if (cropImageOptions6.cropMenuCropButtonIcon != 0) {
                Context context = (Context)this;
                CropImageOptions cropImageOptions7 = this.options;
                if (cropImageOptions7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                }
                cropIcon = ContextCompat.getDrawable((Context)context, (int)cropImageOptions7.cropMenuCropButtonIcon);
                MenuItem menuItem = menu2.findItem(R.id.crop_image_menu_crop);
                Intrinsics.checkNotNullExpressionValue((Object)menuItem, (String)"menu.findItem(R.id.crop_image_menu_crop)");
                menuItem.setIcon(cropIcon);
            }
        }
        catch (Exception e) {
            Log.w((String)"AIC", (String)"Failed to read menu crop drawable", (Throwable)e);
        }
        CropImageOptions cropImageOptions8 = this.options;
        if (cropImageOptions8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        if (cropImageOptions8.activityMenuIconColor != 0) {
            CropImageOptions cropImageOptions9 = this.options;
            if (cropImageOptions9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            this.updateMenuItemIconColor(menu2, R.id.ic_rotate_left_24, cropImageOptions9.activityMenuIconColor);
            CropImageOptions cropImageOptions10 = this.options;
            if (cropImageOptions10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            this.updateMenuItemIconColor(menu2, R.id.ic_rotate_right_24, cropImageOptions10.activityMenuIconColor);
            CropImageOptions cropImageOptions11 = this.options;
            if (cropImageOptions11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            this.updateMenuItemIconColor(menu2, R.id.ic_flip_24, cropImageOptions11.activityMenuIconColor);
            if (cropIcon != null) {
                CropImageOptions cropImageOptions12 = this.options;
                if (cropImageOptions12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                }
                this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_crop, cropImageOptions12.activityMenuIconColor);
            }
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.crop_image_menu_crop) {
            this.cropImage();
        } else if (n == R.id.ic_rotate_left_24) {
            CropImageOptions cropImageOptions = this.options;
            if (cropImageOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            this.rotateImage(-cropImageOptions.rotationDegrees);
        } else if (n == R.id.ic_rotate_right_24) {
            CropImageOptions cropImageOptions = this.options;
            if (cropImageOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            this.rotateImage(cropImageOptions.rotationDegrees);
        } else if (n == R.id.ic_flip_24_horizontally) {
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.flipImageHorizontally();
            }
        } else if (n == R.id.ic_flip_24_vertically) {
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.flipImageVertically();
            }
        } else if (n == 16908332) {
            this.setResultCancel();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return true;
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResultCancel();
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block1: {
            block2: {
                super.onActivityResult(requestCode, resultCode, data);
                if (requestCode != 200) break block1;
                if (resultCode == 0) {
                    this.setResultCancel();
                }
                if (resultCode != -1) break block1;
                Uri uri = this.cropImageUri = CropImage.getPickImageResultUriContent((Context)this, data);
                if (uri == null) break block2;
                Uri uri2 = uri;
                boolean bl = false;
                boolean bl2 = false;
                Uri it = uri2;
                boolean bl3 = false;
                if (!CropImage.isReadExternalStoragePermissionsRequired((Context)this, it)) break block2;
                if (!CommonVersionCheck.INSTANCE.isAtLeastM23()) break block2;
                this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
                break block1;
            }
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView == null) break block1;
            cropImageView.setImageUriAsync(this.cropImageUri);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        if (requestCode == 201) {
            if (this.cropImageUri != null) {
                int[] nArray = grantResults;
                boolean bl = false;
                int[] nArray2 = nArray;
                boolean bl2 = false;
                if (!(nArray2.length == 0) && grantResults[0] == 0) {
                    CropImageView cropImageView = this.cropImageView;
                    if (cropImageView == null) return;
                    cropImageView.setImageUriAsync(this.cropImageUri);
                    return;
                }
            }
            Toast.makeText((Context)((Context)this), (int)R.string.crop_image_activity_no_permissions, (int)1).show();
            this.setResultCancel();
            return;
        }
        if (requestCode == 2011) {
            CropImage.INSTANCE.startPickImageActivity((Activity)this);
            return;
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onSetImageUriComplete(@NotNull CropImageView view, @NotNull Uri uri, @Nullable Exception error) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (error == null) {
            CropImageOptions cropImageOptions = this.options;
            if (cropImageOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            if (cropImageOptions.initialCropWindowRectangle != null) {
                CropImageView cropImageView = this.cropImageView;
                if (cropImageView != null) {
                    CropImageOptions cropImageOptions2 = this.options;
                    if (cropImageOptions2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    }
                    cropImageView.setCropRect(cropImageOptions2.initialCropWindowRectangle);
                }
            }
            CropImageOptions cropImageOptions3 = this.options;
            if (cropImageOptions3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            if (cropImageOptions3.initialRotation > -1) {
                CropImageView cropImageView = this.cropImageView;
                if (cropImageView != null) {
                    CropImageOptions cropImageOptions4 = this.options;
                    if (cropImageOptions4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    }
                    cropImageView.setRotatedDegrees(cropImageOptions4.initialRotation);
                }
            }
        } else {
            this.setResult(null, error, 1);
        }
    }

    @Override
    public void onCropImageComplete(@NotNull CropImageView view, @NotNull CropImageView.CropResult result) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.setResult(result.getUriContent(), result.getError(), result.getSampleSize());
    }

    public void cropImage() {
        block7: {
            block6: {
                CropImageOptions cropImageOptions = this.options;
                if (cropImageOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                }
                if (!cropImageOptions.noOutputImage) break block6;
                this.setResult(null, null, 1);
                break block7;
            }
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView == null) break block7;
            Uri uri = this.getOutputUri();
            CropImageOptions cropImageOptions = this.options;
            if (cropImageOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            Bitmap.CompressFormat compressFormat = cropImageOptions.outputCompressFormat;
            CropImageOptions cropImageOptions2 = this.options;
            if (cropImageOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            int n = cropImageOptions2.outputCompressQuality;
            CropImageOptions cropImageOptions3 = this.options;
            if (cropImageOptions3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            int n2 = cropImageOptions3.outputRequestWidth;
            CropImageOptions cropImageOptions4 = this.options;
            if (cropImageOptions4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            int n3 = cropImageOptions4.outputRequestHeight;
            CropImageOptions cropImageOptions5 = this.options;
            if (cropImageOptions5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            cropImageView.saveCroppedImageAsync(uri, compressFormat, n, n2, n3, cropImageOptions5.outputRequestSizeOptions);
        }
    }

    public void setCropImageView(@NotNull CropImageView cropImageView) {
        Intrinsics.checkNotNullParameter((Object)cropImageView, (String)"cropImageView");
        this.cropImageView = cropImageView;
    }

    public void rotateImage(int degrees) {
        block0: {
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView == null) break block0;
            cropImageView.rotateImage(degrees);
        }
    }

    @Nullable
    public final Uri getOutputUri() {
        Uri outputUri;
        CropImageOptions cropImageOptions = this.options;
        if (cropImageOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        if ((outputUri = cropImageOptions.outputUri) == null || Intrinsics.areEqual((Object)outputUri, (Object)Uri.EMPTY)) {
            Uri uri;
            try {
                Object object;
                String ext;
                CropImageOptions cropImageOptions2 = this.options;
                if (cropImageOptions2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                }
                switch (CropImageActivity$WhenMappings.$EnumSwitchMapping$0[cropImageOptions2.outputCompressFormat.ordinal()]) {
                    case 1: {
                        String string2 = ".jpg";
                        break;
                    }
                    case 2: {
                        String string2 = ".png";
                        break;
                    }
                    default: {
                        String string2 = ext = ".webp";
                    }
                }
                if (CommonVersionCheck.INSTANCE.isAtLeastQ29()) {
                    File file;
                    try {
                        file = File.createTempFile("cropped", ext, this.getExternalFilesDir(Environment.DIRECTORY_PICTURES));
                        Context context = this.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                        File file2 = file;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        file = GetUriForFileKt.getUriForFile(context, file2);
                    }
                    catch (Exception e) {
                        Log.e((String)"AIC", (String)String.valueOf(e.getMessage()));
                        File file3 = File.createTempFile("cropped", ext, this.getCacheDir());
                        Context context = this.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                        File file4 = file3;
                        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"file");
                        file = GetUriForFileKt.getUriForFile(context, file4);
                    }
                    object = file;
                } else {
                    object = Uri.fromFile((File)File.createTempFile("cropped", ext, this.getCacheDir()));
                }
                uri = object;
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException("Failed to create temp file for output image", e);
            }
            outputUri = uri;
        }
        return outputUri;
    }

    public void setResult(@Nullable Uri uri, @Nullable Exception error, int sampleSize) {
        int n;
        CropImageActivity cropImageActivity = this;
        Exception exception = error;
        if (exception != null) {
            Exception exception2 = exception;
            boolean bl = false;
            boolean bl2 = false;
            Exception exception3 = exception2;
            CropImageActivity cropImageActivity2 = cropImageActivity;
            boolean bl3 = false;
            int n2 = 204;
            cropImageActivity = cropImageActivity2;
            n = n2;
        } else {
            n = -1;
        }
        cropImageActivity.setResult(n, this.getResultIntent(uri, error, sampleSize));
        this.finish();
    }

    public void setResultCancel() {
        this.setResult(0);
        this.finish();
    }

    @NotNull
    public Intent getResultIntent(@Nullable Uri uri, @Nullable Exception error, int sampleSize) {
        CropImageView cropImageView = this.cropImageView;
        CropImageView cropImageView2 = this.cropImageView;
        CropImageView cropImageView3 = this.cropImageView;
        CropImageView cropImageView4 = this.cropImageView;
        CropImageView cropImageView5 = this.cropImageView;
        CropImage.ActivityResult result = new CropImage.ActivityResult((Uri)(cropImageView != null ? cropImageView.getImageUri() : null), uri, error, (float[])(cropImageView2 != null ? cropImageView2.getCropPoints() : null), (Rect)(cropImageView3 != null ? cropImageView3.getCropRect() : null), cropImageView4 != null ? cropImageView4.getRotatedDegrees() : 0, (Rect)(cropImageView5 != null ? cropImageView5.getWholeImageRect() : null), sampleSize);
        Intent intent = new Intent();
        intent.putExtras(this.getIntent());
        intent.putExtra("CROP_IMAGE_EXTRA_RESULT", (Parcelable)result);
        return intent;
    }

    public void updateMenuItemIconColor(@NotNull Menu menu2, int itemId, int color) {
        Drawable menuItemIcon;
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        MenuItem menuItem = menu2.findItem(itemId);
        if (menuItem != null && (menuItemIcon = menuItem.getIcon()) != null) {
            try {
                Drawable drawable = menuItemIcon;
                boolean bl = false;
                boolean bl2 = false;
                Drawable $this$apply = drawable;
                boolean bl3 = false;
                $this$apply.mutate();
                $this$apply.setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)color, (BlendModeCompat)BlendModeCompat.SRC_ATOP));
                menuItem.setIcon(menuItemIcon);
            }
            catch (Exception e) {
                Log.w((String)"AIC", (String)"Failed to update menu item color", (Throwable)e);
            }
        }
    }
}

