/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper.utils;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\u0010"}, d2={"copy", "", "source", "Ljava/io/InputStream;", "target", "Ljava/io/OutputStream;", "getFileExtension", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getFileFromContentUri", "Ljava/io/File;", "contentUri", "getFilePathFromUri", "cropper_release"})
public final class GetFilePathFromUriKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String getFilePathFromUri(@NotNull Context context, @NotNull Uri uri) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string3 = uri.getPath();
        if (string3 != null) {
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"file://", (boolean)false, (int)2, null)) {
                String string4 = uri.getPath();
                Intrinsics.checkNotNull((Object)string4);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"uri.path!!");
                return string2;
            }
        }
        String string5 = GetFilePathFromUriKt.getFileFromContentUri(context, uri).getPath();
        string2 = string5;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFileFromContentUri(context, uri).path");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File getFileFromContentUri(Context context, Uri contentUri) {
        File tempFile;
        block9: {
            InputStream inputStream;
            String fileExtension = GetFilePathFromUriKt.getFileExtension(context, contentUri);
            String fileName = "temp_file" + (fileExtension != null ? '.' + fileExtension : "");
            tempFile = new File(context.getCacheDir(), fileName);
            tempFile.createNewFile();
            FileOutputStream oStream = null;
            InputStream inputStream2 = null;
            try {
                oStream = new FileOutputStream(tempFile);
                InputStream inputStream3 = inputStream2 = context.getContentResolver().openInputStream(contentUri);
                if (inputStream3 != null) {
                    InputStream inputStream4 = inputStream3;
                    boolean bl = false;
                    boolean bl2 = false;
                    InputStream it = inputStream4;
                    boolean bl3 = false;
                    GetFilePathFromUriKt.copy(inputStream2, oStream);
                }
                oStream.flush();
                inputStream = inputStream2;
            }
            catch (Exception e) {
                e.printStackTrace();
                break block9;
            }
            finally {
                InputStream inputStream5 = inputStream2;
                if (inputStream5 != null) {
                    inputStream5.close();
                }
                FileOutputStream fileOutputStream = oStream;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            if (inputStream != null) {
                inputStream.close();
            }
            oStream.close();
        }
        return tempFile;
    }

    private static final String getFileExtension(Context context, Uri uri) {
        String fileType = context.getContentResolver().getType(uri);
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(fileType);
    }

    private static final void copy(InputStream source, OutputStream target) throws IOException {
        byte[] buf = new byte[8192];
        int length = 0;
        while (true) {
            int n = source.read(buf);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            length = it;
            if (n <= 0) break;
            target.write(buf, 0, length);
        }
    }
}

