/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.canhub.cropper.BitmapUtils;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.CropOverlayView$WhenMappings;
import com.canhub.cropper.CropWindowHandler;
import com.canhub.cropper.CropWindowMoveHandler;
import com.canhub.cropper.common.CommonVersionCheck;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u0084\u00012\u00020\u0001:\u0006\u0084\u0001\u0085\u0001\u0086\u0001B\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010N\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020'H\u0002J\u0010\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020P2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010V\u001a\u00020P2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010W\u001a\u00020P2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010X\u001a\u00020P2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010Y\u001a\u00020PJ\b\u0010Z\u001a\u00020PH\u0002J\u0018\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u0002002\u0006\u0010]\u001a\u000200H\u0002J\u0018\u0010^\u001a\u00020P2\u0006\u0010\\\u001a\u0002002\u0006\u0010]\u001a\u000200H\u0002J\b\u0010_\u001a\u00020PH\u0002J\u0010\u0010`\u001a\u00020P2\u0006\u0010S\u001a\u00020TH\u0014J\u0010\u0010a\u001a\u00020'2\u0006\u0010b\u001a\u00020cH\u0016J\u0006\u0010d\u001a\u00020PJ\u0006\u0010e\u001a\u00020PJ \u0010f\u001a\u00020P2\b\u0010g\u001a\u0004\u0018\u0001052\u0006\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020\bJ\u000e\u0010j\u001a\u00020'2\u0006\u0010k\u001a\u00020'J\u000e\u0010l\u001a\u00020P2\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010m\u001a\u00020P2\b\u0010n\u001a\u0004\u0018\u000109J&\u0010o\u001a\u00020P2\u0006\u0010p\u001a\u0002002\u0006\u0010q\u001a\u0002002\u0006\u0010r\u001a\u0002002\u0006\u0010s\u001a\u000200J\u000e\u0010t\u001a\u00020P2\u0006\u0010u\u001a\u00020'J\u000e\u0010v\u001a\u00020P2\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010w\u001a\u00020P2\u0006\u0010x\u001a\u00020yJ\u0016\u0010z\u001a\u00020P2\u0006\u0010{\u001a\u00020\b2\u0006\u0010|\u001a\u00020\bJ\u0016\u0010}\u001a\u00020P2\u0006\u0010~\u001a\u00020\b2\u0006\u0010\u007f\u001a\u00020\bJ\u0010\u0010\u0080\u0001\u001a\u00020'2\u0007\u0010\u0081\u0001\u001a\u00020'J\u0010\u0010\u0082\u0001\u001a\u00020P2\u0007\u0010\u0083\u0001\u001a\u000200R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0015\u001a\u0004\u0018\u00010 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010)R\u000e\u0010+\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010C\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010DR\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0087\u0001"}, d2={"Lcom/canhub/cropper/CropOverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "aspectRatioX", "", "getAspectRatioX", "()I", "setAspectRatioX", "(I)V", "aspectRatioY", "getAspectRatioY", "setAspectRatioY", "<set-?>", "Lcom/canhub/cropper/CropImageView$CropShape;", "cropShape", "getCropShape", "()Lcom/canhub/cropper/CropImageView$CropShape;", "rect", "Landroid/graphics/RectF;", "cropWindowRect", "getCropWindowRect", "()Landroid/graphics/RectF;", "setCropWindowRect", "(Landroid/graphics/RectF;)V", "Lcom/canhub/cropper/CropImageView$Guidelines;", "guidelines", "getGuidelines", "()Lcom/canhub/cropper/CropImageView$Guidelines;", "Landroid/graphics/Rect;", "initialCropWindowRect", "getInitialCropWindowRect", "()Landroid/graphics/Rect;", "setInitialCropWindowRect", "(Landroid/graphics/Rect;)V", "initializedCropWindow", "", "isFixAspectRatio", "()Z", "isNonStraightAngleRotated", "mAspectRatioX", "mAspectRatioY", "mBackgroundPaint", "Landroid/graphics/Paint;", "mBorderCornerLength", "", "mBorderCornerOffset", "mBorderCornerPaint", "mBorderPaint", "mBoundsPoints", "", "mCalcBounds", "mCenterMoveEnabled", "mCropWindowChangeListener", "Lcom/canhub/cropper/CropOverlayView$CropWindowChangeListener;", "mCropWindowHandler", "Lcom/canhub/cropper/CropWindowHandler;", "mDrawRect", "mGuidelinePaint", "mInitialCropWindowPaddingRatio", "mInitialCropWindowRect", "mMoveHandler", "Lcom/canhub/cropper/CropWindowMoveHandler;", "mMultiTouchEnabled", "mOriginalLayerType", "Ljava/lang/Integer;", "mPath", "Landroid/graphics/Path;", "mScaleDetector", "Landroid/view/ScaleGestureDetector;", "mSnapRadius", "mTargetAspectRatio", "mTouchRadius", "mViewHeight", "mViewWidth", "calculateBounds", "callOnCropWindowChanged", "", "inProgress", "drawBackground", "canvas", "Landroid/graphics/Canvas;", "drawBorders", "drawCorners", "drawGuidelines", "fixCropWindowRectByRules", "fixCurrentCropWindowRect", "initCropWindow", "onActionDown", "x", "y", "onActionMove", "onActionUp", "onDraw", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "resetCropOverlayView", "resetCropWindowRect", "setBounds", "boundsPoints", "viewWidth", "viewHeight", "setCenterMoveEnabled", "centerMoveEnabled", "setCropShape", "setCropWindowChangeListener", "listener", "setCropWindowLimits", "maxWidth", "maxHeight", "scaleFactorWidth", "scaleFactorHeight", "setFixedAspectRatio", "fixAspectRatio", "setGuidelines", "setInitialAttributeValues", "options", "Lcom/canhub/cropper/CropImageOptions;", "setMaxCropResultSize", "maxCropResultWidth", "maxCropResultHeight", "setMinCropResultSize", "minCropResultWidth", "minCropResultHeight", "setMultiTouchEnabled", "multiTouchEnabled", "setSnapRadius", "snapRadius", "Companion", "CropWindowChangeListener", "ScaleListener", "cropper_release"})
public final class CropOverlayView
extends View {
    private ScaleGestureDetector mScaleDetector;
    private boolean mMultiTouchEnabled;
    private boolean mCenterMoveEnabled;
    private final CropWindowHandler mCropWindowHandler;
    private CropWindowChangeListener mCropWindowChangeListener;
    private final RectF mDrawRect;
    private Paint mBorderPaint;
    private Paint mBorderCornerPaint;
    private Paint mGuidelinePaint;
    private Paint mBackgroundPaint;
    private final Path mPath;
    private final float[] mBoundsPoints;
    private final RectF mCalcBounds;
    private int mViewWidth;
    private int mViewHeight;
    private float mBorderCornerOffset;
    private float mBorderCornerLength;
    private float mInitialCropWindowPaddingRatio;
    private float mTouchRadius;
    private float mSnapRadius;
    private CropWindowMoveHandler mMoveHandler;
    private boolean isFixAspectRatio;
    private int mAspectRatioX;
    private int mAspectRatioY;
    private float mTargetAspectRatio;
    @Nullable
    private CropImageView.Guidelines guidelines;
    @Nullable
    private CropImageView.CropShape cropShape;
    private final Rect mInitialCropWindowRect;
    private boolean initializedCropWindow;
    private Integer mOriginalLayerType;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isFixAspectRatio() {
        return this.isFixAspectRatio;
    }

    @Nullable
    public final CropImageView.Guidelines getGuidelines() {
        return this.guidelines;
    }

    @Nullable
    public final CropImageView.CropShape getCropShape() {
        return this.cropShape;
    }

    public final void setCropWindowChangeListener(@Nullable CropWindowChangeListener listener) {
        this.mCropWindowChangeListener = listener;
    }

    @NotNull
    public final RectF getCropWindowRect() {
        return this.mCropWindowHandler.getRect();
    }

    public final void setCropWindowRect(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.mCropWindowHandler.setRect(rect);
    }

    public final void fixCurrentCropWindowRect() {
        RectF rect = this.getCropWindowRect();
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    public final void setBounds(@Nullable float[] boundsPoints, int viewWidth, int viewHeight) {
        if (boundsPoints == null || !Arrays.equals(this.mBoundsPoints, boundsPoints)) {
            if (boundsPoints == null) {
                Arrays.fill(this.mBoundsPoints, 0.0f);
            } else {
                System.arraycopy(boundsPoints, 0, this.mBoundsPoints, 0, boundsPoints.length);
            }
            this.mViewWidth = viewWidth;
            this.mViewHeight = viewHeight;
            RectF cropRect = this.mCropWindowHandler.getRect();
            if (cropRect.width() == 0.0f || cropRect.height() == 0.0f) {
                this.initCropWindow();
            }
        }
    }

    public final void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.setCropWindowRect(BitmapUtils.INSTANCE.getEMPTY_RECT_F());
            this.initCropWindow();
            this.invalidate();
        }
    }

    public final void setCropShape(@NotNull CropImageView.CropShape cropShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)cropShape), (String)"cropShape");
        if (this.cropShape != cropShape) {
            this.cropShape = cropShape;
            if (!CommonVersionCheck.INSTANCE.isAtLeastJ18()) {
                if (this.cropShape == CropImageView.CropShape.OVAL) {
                    Integer n = this.mOriginalLayerType = Integer.valueOf(this.getLayerType());
                    int n2 = 1;
                    if (n == null || n != n2) {
                        this.setLayerType(1, null);
                    } else {
                        this.mOriginalLayerType = null;
                    }
                } else if (this.mOriginalLayerType != null) {
                    Integer n = this.mOriginalLayerType;
                    Intrinsics.checkNotNull((Object)n);
                    this.setLayerType(n, null);
                    this.mOriginalLayerType = null;
                }
            }
            this.invalidate();
        }
    }

    public final void setGuidelines(@NotNull CropImageView.Guidelines guidelines) {
        Intrinsics.checkNotNullParameter((Object)((Object)guidelines), (String)"guidelines");
        if (this.guidelines != guidelines) {
            this.guidelines = guidelines;
            if (this.initializedCropWindow) {
                this.invalidate();
            }
        }
    }

    public final void setFixedAspectRatio(boolean fixAspectRatio) {
        if (this.isFixAspectRatio != fixAspectRatio) {
            this.isFixAspectRatio = fixAspectRatio;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public final int getAspectRatioX() {
        return this.mAspectRatioX;
    }

    public final void setAspectRatioX(int aspectRatioX) {
        boolean bl = aspectRatioX > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Cannot set aspect ratio value to a number less than or equal to 0.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (this.mAspectRatioX != aspectRatioX) {
            this.mAspectRatioX = aspectRatioX;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public final int getAspectRatioY() {
        return this.mAspectRatioY;
    }

    public final void setAspectRatioY(int aspectRatioY) {
        boolean bl = aspectRatioY > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Cannot set aspect ratio value to a number less than or equal to 0.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (this.mAspectRatioY != aspectRatioY) {
            this.mAspectRatioY = aspectRatioY;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public final void setSnapRadius(float snapRadius) {
        this.mSnapRadius = snapRadius;
    }

    public final boolean setMultiTouchEnabled(boolean multiTouchEnabled) {
        if (this.mMultiTouchEnabled != multiTouchEnabled) {
            this.mMultiTouchEnabled = multiTouchEnabled;
            if (this.mMultiTouchEnabled && this.mScaleDetector == null) {
                this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
            }
            return true;
        }
        return false;
    }

    public final boolean setCenterMoveEnabled(boolean centerMoveEnabled) {
        if (this.mCenterMoveEnabled != centerMoveEnabled) {
            this.mCenterMoveEnabled = centerMoveEnabled;
            return true;
        }
        return false;
    }

    public final void setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        this.mCropWindowHandler.setMinCropResultSize(minCropResultWidth, minCropResultHeight);
    }

    public final void setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        this.mCropWindowHandler.setMaxCropResultSize(maxCropResultWidth, maxCropResultHeight);
    }

    public final void setCropWindowLimits(float maxWidth, float maxHeight, float scaleFactorWidth, float scaleFactorHeight) {
        this.mCropWindowHandler.setCropWindowLimits(maxWidth, maxHeight, scaleFactorWidth, scaleFactorHeight);
    }

    @Nullable
    public final Rect getInitialCropWindowRect() {
        return this.mInitialCropWindowRect;
    }

    public final void setInitialCropWindowRect(@Nullable Rect rect) {
        Rect rect2 = rect;
        if (rect2 == null) {
            rect2 = BitmapUtils.INSTANCE.getEMPTY_RECT();
        }
        this.mInitialCropWindowRect.set(rect2);
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
            this.callOnCropWindowChanged(false);
        }
    }

    public final void resetCropWindowRect() {
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
            this.callOnCropWindowChanged(false);
        }
    }

    public final void setInitialAttributeValues(@NotNull CropImageOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.mCropWindowHandler.setInitialAttributeValues(options);
        this.setCropShape(options.cropShape);
        this.setSnapRadius(options.snapRadius);
        this.setGuidelines(options.guidelines);
        this.setFixedAspectRatio(options.fixAspectRatio);
        this.setAspectRatioX(options.aspectRatioX);
        this.setAspectRatioY(options.aspectRatioY);
        this.setMultiTouchEnabled(options.multiTouchEnabled);
        this.setCenterMoveEnabled(options.centerMoveEnabled);
        this.mTouchRadius = options.touchRadius;
        this.mInitialCropWindowPaddingRatio = options.initialCropWindowPaddingRatio;
        this.mBorderPaint = CropOverlayView.Companion.getNewPaintOrNull(options.borderLineThickness, options.borderLineColor);
        this.mBorderCornerOffset = options.borderCornerOffset;
        this.mBorderCornerLength = options.borderCornerLength;
        this.mBorderCornerPaint = CropOverlayView.Companion.getNewPaintOrNull(options.borderCornerThickness, options.borderCornerColor);
        this.mGuidelinePaint = CropOverlayView.Companion.getNewPaintOrNull(options.guidelinesThickness, options.guidelinesColor);
        this.mBackgroundPaint = CropOverlayView.Companion.getNewPaint(options.backgroundColor);
    }

    private final void initCropWindow() {
        float f = BitmapUtils.INSTANCE.getRectLeft(this.mBoundsPoints);
        float f2 = 0.0f;
        boolean bl = false;
        float leftLimit = Math.max(f, f2);
        f2 = BitmapUtils.INSTANCE.getRectTop(this.mBoundsPoints);
        float f3 = 0.0f;
        boolean bl2 = false;
        float topLimit = Math.max(f2, f3);
        f3 = BitmapUtils.INSTANCE.getRectRight(this.mBoundsPoints);
        float f4 = this.getWidth();
        boolean bl3 = false;
        float rightLimit = Math.min(f3, f4);
        f4 = BitmapUtils.INSTANCE.getRectBottom(this.mBoundsPoints);
        float f5 = this.getHeight();
        boolean bl4 = false;
        float bottomLimit = Math.min(f4, f5);
        if (rightLimit <= leftLimit || bottomLimit <= topLimit) {
            return;
        }
        RectF rect = new RectF();
        this.initializedCropWindow = true;
        float horizontalPadding = this.mInitialCropWindowPaddingRatio * (rightLimit - leftLimit);
        float verticalPadding = this.mInitialCropWindowPaddingRatio * (bottomLimit - topLimit);
        if (this.mInitialCropWindowRect.width() > 0 && this.mInitialCropWindowRect.height() > 0) {
            rect.left = leftLimit + (float)this.mInitialCropWindowRect.left / this.mCropWindowHandler.getScaleFactorWidth();
            rect.top = topLimit + (float)this.mInitialCropWindowRect.top / this.mCropWindowHandler.getScaleFactorHeight();
            rect.right = rect.left + (float)this.mInitialCropWindowRect.width() / this.mCropWindowHandler.getScaleFactorWidth();
            rect.bottom = rect.top + (float)this.mInitialCropWindowRect.height() / this.mCropWindowHandler.getScaleFactorHeight();
            float f6 = rect.left;
            boolean bl5 = false;
            rect.left = Math.max(leftLimit, f6);
            f6 = rect.top;
            bl5 = false;
            rect.top = Math.max(topLimit, f6);
            f6 = rect.right;
            bl5 = false;
            rect.right = Math.min(rightLimit, f6);
            f6 = rect.bottom;
            bl5 = false;
            rect.bottom = Math.min(bottomLimit, f6);
        } else if (this.isFixAspectRatio && rightLimit > leftLimit && bottomLimit > topLimit) {
            float bitmapAspectRatio = (rightLimit - leftLimit) / (bottomLimit - topLimit);
            if (bitmapAspectRatio > this.mTargetAspectRatio) {
                rect.top = topLimit + verticalPadding;
                rect.bottom = bottomLimit - verticalPadding;
                float centerX = (float)this.getWidth() / 2.0f;
                this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
                float f7 = this.mCropWindowHandler.getMinCropWidth();
                float f8 = rect.height() * this.mTargetAspectRatio;
                boolean bl6 = false;
                float cropWidth = Math.max(f7, f8);
                float halfCropWidth = cropWidth / 2.0f;
                rect.left = centerX - halfCropWidth;
                rect.right = centerX + halfCropWidth;
            } else {
                rect.left = leftLimit + horizontalPadding;
                rect.right = rightLimit - horizontalPadding;
                float centerY = (float)this.getHeight() / 2.0f;
                float halfCropWidth = this.mCropWindowHandler.getMinCropHeight();
                float f9 = rect.width() / this.mTargetAspectRatio;
                boolean bl7 = false;
                float cropHeight = Math.max(halfCropWidth, f9);
                float halfCropHeight = cropHeight / 2.0f;
                rect.top = centerY - halfCropHeight;
                rect.bottom = centerY + halfCropHeight;
            }
        } else {
            rect.left = leftLimit + horizontalPadding;
            rect.top = topLimit + verticalPadding;
            rect.right = rightLimit - horizontalPadding;
            rect.bottom = bottomLimit - verticalPadding;
        }
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    private final void fixCropWindowRectByRules(RectF rect) {
        float leftLimit;
        float adj;
        if (rect.width() < this.mCropWindowHandler.getMinCropWidth()) {
            adj = (this.mCropWindowHandler.getMinCropWidth() - rect.width()) / (float)2;
            rect.left -= adj;
            rect.right += adj;
        }
        if (rect.height() < this.mCropWindowHandler.getMinCropHeight()) {
            adj = (this.mCropWindowHandler.getMinCropHeight() - rect.height()) / (float)2;
            rect.top -= adj;
            rect.bottom += adj;
        }
        if (rect.width() > this.mCropWindowHandler.getMaxCropWidth()) {
            adj = (rect.width() - this.mCropWindowHandler.getMaxCropWidth()) / (float)2;
            rect.left += adj;
            rect.right -= adj;
        }
        if (rect.height() > this.mCropWindowHandler.getMaxCropHeight()) {
            adj = (rect.height() - this.mCropWindowHandler.getMaxCropHeight()) / (float)2;
            rect.top += adj;
            rect.bottom -= adj;
        }
        this.calculateBounds(rect);
        if (this.mCalcBounds.width() > 0.0f && this.mCalcBounds.height() > 0.0f) {
            float f = this.mCalcBounds.left;
            float f2 = 0.0f;
            boolean bl = false;
            leftLimit = Math.max(f, f2);
            f2 = this.mCalcBounds.top;
            float f3 = 0.0f;
            boolean bl2 = false;
            float topLimit = Math.max(f2, f3);
            f3 = this.mCalcBounds.right;
            float f4 = this.getWidth();
            boolean bl3 = false;
            float rightLimit = Math.min(f3, f4);
            f4 = this.mCalcBounds.bottom;
            float f5 = this.getHeight();
            boolean bl4 = false;
            float bottomLimit = Math.min(f4, f5);
            if (rect.left < leftLimit) {
                rect.left = leftLimit;
            }
            if (rect.top < topLimit) {
                rect.top = topLimit;
            }
            if (rect.right > rightLimit) {
                rect.right = rightLimit;
            }
            if (rect.bottom > bottomLimit) {
                rect.bottom = bottomLimit;
            }
        }
        if (this.isFixAspectRatio) {
            leftLimit = rect.width() - rect.height() * this.mTargetAspectRatio;
            boolean bl = false;
            if ((double)Math.abs(leftLimit) > 0.1) {
                if (rect.width() > rect.height() * this.mTargetAspectRatio) {
                    float f = rect.height() * this.mTargetAspectRatio - rect.width();
                    boolean bl5 = false;
                    adj = Math.abs(f) / (float)2;
                    rect.left += adj;
                    rect.right -= adj;
                } else {
                    float f = rect.width() / this.mTargetAspectRatio - rect.height();
                    boolean bl6 = false;
                    adj = Math.abs(f) / (float)2;
                    rect.top += adj;
                    rect.bottom -= adj;
                }
            }
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawBackground(canvas);
        if (this.mCropWindowHandler.showGuidelines()) {
            if (this.guidelines == CropImageView.Guidelines.ON) {
                this.drawGuidelines(canvas);
            } else if (this.guidelines == CropImageView.Guidelines.ON_TOUCH && this.mMoveHandler != null) {
                this.drawGuidelines(canvas);
            }
        }
        this.drawBorders(canvas);
        this.drawCorners(canvas);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void drawBackground(Canvas canvas) {
        RectF rect = this.mCropWindowHandler.getRect();
        float f = BitmapUtils.INSTANCE.getRectLeft(this.mBoundsPoints);
        float f2 = 0.0f;
        boolean bl = false;
        float left = Math.max(f, f2);
        f2 = BitmapUtils.INSTANCE.getRectTop(this.mBoundsPoints);
        float f3 = 0.0f;
        boolean bl2 = false;
        float top = Math.max(f2, f3);
        f3 = BitmapUtils.INSTANCE.getRectRight(this.mBoundsPoints);
        float f4 = this.getWidth();
        boolean bl3 = false;
        float right = Math.min(f3, f4);
        f4 = BitmapUtils.INSTANCE.getRectBottom(this.mBoundsPoints);
        float f5 = this.getHeight();
        boolean bl4 = false;
        float bottom = Math.min(f4, f5);
        CropImageView.CropShape cropShape = this.cropShape;
        if (cropShape == null) throw (Throwable)new IllegalStateException("Unrecognized crop shape");
        switch (CropOverlayView$WhenMappings.$EnumSwitchMapping$0[cropShape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (!this.isNonStraightAngleRotated() || !CommonVersionCheck.INSTANCE.isAtLeastJ18()) {
                    float f6 = rect.top;
                    Paint paint = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint);
                    canvas.drawRect(left, top, right, f6, paint);
                    float f7 = rect.bottom;
                    Paint paint2 = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint2);
                    canvas.drawRect(left, f7, right, bottom, paint2);
                    float f8 = rect.top;
                    float f9 = rect.left;
                    float f10 = rect.bottom;
                    Paint paint3 = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint3);
                    canvas.drawRect(left, f8, f9, f10, paint3);
                    float f11 = rect.right;
                    float f12 = rect.top;
                    float f13 = rect.bottom;
                    Paint paint4 = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint4);
                    canvas.drawRect(f11, f12, right, f13, paint4);
                    return;
                }
                this.mPath.reset();
                this.mPath.moveTo(this.mBoundsPoints[0], this.mBoundsPoints[1]);
                this.mPath.lineTo(this.mBoundsPoints[2], this.mBoundsPoints[3]);
                this.mPath.lineTo(this.mBoundsPoints[4], this.mBoundsPoints[5]);
                this.mPath.lineTo(this.mBoundsPoints[6], this.mBoundsPoints[7]);
                this.mPath.close();
                canvas.save();
                if (CommonVersionCheck.INSTANCE.isAtLeastO26()) {
                    canvas.clipOutPath(this.mPath);
                } else {
                    canvas.clipPath(this.mPath, Region.Op.INTERSECT);
                }
                canvas.clipRect(rect, Region.Op.XOR);
                Paint paint = this.mBackgroundPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawRect(left, top, right, bottom, paint);
                canvas.restore();
                return;
            }
            case 4: {
                this.mPath.reset();
                if (CommonVersionCheck.INSTANCE.isAtLeastJ18()) {
                    this.mDrawRect.set(rect.left, rect.top, rect.right, rect.bottom);
                } else {
                    this.mDrawRect.set(rect.left + (float)2, rect.top + (float)2, rect.right - (float)2, rect.bottom - (float)2);
                }
                this.mPath.addOval(this.mDrawRect, Path.Direction.CW);
                canvas.save();
                if (CommonVersionCheck.INSTANCE.isAtLeastO26()) {
                    canvas.clipOutPath(this.mPath);
                } else {
                    canvas.clipPath(this.mPath, Region.Op.XOR);
                }
                Paint paint = this.mBackgroundPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawRect(left, top, right, bottom, paint);
                canvas.restore();
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unrecognized crop shape");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void drawGuidelines(Canvas canvas) {
        float f;
        if (this.mGuidelinePaint == null) return;
        if (this.mBorderPaint != null) {
            Paint paint = this.mBorderPaint;
            Intrinsics.checkNotNull((Object)paint);
            f = paint.getStrokeWidth();
        } else {
            f = 0.0f;
        }
        float sw = f;
        RectF rect = this.mCropWindowHandler.getRect();
        rect.inset(sw, sw);
        float oneThirdCropWidth = rect.width() / (float)3;
        float oneThirdCropHeight = rect.height() / (float)3;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        CropImageView.CropShape cropShape = this.cropShape;
        if (cropShape == null) throw (Throwable)new IllegalStateException("Unrecognized crop shape");
        switch (CropOverlayView$WhenMappings.$EnumSwitchMapping$1[cropShape.ordinal()]) {
            case 1: {
                float w = rect.width() / (float)2 - sw;
                float h = rect.height() / (float)2 - sw;
                x1 = rect.left + oneThirdCropWidth;
                x2 = rect.right - oneThirdCropWidth;
                double d = (w - oneThirdCropWidth) / w;
                boolean bl = false;
                d = Math.acos(d);
                bl = false;
                float yv = (float)((double)h * Math.sin(d));
                float f2 = rect.top + h - yv;
                float f3 = rect.bottom - h + yv;
                Paint paint = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawLine(x1, f2, x1, f3, paint);
                float f4 = rect.top + h - yv;
                float f5 = rect.bottom - h + yv;
                Paint paint2 = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint2);
                canvas.drawLine(x2, f4, x2, f5, paint2);
                y1 = rect.top + oneThirdCropHeight;
                y2 = rect.bottom - oneThirdCropHeight;
                double d2 = (h - oneThirdCropHeight) / h;
                boolean bl2 = false;
                d2 = Math.asin(d2);
                bl2 = false;
                float xv = (float)((double)w * Math.cos(d2));
                float f6 = rect.left + w - xv;
                float f7 = rect.right - w + xv;
                Paint paint3 = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint3);
                canvas.drawLine(f6, y1, f7, y1, paint3);
                float f8 = rect.left + w - xv;
                float f9 = rect.right - w + xv;
                Paint paint4 = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint4);
                canvas.drawLine(f8, y2, f9, y2, paint4);
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                x1 = rect.left + oneThirdCropWidth;
                x2 = rect.right - oneThirdCropWidth;
                float f10 = rect.top;
                float f11 = rect.bottom;
                Paint paint = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawLine(x1, f10, x1, f11, paint);
                float f12 = rect.top;
                float f13 = rect.bottom;
                Paint paint5 = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint5);
                canvas.drawLine(x2, f12, x2, f13, paint5);
                y1 = rect.top + oneThirdCropHeight;
                y2 = rect.bottom - oneThirdCropHeight;
                float f14 = rect.left;
                float f15 = rect.right;
                Paint paint6 = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint6);
                canvas.drawLine(f14, y1, f15, y1, paint6);
                float f16 = rect.left;
                float f17 = rect.right;
                Paint paint7 = this.mGuidelinePaint;
                Intrinsics.checkNotNull((Object)paint7);
                canvas.drawLine(f16, y2, f17, y2, paint7);
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unrecognized crop shape");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void drawBorders(Canvas canvas) {
        if (this.mBorderPaint == null) return;
        Paint paint = this.mBorderPaint;
        Intrinsics.checkNotNull((Object)paint);
        float w = paint.getStrokeWidth();
        RectF rect = this.mCropWindowHandler.getRect();
        rect.inset(w / (float)2, w / (float)2);
        CropImageView.CropShape cropShape = this.cropShape;
        if (cropShape == null) throw (Throwable)new IllegalStateException("Unrecognized crop shape");
        switch (CropOverlayView$WhenMappings.$EnumSwitchMapping$2[cropShape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Paint paint2 = this.mBorderPaint;
                Intrinsics.checkNotNull((Object)paint2);
                canvas.drawRect(rect, paint2);
                return;
            }
            case 4: {
                Paint paint3 = this.mBorderPaint;
                Intrinsics.checkNotNull((Object)paint3);
                canvas.drawOval(rect, paint3);
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unrecognized crop shape");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void drawCorners(Canvas canvas) {
        float f;
        float f2;
        if (this.mBorderCornerPaint == null) return;
        if (this.mBorderPaint != null) {
            Paint paint = this.mBorderPaint;
            Intrinsics.checkNotNull((Object)paint);
            f2 = paint.getStrokeWidth();
        } else {
            f2 = 0.0f;
        }
        float lineWidth = f2;
        Paint paint = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint);
        float cornerWidth = paint.getStrokeWidth();
        float cornerOffset = (cornerWidth - lineWidth) / (float)2;
        float cornerExtension = cornerWidth / (float)2 + cornerOffset;
        CropImageView.CropShape cropShape = this.cropShape;
        if (cropShape == null) throw (Throwable)new IllegalStateException("Unrecognized crop shape");
        switch (CropOverlayView$WhenMappings.$EnumSwitchMapping$3[cropShape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                f = cornerWidth / (float)2 + this.mBorderCornerOffset;
                break;
            }
            case 4: {
                f = cornerWidth / (float)2;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unrecognized crop shape");
            }
        }
        float w = f;
        RectF rect = this.mCropWindowHandler.getRect();
        rect.inset(w, w);
        CropImageView.CropShape cropShape2 = this.cropShape;
        if (cropShape2 == null) throw (Throwable)new IllegalStateException("Unrecognized crop shape");
        switch (CropOverlayView$WhenMappings.$EnumSwitchMapping$4[cropShape2.ordinal()]) {
            case 1: 
            case 2: {
                float f3 = rect.left - cornerOffset;
                float f4 = rect.top - cornerExtension;
                float f5 = rect.left - cornerOffset;
                float f6 = rect.top + this.mBorderCornerLength;
                Paint paint2 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint2);
                canvas.drawLine(f3, f4, f5, f6, paint2);
                float f7 = rect.left - cornerExtension;
                float f8 = rect.top - cornerOffset;
                float f9 = rect.left + this.mBorderCornerLength;
                float f10 = rect.top - cornerOffset;
                Paint paint3 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint3);
                canvas.drawLine(f7, f8, f9, f10, paint3);
                float f11 = rect.right + cornerOffset;
                float f12 = rect.top - cornerExtension;
                float f13 = rect.right + cornerOffset;
                float f14 = rect.top + this.mBorderCornerLength;
                Paint paint4 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint4);
                canvas.drawLine(f11, f12, f13, f14, paint4);
                float f15 = rect.right + cornerExtension;
                float f16 = rect.top - cornerOffset;
                float f17 = rect.right - this.mBorderCornerLength;
                float f18 = rect.top - cornerOffset;
                Paint paint5 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint5);
                canvas.drawLine(f15, f16, f17, f18, paint5);
                float f19 = rect.left - cornerOffset;
                float f20 = rect.bottom + cornerExtension;
                float f21 = rect.left - cornerOffset;
                float f22 = rect.bottom - this.mBorderCornerLength;
                Paint paint6 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint6);
                canvas.drawLine(f19, f20, f21, f22, paint6);
                float f23 = rect.left - cornerExtension;
                float f24 = rect.bottom + cornerOffset;
                float f25 = rect.left + this.mBorderCornerLength;
                float f26 = rect.bottom + cornerOffset;
                Paint paint7 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint7);
                canvas.drawLine(f23, f24, f25, f26, paint7);
                float f27 = rect.right + cornerOffset;
                float f28 = rect.bottom + cornerExtension;
                float f29 = rect.right + cornerOffset;
                float f30 = rect.bottom - this.mBorderCornerLength;
                Paint paint8 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint8);
                canvas.drawLine(f27, f28, f29, f30, paint8);
                float f31 = rect.right + cornerExtension;
                float f32 = rect.bottom + cornerOffset;
                float f33 = rect.right - this.mBorderCornerLength;
                float f34 = rect.bottom + cornerOffset;
                Paint paint9 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint9);
                canvas.drawLine(f31, f32, f33, f34, paint9);
                return;
            }
            case 3: {
                float f35 = rect.centerX() - this.mBorderCornerLength;
                float f36 = rect.top - cornerOffset;
                float f37 = rect.centerX() + this.mBorderCornerLength;
                float f38 = rect.top - cornerOffset;
                Paint paint10 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint10);
                canvas.drawLine(f35, f36, f37, f38, paint10);
                float f39 = rect.centerX() - this.mBorderCornerLength;
                float f40 = rect.bottom + cornerOffset;
                float f41 = rect.centerX() + this.mBorderCornerLength;
                float f42 = rect.bottom + cornerOffset;
                Paint paint11 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint11);
                canvas.drawLine(f39, f40, f41, f42, paint11);
                return;
            }
            case 4: {
                float f43 = rect.left - cornerOffset;
                float f44 = rect.centerY() - this.mBorderCornerLength;
                float f45 = rect.left - cornerOffset;
                float f46 = rect.centerY() + this.mBorderCornerLength;
                Paint paint12 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint12);
                canvas.drawLine(f43, f44, f45, f46, paint12);
                float f47 = rect.right + cornerOffset;
                float f48 = rect.centerY() - this.mBorderCornerLength;
                float f49 = rect.right + cornerOffset;
                float f50 = rect.centerY() + this.mBorderCornerLength;
                Paint paint13 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint13);
                canvas.drawLine(f47, f48, f49, f50, paint13);
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unrecognized crop shape");
            }
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled()) {
            if (this.mMultiTouchEnabled) {
                ScaleGestureDetector scaleGestureDetector = this.mScaleDetector;
                if (scaleGestureDetector != null) {
                    scaleGestureDetector.onTouchEvent(event);
                }
            }
            switch (event.getAction()) {
                case 0: {
                    this.onActionDown(event.getX(), event.getY());
                    bl = true;
                    break;
                }
                case 1: 
                case 3: {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    this.onActionUp();
                    bl = true;
                    break;
                }
                case 2: {
                    this.onActionMove(event.getX(), event.getY());
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void onActionDown(float x, float y) {
        CropImageView.CropShape cropShape = this.cropShape;
        Intrinsics.checkNotNull((Object)((Object)cropShape));
        this.mMoveHandler = this.mCropWindowHandler.getMoveHandler(x, y, this.mTouchRadius, cropShape, this.mCenterMoveEnabled);
        if (this.mMoveHandler != null) {
            this.invalidate();
        }
    }

    private final void onActionUp() {
        if (this.mMoveHandler != null) {
            this.mMoveHandler = null;
            this.callOnCropWindowChanged(false);
            this.invalidate();
        }
    }

    private final void onActionMove(float x, float y) {
        if (this.mMoveHandler != null) {
            float snapRadius = this.mSnapRadius;
            RectF rect = this.mCropWindowHandler.getRect();
            if (this.calculateBounds(rect)) {
                snapRadius = 0.0f;
            }
            CropWindowMoveHandler cropWindowMoveHandler = this.mMoveHandler;
            Intrinsics.checkNotNull((Object)cropWindowMoveHandler);
            cropWindowMoveHandler.move(rect, x, y, this.mCalcBounds, this.mViewWidth, this.mViewHeight, snapRadius, this.isFixAspectRatio, this.mTargetAspectRatio);
            this.mCropWindowHandler.setRect(rect);
            this.callOnCropWindowChanged(true);
            this.invalidate();
        }
    }

    private final boolean calculateBounds(RectF rect) {
        boolean bl;
        float left = BitmapUtils.INSTANCE.getRectLeft(this.mBoundsPoints);
        float top = BitmapUtils.INSTANCE.getRectTop(this.mBoundsPoints);
        float right = BitmapUtils.INSTANCE.getRectRight(this.mBoundsPoints);
        float bottom = BitmapUtils.INSTANCE.getRectBottom(this.mBoundsPoints);
        if (!this.isNonStraightAngleRotated()) {
            this.mCalcBounds.set(left, top, right, bottom);
            bl = false;
        } else {
            float x0 = this.mBoundsPoints[0];
            float y0 = this.mBoundsPoints[1];
            float x2 = this.mBoundsPoints[4];
            float y2 = this.mBoundsPoints[5];
            float x3 = this.mBoundsPoints[6];
            float y3 = this.mBoundsPoints[7];
            if (this.mBoundsPoints[7] < this.mBoundsPoints[1]) {
                if (this.mBoundsPoints[1] < this.mBoundsPoints[3]) {
                    x0 = this.mBoundsPoints[6];
                    y0 = this.mBoundsPoints[7];
                    x2 = this.mBoundsPoints[2];
                    y2 = this.mBoundsPoints[3];
                    x3 = this.mBoundsPoints[4];
                    y3 = this.mBoundsPoints[5];
                } else {
                    x0 = this.mBoundsPoints[4];
                    y0 = this.mBoundsPoints[5];
                    x2 = this.mBoundsPoints[0];
                    y2 = this.mBoundsPoints[1];
                    x3 = this.mBoundsPoints[2];
                    y3 = this.mBoundsPoints[3];
                }
            } else if (this.mBoundsPoints[1] > this.mBoundsPoints[3]) {
                x0 = this.mBoundsPoints[2];
                y0 = this.mBoundsPoints[3];
                x2 = this.mBoundsPoints[6];
                y2 = this.mBoundsPoints[7];
                x3 = this.mBoundsPoints[0];
                y3 = this.mBoundsPoints[1];
            }
            float a0 = (y3 - y0) / (x3 - x0);
            float a1 = -1.0f / a0;
            float b0 = y0 - a0 * x0;
            float b1 = y0 - a1 * x0;
            float b2 = y2 - a0 * x2;
            float b3 = y2 - a1 * x2;
            float c0 = (rect.centerY() - rect.top) / (rect.centerX() - rect.left);
            float c1 = -c0;
            float d0 = rect.top - c0 * rect.left;
            float d1 = rect.top - c1 * rect.right;
            float f = (d0 - b0) / (a0 - c0) < rect.right ? (d0 - b0) / (a0 - c0) : left;
            boolean bl2 = false;
            left = Math.max(left, f);
            f = (d0 - b1) / (a1 - c0) < rect.right ? (d0 - b1) / (a1 - c0) : left;
            bl2 = false;
            left = Math.max(left, f);
            f = (d1 - b3) / (a1 - c1) < rect.right ? (d1 - b3) / (a1 - c1) : left;
            bl2 = false;
            left = Math.max(left, f);
            f = (d1 - b1) / (a1 - c1) > rect.left ? (d1 - b1) / (a1 - c1) : right;
            bl2 = false;
            right = Math.min(right, f);
            f = (d1 - b2) / (a0 - c1) > rect.left ? (d1 - b2) / (a0 - c1) : right;
            bl2 = false;
            right = Math.min(right, f);
            f = (d0 - b2) / (a0 - c0) > rect.left ? (d0 - b2) / (a0 - c0) : right;
            bl2 = false;
            right = Math.min(right, f);
            f = a0 * left + b0;
            float f2 = a1 * right + b1;
            boolean bl3 = false;
            f = Math.max(f, f2);
            boolean bl4 = false;
            top = Math.max(top, f);
            f = a1 * left + b3;
            float f3 = a0 * right + b2;
            bl3 = false;
            f = Math.min(f, f3);
            boolean bl5 = false;
            bottom = Math.min(bottom, f);
            this.mCalcBounds.left = left;
            this.mCalcBounds.top = top;
            this.mCalcBounds.right = right;
            this.mCalcBounds.bottom = bottom;
            bl = true;
        }
        return bl;
    }

    private final boolean isNonStraightAngleRotated() {
        return this.mBoundsPoints[0] != this.mBoundsPoints[6] && this.mBoundsPoints[1] != this.mBoundsPoints[7];
    }

    private final void callOnCropWindowChanged(boolean inProgress) {
        try {
            CropWindowChangeListener cropWindowChangeListener = this.mCropWindowChangeListener;
            if (cropWindowChangeListener != null) {
                cropWindowChangeListener.onCropWindowChanged(inProgress);
            }
        }
        catch (Exception e) {
            Log.e((String)"AIC", (String)"Exception in crop window changed", (Throwable)e);
        }
    }

    @JvmOverloads
    public CropOverlayView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mCenterMoveEnabled = true;
        this.mCropWindowHandler = new CropWindowHandler();
        this.mDrawRect = new RectF();
        this.mPath = new Path();
        this.mBoundsPoints = new float[8];
        this.mCalcBounds = new RectF();
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        this.mInitialCropWindowRect = new Rect();
    }

    public /* synthetic */ CropOverlayView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @JvmOverloads
    public CropOverlayView(@Nullable Context context) {
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropOverlayView$CropWindowChangeListener;", "", "onCropWindowChanged", "", "inProgress", "", "cropper_release"})
    public static interface CropWindowChangeListener {
        public void onCropWindowChanged(boolean var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lcom/canhub/cropper/CropOverlayView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/canhub/cropper/CropOverlayView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "cropper_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        @TargetApi(value=11)
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            RectF rect = CropOverlayView.this.mCropWindowHandler.getRect();
            float x = detector.getFocusX();
            float y = detector.getFocusY();
            float dY = detector.getCurrentSpanY() / (float)2;
            float dX = detector.getCurrentSpanX() / (float)2;
            float newTop = y - dY;
            float newLeft = x - dX;
            float newRight = x + dX;
            float newBottom = y + dY;
            if (newLeft < newRight && newTop <= newBottom && newLeft >= 0.0f && newRight <= CropOverlayView.this.mCropWindowHandler.getMaxCropWidth() && newTop >= 0.0f && newBottom <= CropOverlayView.this.mCropWindowHandler.getMaxCropHeight()) {
                rect.set(newLeft, newTop, newRight, newBottom);
                CropOverlayView.this.mCropWindowHandler.setRect(rect);
                CropOverlayView.this.invalidate();
            }
            return true;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/canhub/cropper/CropOverlayView$Companion;", "", "()V", "getNewPaint", "Landroid/graphics/Paint;", "color", "", "getNewPaintOrNull", "thickness", "", "cropper_release"})
    public static final class Companion {
        private final Paint getNewPaint(int color) {
            Paint paint = new Paint();
            boolean bl = false;
            boolean bl2 = false;
            Paint $this$apply = paint;
            boolean bl3 = false;
            $this$apply.setColor(color);
            return paint;
        }

        /*
         * WARNING - void declaration
         */
        private final Paint getNewPaintOrNull(float thickness, int color) {
            Paint paint;
            if (thickness > 0.0f) {
                void var3_3;
                Paint borderPaint = new Paint();
                borderPaint.setColor(color);
                borderPaint.setStrokeWidth(thickness);
                borderPaint.setStyle(Paint.Style.STROKE);
                borderPaint.setAntiAlias(true);
                paint = var3_3;
            } else {
                paint = null;
            }
            return paint;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

