/*
 * Decompiled with CFR 0.152.
 */
package io.calidog.certstream;

import io.calidog.certstream.CertStreamCertificatePOJO;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class CertStreamCertificate
extends X509Certificate {
    private HashMap<String, String> subject;
    private HashMap<String, String> extensions;
    private double notBefore;
    private double notAfter;
    private String asDer;
    String serialNumber;
    String fingerprint;
    String[] allDomains;
    private byte[] memoizedEncodedCert = null;

    private CertStreamCertificate() {
    }

    public static CertStreamCertificate fromPOJO(CertStreamCertificatePOJO pojo) throws CertificateException {
        CertStreamCertificate fullCertificate = new CertStreamCertificate();
        if (pojo.asDer.isEmpty()) {
            return null;
        }
        fullCertificate.asDer = pojo.asDer;
        fullCertificate.extensions = pojo.extensions;
        fullCertificate.notAfter = pojo.notAfter;
        fullCertificate.notBefore = pojo.notBefore;
        fullCertificate.subject = pojo.subject;
        fullCertificate.serialNumber = pojo.serialNumber;
        fullCertificate.fingerprint = pojo.fingerprint;
        fullCertificate.allDomains = pojo.allDomains;
        return fullCertificate;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(Date.from(Instant.now()));
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException();
        }
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException();
        }
    }

    @Override
    public int getVersion() {
        throw new NotImplementedException();
    }

    @Override
    public BigInteger getSerialNumber() {
        throw new NotImplementedException();
    }

    @Override
    public Principal getIssuerDN() {
        throw new NotImplementedException();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        throw new NotImplementedException();
    }

    @Override
    public Principal getSubjectDN() {
        return () -> this.subject.get("DN");
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return new X500Principal("", this.subject);
    }

    @Override
    public Date getNotBefore() {
        return new Date((long)this.notBefore);
    }

    @Override
    public Date getNotAfter() {
        return new Date((long)this.notAfter);
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        throw new NotImplementedException();
    }

    @Override
    public byte[] getSignature() {
        throw new NotImplementedException();
    }

    @Override
    public String getSigAlgName() {
        throw new NotImplementedException();
    }

    @Override
    public String getSigAlgOID() {
        throw new NotImplementedException();
    }

    @Override
    public byte[] getSigAlgParams() {
        throw new NotImplementedException();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        throw new NotImplementedException();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        throw new NotImplementedException();
    }

    @Override
    public boolean[] getKeyUsage() {
        throw new NotImplementedException();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        throw new NotImplementedException();
    }

    @Override
    public int getBasicConstraints() {
        throw new NotImplementedException();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        throw new NotImplementedException();
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return super.getIssuerAlternativeNames();
    }

    @Override
    public void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        super.verify(publicKey, provider);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.memoizedEncodedCert == null) {
            this.memoizedEncodedCert = Base64.getDecoder().decode(this.asDer);
        }
        return Arrays.copyOf(this.memoizedEncodedCert, this.memoizedEncodedCert.length);
    }

    @Override
    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new NotImplementedException();
    }

    @Override
    public void verify(PublicKey publicKey, String s) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        throw new NotImplementedException();
    }

    @Override
    public PublicKey getPublicKey() {
        throw new NotImplementedException();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        throw new NotImplementedException();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        throw new NotImplementedException();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        throw new NotImplementedException();
    }

    @Override
    public byte[] getExtensionValue(String s) {
        throw new NotImplementedException();
    }

    public String getStringExtensionValue(String key) {
        return this.extensions.get(key);
    }
}

