/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bytehamster.lib.preferencesearch.HistoryItem;
import com.bytehamster.lib.preferencesearch.ListItem;
import com.bytehamster.lib.preferencesearch.PreferenceItem;
import com.bytehamster.lib.preferencesearch.R;
import com.bytehamster.lib.preferencesearch.SearchConfiguration;
import java.util.ArrayList;
import java.util.List;

class SearchPreferenceAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<ListItem> dataset = new ArrayList<ListItem>();
    private SearchConfiguration searchConfiguration;
    private SearchClickListener onItemClickListener;

    SearchPreferenceAdapter() {
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new PreferenceViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.searchpreference_list_item_result, parent, false));
        }
        return new HistoryViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.searchpreference_list_item_history, parent, false));
    }

    public void onBindViewHolder(final @NonNull ViewHolder h, int position) {
        final ListItem listItem = this.dataset.get(position);
        if (this.getItemViewType(position) == 1) {
            HistoryViewHolder holder = (HistoryViewHolder)h;
            HistoryItem item = (HistoryItem)listItem;
            holder.term.setText((CharSequence)item.getTerm());
        } else if (this.getItemViewType(position) == 2) {
            PreferenceViewHolder holder = (PreferenceViewHolder)h;
            PreferenceItem item = (PreferenceItem)listItem;
            holder.title.setText((CharSequence)item.title);
            if (TextUtils.isEmpty((CharSequence)item.summary)) {
                holder.summary.setVisibility(8);
            } else {
                holder.summary.setVisibility(0);
                holder.summary.setText((CharSequence)item.summary);
            }
            if (this.searchConfiguration.isBreadcrumbsEnabled()) {
                holder.breadcrumbs.setText((CharSequence)item.breadcrumbs);
                holder.breadcrumbs.setAlpha(0.6f);
                holder.summary.setAlpha(1.0f);
            } else {
                holder.breadcrumbs.setVisibility(8);
                holder.summary.setAlpha(0.6f);
            }
        }
        h.root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchPreferenceAdapter.this.onItemClickListener != null) {
                    SearchPreferenceAdapter.this.onItemClickListener.onItemClicked(listItem, h.getAdapterPosition());
                }
            }
        });
    }

    void setContent(List<ListItem> items) {
        this.dataset = new ArrayList<ListItem>(items);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.dataset.size();
    }

    public int getItemViewType(int position) {
        return this.dataset.get(position).getType();
    }

    void setSearchConfiguration(SearchConfiguration searchConfiguration) {
        this.searchConfiguration = searchConfiguration;
    }

    void setOnItemClickListener(SearchClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    static class PreferenceViewHolder
    extends ViewHolder {
        TextView title;
        TextView summary;
        TextView breadcrumbs;

        PreferenceViewHolder(View v) {
            super(v);
            this.title = (TextView)v.findViewById(R.id.title);
            this.summary = (TextView)v.findViewById(R.id.summary);
            this.breadcrumbs = (TextView)v.findViewById(R.id.breadcrumbs);
        }
    }

    static class HistoryViewHolder
    extends ViewHolder {
        TextView term;

        HistoryViewHolder(View v) {
            super(v);
            this.term = (TextView)v.findViewById(R.id.term);
        }
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        View root;

        ViewHolder(View v) {
            super(v);
            this.root = v;
        }
    }

    static interface SearchClickListener {
        public void onItemClicked(ListItem var1, int var2);
    }
}

