/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.XmlRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import com.bytehamster.lib.preferencesearch.Breadcrumb;
import com.bytehamster.lib.preferencesearch.SearchPreferenceFragment;
import com.bytehamster.lib.preferencesearch.SearchPreferenceResultListener;
import com.bytehamster.lib.preferencesearch.ui.RevealAnimationSetting;
import java.util.ArrayList;

public class SearchConfiguration {
    private static final String ARGUMENT_INDEX_ITEMS = "items";
    private static final String ARGUMENT_FUZZY_ENABLED = "fuzzy";
    private static final String ARGUMENT_HISTORY_ENABLED = "history_enabled";
    private static final String ARGUMENT_SEARCH_BAR_ENABLED = "search_bar_enabled";
    private static final String ARGUMENT_BREADCRUMBS_ENABLED = "breadcrumbs_enabled";
    private static final String ARGUMENT_REVEAL_ANIMATION_SETTING = "reveal_anim_setting";
    private static final String ARGUMENT_TEXT_HINT = "text_hint";
    private static final String ARGUMENT_TEXT_CLEAR_HISTORY = "text_clear_history";
    private static final String ARGUMENT_TEXT_NO_RESULTS = "text_no_results";
    private ArrayList<SearchIndexItem> itemsToIndex = new ArrayList();
    private boolean historyEnabled = true;
    private boolean breadcrumbsEnabled = false;
    private boolean fuzzySearchEnabled = true;
    private boolean searchBarEnabled = true;
    private AppCompatActivity activity;
    private int containerResId = 0x1020002;
    private RevealAnimationSetting revealAnimationSetting = null;
    private String textClearHistory;
    private String textNoResults;
    private String textHint;

    SearchConfiguration() {
    }

    public SearchConfiguration(AppCompatActivity activity) {
        this.setActivity(activity);
    }

    public SearchPreferenceFragment showSearchFragment() {
        if (this.activity == null) {
            throw new IllegalStateException("setActivity() not called");
        }
        Bundle arguments = this.toBundle();
        SearchPreferenceFragment fragment = new SearchPreferenceFragment();
        fragment.setArguments(arguments);
        this.activity.getSupportFragmentManager().beginTransaction().add(this.containerResId, (Fragment)fragment, "SearchPreferenceFragment").addToBackStack("SearchPreferenceFragment").commit();
        return fragment;
    }

    private Bundle toBundle() {
        Bundle arguments = new Bundle();
        arguments.putParcelableArrayList(ARGUMENT_INDEX_ITEMS, this.itemsToIndex);
        arguments.putBoolean(ARGUMENT_HISTORY_ENABLED, this.historyEnabled);
        arguments.putParcelable(ARGUMENT_REVEAL_ANIMATION_SETTING, (Parcelable)this.revealAnimationSetting);
        arguments.putBoolean(ARGUMENT_FUZZY_ENABLED, this.fuzzySearchEnabled);
        arguments.putBoolean(ARGUMENT_BREADCRUMBS_ENABLED, this.breadcrumbsEnabled);
        arguments.putBoolean(ARGUMENT_SEARCH_BAR_ENABLED, this.searchBarEnabled);
        arguments.putString(ARGUMENT_TEXT_HINT, this.textHint);
        arguments.putString(ARGUMENT_TEXT_CLEAR_HISTORY, this.textClearHistory);
        arguments.putString(ARGUMENT_TEXT_NO_RESULTS, this.textNoResults);
        return arguments;
    }

    static SearchConfiguration fromBundle(Bundle bundle) {
        SearchConfiguration config = new SearchConfiguration();
        config.itemsToIndex = bundle.getParcelableArrayList(ARGUMENT_INDEX_ITEMS);
        config.historyEnabled = bundle.getBoolean(ARGUMENT_HISTORY_ENABLED);
        config.revealAnimationSetting = (RevealAnimationSetting)bundle.getParcelable(ARGUMENT_REVEAL_ANIMATION_SETTING);
        config.fuzzySearchEnabled = bundle.getBoolean(ARGUMENT_FUZZY_ENABLED);
        config.breadcrumbsEnabled = bundle.getBoolean(ARGUMENT_BREADCRUMBS_ENABLED);
        config.searchBarEnabled = bundle.getBoolean(ARGUMENT_SEARCH_BAR_ENABLED);
        config.textHint = bundle.getString(ARGUMENT_TEXT_HINT);
        config.textClearHistory = bundle.getString(ARGUMENT_TEXT_CLEAR_HISTORY);
        config.textNoResults = bundle.getString(ARGUMENT_TEXT_NO_RESULTS);
        return config;
    }

    public void setActivity(@NonNull AppCompatActivity activity) {
        this.activity = activity;
        if (!(activity instanceof SearchPreferenceResultListener)) {
            throw new IllegalArgumentException("Activity must implement SearchPreferenceResultListener");
        }
    }

    public void setHistoryEnabled(boolean historyEnabled) {
        this.historyEnabled = historyEnabled;
    }

    public void setFuzzySearchEnabled(boolean fuzzySearchEnabled) {
        this.fuzzySearchEnabled = fuzzySearchEnabled;
    }

    public void setBreadcrumbsEnabled(boolean breadcrumbsEnabled) {
        this.breadcrumbsEnabled = breadcrumbsEnabled;
    }

    public void setSearchBarEnabled(boolean searchBarEnabled) {
        this.searchBarEnabled = searchBarEnabled;
    }

    public void setFragmentContainerViewId(@IdRes int containerResId) {
        this.containerResId = containerResId;
    }

    public void useAnimation(int centerX, int centerY, int width, int height, @ColorInt int colorAccent) {
        this.revealAnimationSetting = new RevealAnimationSetting(centerX, centerY, width, height, colorAccent);
    }

    public SearchIndexItem index(@XmlRes int resId) {
        SearchIndexItem item = new SearchIndexItem(resId, this);
        this.itemsToIndex.add(item);
        return item;
    }

    ArrayList<SearchIndexItem> getFiles() {
        return this.itemsToIndex;
    }

    boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    boolean isBreadcrumbsEnabled() {
        return this.breadcrumbsEnabled;
    }

    boolean isFuzzySearchEnabled() {
        return this.fuzzySearchEnabled;
    }

    boolean isSearchBarEnabled() {
        return this.searchBarEnabled;
    }

    RevealAnimationSetting getRevealAnimationSetting() {
        return this.revealAnimationSetting;
    }

    public String getTextClearHistory() {
        return this.textClearHistory;
    }

    public void setTextClearHistory(String textClearHistory) {
        this.textClearHistory = textClearHistory;
    }

    public String getTextNoResults() {
        return this.textNoResults;
    }

    public void setTextNoResults(String textNoResults) {
        this.textNoResults = textNoResults;
    }

    public String getTextHint() {
        return this.textHint;
    }

    public void setTextHint(String textHint) {
        this.textHint = textHint;
    }

    public static class SearchIndexItem
    implements Parcelable {
        private String breadcrumb = "";
        @XmlRes
        private final int resId;
        private final SearchConfiguration searchConfiguration;
        public static final Parcelable.Creator<SearchIndexItem> CREATOR = new Parcelable.Creator<SearchIndexItem>(){

            public SearchIndexItem createFromParcel(Parcel in) {
                return new SearchIndexItem(in);
            }

            public SearchIndexItem[] newArray(int size) {
                return new SearchIndexItem[size];
            }
        };

        private SearchIndexItem(@XmlRes int resId, SearchConfiguration searchConfiguration) {
            this.resId = resId;
            this.searchConfiguration = searchConfiguration;
        }

        public SearchIndexItem addBreadcrumb(@StringRes int breadcrumb) {
            this.assertNotParcel();
            return this.addBreadcrumb(this.searchConfiguration.activity.getString(breadcrumb));
        }

        public SearchIndexItem addBreadcrumb(String breadcrumb) {
            this.assertNotParcel();
            this.breadcrumb = Breadcrumb.concat(this.breadcrumb, breadcrumb);
            return this;
        }

        private void assertNotParcel() {
            if (this.searchConfiguration == null) {
                throw new IllegalStateException("SearchIndexItems that are restored from parcel can not be modified.");
            }
        }

        @XmlRes
        int getResId() {
            return this.resId;
        }

        String getBreadcrumb() {
            return this.breadcrumb;
        }

        private SearchIndexItem(Parcel parcel) {
            this.breadcrumb = parcel.readString();
            this.resId = parcel.readInt();
            this.searchConfiguration = null;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.breadcrumb);
            dest.writeInt(this.resId);
        }

        public int describeContents() {
            return 0;
        }
    }
}

