/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bytehamster.lib.preferencesearch.Breadcrumb;
import com.bytehamster.lib.preferencesearch.PreferenceItem;
import com.bytehamster.lib.preferencesearch.SearchConfiguration;
import com.bytehamster.lib.preferencesearch.SearchPreference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

class PreferenceParser {
    private static final int MAX_RESULTS = 10;
    private static final String NS_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final String NS_SEARCH = "http://schemas.android.com/apk/com.bytehamster.lib.preferencesearch";
    private static final List<String> BLACKLIST = Arrays.asList(SearchPreference.class.getName(), "PreferenceCategory");
    private static final List<String> CONTAINERS = Arrays.asList("PreferenceCategory", "PreferenceScreen");
    private Context context;
    private ArrayList<PreferenceItem> allEntries = new ArrayList();

    PreferenceParser(Context context) {
        this.context = context;
    }

    void addResourceFile(SearchConfiguration.SearchIndexItem item) {
        this.allEntries.addAll(this.parseFile(item));
    }

    private ArrayList<PreferenceItem> parseFile(SearchConfiguration.SearchIndexItem item) {
        ArrayList<PreferenceItem> results = new ArrayList<PreferenceItem>();
        XmlResourceParser xpp = this.context.getResources().getXml(item.getResId());
        try {
            xpp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xpp.setFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", true);
            ArrayList<String> breadcrumbs = new ArrayList<String>();
            ArrayList<String> keyBreadcrumbs = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)item.getBreadcrumb())) {
                breadcrumbs.add(item.getBreadcrumb());
            }
            while (xpp.getEventType() != 1) {
                if (xpp.getEventType() == 2) {
                    PreferenceItem result = this.parseSearchResult((XmlPullParser)xpp);
                    result.resId = item.getResId();
                    if (!BLACKLIST.contains(xpp.getName()) && result.hasData()) {
                        result.breadcrumbs = this.joinBreadcrumbs(breadcrumbs);
                        result.keyBreadcrumbs = this.cleanupKeyBreadcrumbs(keyBreadcrumbs);
                        if (!"true".equals(this.getAttribute((XmlPullParser)xpp, NS_SEARCH, "ignore"))) {
                            results.add(result);
                        }
                    }
                    if (CONTAINERS.contains(xpp.getName())) {
                        breadcrumbs.add(result.title == null ? "" : result.title);
                    }
                    if (xpp.getName().equals("PreferenceScreen")) {
                        keyBreadcrumbs.add(this.getAttribute((XmlPullParser)xpp, "key"));
                    }
                } else if (xpp.getEventType() == 3 && CONTAINERS.contains(xpp.getName())) {
                    breadcrumbs.remove(breadcrumbs.size() - 1);
                    if (xpp.getName().equals("PreferenceScreen")) {
                        keyBreadcrumbs.remove(keyBreadcrumbs.size() - 1);
                    }
                }
                xpp.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private ArrayList<String> cleanupKeyBreadcrumbs(ArrayList<String> keyBreadcrumbs) {
        ArrayList<String> result = new ArrayList<String>();
        for (String keyBreadcrumb : keyBreadcrumbs) {
            if (keyBreadcrumb == null) continue;
            result.add(keyBreadcrumb);
        }
        return result;
    }

    private String joinBreadcrumbs(ArrayList<String> breadcrumbs) {
        String result = "";
        for (String crumb : breadcrumbs) {
            if (TextUtils.isEmpty((CharSequence)crumb)) continue;
            result = Breadcrumb.concat(result, crumb);
        }
        return result;
    }

    private String getAttribute(XmlPullParser xpp, @Nullable String namespace, @NonNull String attribute) {
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            Log.d((String)"ns", (String)xpp.getAttributeNamespace(i));
            if (!attribute.equals(xpp.getAttributeName(i)) || namespace != null && !namespace.equals(xpp.getAttributeNamespace(i))) continue;
            return xpp.getAttributeValue(i);
        }
        return null;
    }

    private String getAttribute(XmlPullParser xpp, @NonNull String attribute) {
        if (this.hasAttribute(xpp, NS_SEARCH, attribute)) {
            return this.getAttribute(xpp, NS_SEARCH, attribute);
        }
        return this.getAttribute(xpp, NS_ANDROID, attribute);
    }

    private boolean hasAttribute(XmlPullParser xpp, @Nullable String namespace, @NonNull String attribute) {
        return this.getAttribute(xpp, namespace, attribute) != null;
    }

    private PreferenceItem parseSearchResult(XmlPullParser xpp) {
        PreferenceItem result = new PreferenceItem();
        result.title = this.readString(this.getAttribute(xpp, "title"));
        result.summary = this.readString(this.getAttribute(xpp, "summary"));
        result.key = this.readString(this.getAttribute(xpp, "key"));
        result.entries = this.readStringArray(this.getAttribute(xpp, "entries"));
        result.keywords = this.readString(this.getAttribute(xpp, NS_SEARCH, "keywords"));
        Log.d((String)"PreferenceParser", (String)("Found: " + xpp.getName() + "/" + result));
        return result;
    }

    private String readStringArray(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("@")) {
            try {
                int id = Integer.parseInt(s.substring(1));
                Object[] elements = this.context.getResources().getStringArray(id);
                return TextUtils.join((CharSequence)",", (Object[])elements);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    private String readString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("@")) {
            try {
                int id = Integer.parseInt(s.substring(1));
                return this.context.getString(id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    List<PreferenceItem> searchFor(final String keyword, boolean fuzzy) {
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            return new ArrayList<PreferenceItem>();
        }
        ArrayList<PreferenceItem> results = new ArrayList<PreferenceItem>();
        for (PreferenceItem item : this.allEntries) {
            if ((!fuzzy || !item.matchesFuzzy(keyword)) && (fuzzy || !item.matches(keyword))) continue;
            results.add(item);
        }
        Collections.sort(results, new Comparator<PreferenceItem>(){

            @Override
            public int compare(PreferenceItem i1, PreferenceItem i2) {
                return PreferenceParser.floatCompare(i2.getScore(keyword), i1.getScore(keyword));
            }
        });
        if (results.size() > 10) {
            return results.subList(0, 10);
        }
        return results;
    }

    private static int floatCompare(float x, float y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

