/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.api.BlueMapWorld;
import java.util.function.Predicate;

public interface BlueMapMap {
    public String getId();

    public String getName();

    public BlueMapWorld getWorld();

    public Vector2i getTileSize();

    public Vector2i getTileOffset();

    public void setTileFilter(Predicate<Vector2i> var1);

    public void setFrozen(boolean var1);

    public boolean isFrozen();

    public Predicate<Vector2i> getTileFilter();

    default public Vector2i posToTile(double blockX, double blockZ) {
        Vector2i offset = this.getTileOffset();
        Vector2i size = this.getTileSize();
        return Vector2i.from((int)((int)Math.floor((blockX - (double)offset.getX()) / (double)size.getX())), (int)((int)Math.floor((blockZ - (double)offset.getY()) / (double)size.getY())));
    }

    default public Vector2i posToTile(Vector3i pos) {
        return this.posToTile(pos.getX(), pos.getZ());
    }

    default public Vector2i posToTile(Vector3d pos) {
        return this.posToTile(pos.getX(), pos.getZ());
    }
}

