/*
 * Decompiled with CFR 0.152.
 */
package com.blackcat.currencyedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.EditText;
import com.blackcat.currencyedittext.CurrencyTextFormatter;
import com.blackcat.currencyedittext.CurrencyTextWatcher;
import com.blackcat.currencyedittext.R;
import java.util.Currency;
import java.util.Locale;

public class CurrencyEditText
extends EditText {
    private Locale locale;
    private Currency currency;
    private Locale defaultLocale;
    private boolean defaultHintEnabled;
    private boolean allowNegativeValues;
    private long valueInLowestDenom;
    private CurrencyTextWatcher textWatcher;
    private String hintCache;

    public CurrencyEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.locale = this.getResources().getConfiguration().locale;
        this.defaultLocale = Locale.US;
        this.defaultHintEnabled = true;
        this.allowNegativeValues = false;
        this.valueInLowestDenom = 0L;
        this.hintCache = null;
        this.setInputType(12290);
        this.init();
        this.processAttributes(context, attrs);
    }

    private void init() {
        this.initCurrency();
        this.initCurrencyTextWatcher();
    }

    private void initCurrencyTextWatcher() {
        if (this.textWatcher != null) {
            this.removeTextChangedListener(this.textWatcher);
        }
        this.textWatcher = new CurrencyTextWatcher(this, this.defaultLocale);
        this.addTextChangedListener(this.textWatcher);
    }

    private void initCurrency() {
        try {
            this.currency = Currency.getInstance(this.locale);
        }
        catch (IllegalArgumentException e) {
            this.currency = Currency.getInstance(this.defaultLocale);
        }
    }

    public void setDefaultHintEnabled(boolean useDefaultHint) {
        this.defaultHintEnabled = useDefaultHint;
    }

    public boolean getDefaultHintEnabled() {
        return this.defaultHintEnabled;
    }

    public void setAllowNegativeValues(boolean negativeValuesAllowed) {
        this.allowNegativeValues = negativeValuesAllowed;
    }

    public boolean areNegativeValuesAllowed() {
        return this.allowNegativeValues;
    }

    public long getRawValue() {
        return this.valueInLowestDenom;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.init();
        this.updateHint();
    }

    public void setCurrency(Currency currency, Locale locale) {
        this.currency = currency;
        this.locale = locale;
        this.init();
        this.updateHint();
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
        this.init();
        this.updateHint();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    private void updateHint() {
        if (this.hintCache != null) {
            this.setHint(this.hintCache);
        } else if (this.defaultHintEnabled) {
            this.setHint(this.getDefaultHintValue());
        }
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
        this.init();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public String formatCurrency(String val) {
        return CurrencyTextFormatter.formatText(val, this.currency, this.locale, this.defaultLocale);
    }

    public String formatCurrency(long rawVal) {
        return CurrencyTextFormatter.formatText(String.valueOf(rawVal), this.currency, this.locale, this.defaultLocale);
    }

    protected void setValueInLowestDenom(Long mValueInLowestDenom) {
        this.valueInLowestDenom = mValueInLowestDenom;
    }

    private void processAttributes(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CurrencyEditText);
        boolean defaultHintAttrVal = array.getBoolean(R.styleable.CurrencyEditText_enable_default_hint, true);
        this.configureHint(defaultHintAttrVal);
        this.setAllowNegativeValues(array.getBoolean(R.styleable.CurrencyEditText_allow_negative_values, false));
        array.recycle();
    }

    private void configureHint(boolean defaultHintAttrVal) {
        if (this.hintAlreadySet()) {
            this.setDefaultHintEnabled(false);
            this.hintCache = this.getHint().toString();
            return;
        }
        this.setDefaultHintEnabled(defaultHintAttrVal);
        if (this.getDefaultHintEnabled()) {
            this.setHint(this.getDefaultHintValue());
        } else {
            Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"configureHint: Default Hint disabled; ignoring request.");
        }
    }

    private boolean hintAlreadySet() {
        return this.getHint() != null && !this.getHint().equals("");
    }

    private String getDefaultHintValue() {
        return this.currency.getSymbol();
    }
}

