package com.whatsapp.api.domain.messages.type;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The enum Button subtype.
 * Required when type=button. Not used for the other types.
 */
public enum ButtonSubType {

    /**
     * Quick reply button subtype. Refers to a previously created quick reply button that allows for the customer to return a predefined message.
     */
    QUICK_REPLY("quick_reply"),
    /**
     * Url button subtype.Refers to a previously created button that allows the customer to visit the URL generated by appending the text parameter to the predefined prefix URL in the template.
     */
    URL("url");

    private final String value;

    ButtonSubType(String value) {
        this.value = value;
    }

    /**
     * Gets value.
     *
     * @return the value
     */
    @JsonValue
    public String getValue() {
        return value;
    }
}
