/*
 * Decompiled with CFR 0.152.
 */
package it.beppi.tristatetogglebutton_library;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.rebound.SimpleSpringListener;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringConfig;
import com.facebook.rebound.SpringSystem;
import com.facebook.rebound.SpringUtil;
import it.beppi.tristatetogglebutton_library.R;

public class TriStateToggleButton
extends View {
    private SpringSystem springSystem;
    private Spring spring;
    private float radius;
    private int onColor = Color.parseColor((String)"#42bd41");
    private int offBorderColor = Color.parseColor((String)"#bdbdbd");
    private int offColor = Color.parseColor((String)"#ffffff");
    private int midColor = Color.parseColor((String)"#ffca28");
    private int spotColor = Color.parseColor((String)"#ffffff");
    private int borderColor = this.offBorderColor;
    private Paint paint;
    private ToggleStatus toggleStatus = ToggleStatus.off;
    private ToggleStatus previousToggleStatus = ToggleStatus.off;
    private int borderWidth = 2;
    private float centerY;
    private float startX;
    private float midX;
    private float endX;
    private float spotMinX;
    private float spotMidX;
    private float spotMaxX;
    private int spotSize;
    private float spotX;
    private float offLineWidth;
    private RectF rect = new RectF();
    private boolean defaultAnimate = true;
    private boolean midSelectable = true;
    private int swipeSensitivityPixels = 200;
    private int swipeX = 0;
    private ToggleStatus defaultStatus = ToggleStatus.off;
    private boolean enabled = true;
    private int disabledColor = Color.parseColor((String)"#bdbdbd");
    private boolean swipeing = false;
    private OnToggleChanged listener;
    SimpleSpringListener springListener = new SimpleSpringListener(){

        @Override
        public void onSpringUpdate(Spring spring) {
            double value = spring.getCurrentValue();
            TriStateToggleButton.this.calculateEffect(value);
        }
    };

    private ToggleStatus attrToStatus(String attr) {
        if (attr == null) {
            return ToggleStatus.off;
        }
        if (attr.equals("0")) {
            return ToggleStatus.off;
        }
        if (attr.equals("1")) {
            return ToggleStatus.mid;
        }
        return ToggleStatus.on;
    }

    public static boolean toggleStatusToBoolean(ToggleStatus toggleStatus) {
        return toggleStatus == ToggleStatus.on;
    }

    public static ToggleStatus booleanToToggleStatus(boolean toggleStatus) {
        if (toggleStatus) {
            return ToggleStatus.on;
        }
        return ToggleStatus.off;
    }

    public static int toggleStatusToInt(ToggleStatus toggleStatus) {
        switch (toggleStatus) {
            case off: {
                return 0;
            }
            case mid: {
                return 1;
            }
        }
        return 2;
    }

    public static ToggleStatus intToToggleStatus(int toggleIntValue) {
        if (toggleIntValue == 0) {
            return ToggleStatus.off;
        }
        if (toggleIntValue == 1) {
            return ToggleStatus.mid;
        }
        return ToggleStatus.on;
    }

    private TriStateToggleButton(Context context) {
        super(context);
    }

    public TriStateToggleButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(attrs);
    }

    public TriStateToggleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.spring.removeListener(this.springListener);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.spring.addListener(this.springListener);
    }

    public void setup(AttributeSet attrs) {
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.springSystem = SpringSystem.create();
        this.spring = this.springSystem.createSpring();
        this.spring.setSpringConfig(SpringConfig.fromOrigamiTensionAndFriction(50.0, 7.0));
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                TriStateToggleButton.this.toggle(TriStateToggleButton.this.defaultAnimate);
            }
        });
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                int x = (int)motionEvent.getX();
                int action = motionEvent.getAction();
                if (action == 0) {
                    TriStateToggleButton.this.swipeX = x;
                    TriStateToggleButton.this.swipeing = false;
                } else if (action == 2) {
                    if (TriStateToggleButton.this.swipeSensitivityPixels == 0) {
                        return false;
                    }
                    if (x - TriStateToggleButton.this.swipeX > TriStateToggleButton.this.swipeSensitivityPixels) {
                        TriStateToggleButton.this.swipeX = x;
                        TriStateToggleButton.this.swipeing = true;
                        TriStateToggleButton.this.increaseValue();
                        return true;
                    }
                    if (TriStateToggleButton.this.swipeX - x > TriStateToggleButton.this.swipeSensitivityPixels) {
                        TriStateToggleButton.this.swipeX = x;
                        TriStateToggleButton.this.swipeing = true;
                        TriStateToggleButton.this.decreaseValue();
                        return true;
                    }
                } else if (action == 1) {
                    if (!TriStateToggleButton.this.swipeing) {
                        TriStateToggleButton.this.toggle(TriStateToggleButton.this.defaultAnimate);
                    }
                    return true;
                }
                return false;
            }
        });
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TriStateToggleButton);
        this.offBorderColor = typedArray.getColor(R.styleable.TriStateToggleButton_tbOffBorderColor, this.offBorderColor);
        this.onColor = typedArray.getColor(R.styleable.TriStateToggleButton_tbOnColor, this.onColor);
        this.spotColor = typedArray.getColor(R.styleable.TriStateToggleButton_tbSpotColor, this.spotColor);
        this.offColor = typedArray.getColor(R.styleable.TriStateToggleButton_tbOffColor, this.offColor);
        this.midColor = typedArray.getColor(R.styleable.TriStateToggleButton_tbMidColor, this.midColor);
        this.borderWidth = typedArray.getDimensionPixelSize(R.styleable.TriStateToggleButton_tbBorderWidth, this.borderWidth);
        this.defaultAnimate = typedArray.getBoolean(R.styleable.TriStateToggleButton_tbAnimate, this.defaultAnimate);
        this.defaultStatus = this.attrToStatus(typedArray.getString(R.styleable.TriStateToggleButton_tbDefaultStatus));
        this.midSelectable = typedArray.getBoolean(R.styleable.TriStateToggleButton_tbIsMidSelectable, this.midSelectable);
        this.enabled = typedArray.getBoolean(R.styleable.TriStateToggleButton_enabled, this.enabled);
        this.swipeSensitivityPixels = typedArray.getInt(R.styleable.TriStateToggleButton_tbSwipeSensitivityPixels, this.swipeSensitivityPixels);
        typedArray.recycle();
        this.borderColor = this.offBorderColor;
        switch (this.defaultStatus) {
            case off: {
                this.toggleOff();
                break;
            }
            case mid: {
                this.toggleMid();
                break;
            }
            case on: {
                this.toggleOn();
            }
        }
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean animate) {
        if (this.midSelectable) {
            switch (this.toggleStatus) {
                case off: {
                    this.putValueInToggleStatus(ToggleStatus.mid);
                    break;
                }
                case mid: {
                    this.putValueInToggleStatus(ToggleStatus.on);
                    break;
                }
                case on: {
                    this.putValueInToggleStatus(ToggleStatus.off);
                }
            }
        } else {
            switch (this.toggleStatus) {
                case off: 
                case mid: {
                    this.putValueInToggleStatus(ToggleStatus.on);
                    break;
                }
                case on: {
                    this.putValueInToggleStatus(ToggleStatus.off);
                }
            }
        }
        this.takeEffect(animate);
        if (this.listener != null) {
            this.listener.onToggle(this.toggleStatus, TriStateToggleButton.toggleStatusToBoolean(this.toggleStatus), TriStateToggleButton.toggleStatusToInt(this.toggleStatus));
        }
    }

    public void toggleOn() {
        this.setToggleOn();
        if (this.listener != null) {
            this.listener.onToggle(this.toggleStatus, TriStateToggleButton.toggleStatusToBoolean(this.toggleStatus), TriStateToggleButton.toggleStatusToInt(this.toggleStatus));
        }
    }

    public void toggleOff() {
        this.setToggleOff();
        if (this.listener != null) {
            this.listener.onToggle(this.toggleStatus, TriStateToggleButton.toggleStatusToBoolean(this.toggleStatus), TriStateToggleButton.toggleStatusToInt(this.toggleStatus));
        }
    }

    public void toggleMid() {
        this.setToggleMid();
        if (this.listener != null) {
            this.listener.onToggle(this.toggleStatus, TriStateToggleButton.toggleStatusToBoolean(this.toggleStatus), TriStateToggleButton.toggleStatusToInt(this.toggleStatus));
        }
    }

    private void putValueInToggleStatus(ToggleStatus value) {
        if (!this.enabled) {
            return;
        }
        this.previousToggleStatus = this.toggleStatus;
        this.toggleStatus = value;
    }

    public void setToggleOn() {
        this.setToggleOn(true);
    }

    public void setToggleOn(boolean animate) {
        this.putValueInToggleStatus(ToggleStatus.on);
        this.takeEffect(animate);
    }

    public void setToggleOff() {
        this.setToggleOff(true);
    }

    public void setToggleOff(boolean animate) {
        this.putValueInToggleStatus(ToggleStatus.off);
        this.takeEffect(animate);
    }

    public void setToggleMid(boolean animate) {
        this.putValueInToggleStatus(ToggleStatus.mid);
        this.takeEffect(animate);
    }

    public void setToggleMid() {
        this.setToggleMid(true);
    }

    public void setToggleStatus(ToggleStatus toggleStatus, boolean animate) {
        this.putValueInToggleStatus(toggleStatus);
        this.takeEffect(animate);
    }

    public void setToggleStatus(ToggleStatus toggleStatus) {
        this.setToggleStatus(toggleStatus, true);
    }

    public void setToggleStatus(boolean toggleStatus) {
        this.setToggleStatus(toggleStatus, true);
    }

    public void setToggleStatus(boolean toggleStatus, boolean animate) {
        if (toggleStatus) {
            this.putValueInToggleStatus(ToggleStatus.on);
        } else {
            this.putValueInToggleStatus(ToggleStatus.off);
        }
        this.takeEffect(animate);
    }

    public void setToggleStatus(int toggleIntValue) {
        this.setToggleStatus(toggleIntValue, true);
    }

    public void setToggleStatus(int toggleIntValue, boolean animate) {
        this.setToggleStatus(TriStateToggleButton.intToToggleStatus(toggleIntValue), animate);
    }

    public void increaseValue(boolean animate) {
        switch (this.toggleStatus) {
            case off: {
                if (this.midSelectable) {
                    this.putValueInToggleStatus(ToggleStatus.mid);
                    break;
                }
                this.putValueInToggleStatus(ToggleStatus.on);
                break;
            }
            case mid: {
                this.putValueInToggleStatus(ToggleStatus.on);
                break;
            }
        }
        this.takeEffect(animate);
        if (this.listener != null) {
            this.listener.onToggle(this.toggleStatus, TriStateToggleButton.toggleStatusToBoolean(this.toggleStatus), TriStateToggleButton.toggleStatusToInt(this.toggleStatus));
        }
    }

    public void increaseValue() {
        this.increaseValue(true);
    }

    public void decreaseValue(boolean animate) {
        switch (this.toggleStatus) {
            case on: {
                if (this.midSelectable) {
                    this.putValueInToggleStatus(ToggleStatus.mid);
                    break;
                }
                this.putValueInToggleStatus(ToggleStatus.off);
                break;
            }
            case mid: {
                this.putValueInToggleStatus(ToggleStatus.off);
                break;
            }
        }
        this.takeEffect(animate);
        if (this.listener != null) {
            this.listener.onToggle(this.toggleStatus, TriStateToggleButton.toggleStatusToBoolean(this.toggleStatus), TriStateToggleButton.toggleStatusToInt(this.toggleStatus));
        }
    }

    public void decreaseValue() {
        this.decreaseValue(true);
    }

    private void takeEffect(boolean animate) {
        if (animate) {
            this.spring.setEndValue(this.toggleStatus == ToggleStatus.on ? 1.0 : (this.toggleStatus == ToggleStatus.off ? 0.0 : 0.5));
        } else {
            this.spring.setCurrentValue(this.toggleStatus == ToggleStatus.on ? 1.0 : (this.toggleStatus == ToggleStatus.off ? 0.0 : 0.5));
            if (this.toggleStatus == ToggleStatus.on) {
                this.calculateEffect(1.0);
            } else if (this.toggleStatus == ToggleStatus.mid) {
                this.calculateEffect(0.5);
            } else {
                this.calculateEffect(0.0);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Resources r = Resources.getSystem();
        if (widthMode == 0 || widthMode == Integer.MIN_VALUE) {
            widthSize = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)r.getDisplayMetrics());
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
        }
        if (heightMode == 0 || heightSize == Integer.MIN_VALUE) {
            heightSize = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)r.getDisplayMetrics());
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = this.getWidth();
        int height = this.getHeight();
        this.centerY = this.radius = (float)Math.min(width, height) * 0.5f;
        this.startX = this.radius;
        this.endX = (float)width - this.radius;
        this.spotMinX = this.startX + (float)this.borderWidth;
        this.spotMaxX = this.endX - (float)this.borderWidth;
        this.spotMidX = (this.startX + this.endX) / 2.0f;
        this.spotSize = height - 4 * this.borderWidth;
        this.spotX = this.toggleStatus == ToggleStatus.on ? this.spotMaxX : (this.toggleStatus == ToggleStatus.off ? this.spotMinX : this.spotMidX);
        this.offLineWidth = 0.0f;
    }

    private int clamp(int value, int low, int high) {
        return Math.min(Math.max(value, low), high);
    }

    public void draw(Canvas canvas) {
        this.rect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.paint.setColor(this.borderColor);
        canvas.drawRoundRect(this.rect, this.radius, this.radius, this.paint);
        if (this.offLineWidth > 0.0f) {
            float cy = this.offLineWidth * 0.5f;
            this.rect.set(this.spotX - cy, this.centerY - cy, this.endX + cy, this.centerY + cy);
            this.paint.setColor(this.enabled ? (this.toggleStatus == ToggleStatus.mid ? this.midColor : this.offColor) : this.disabledColor);
            canvas.drawRoundRect(this.rect, cy, cy, this.paint);
        }
        this.rect.set(this.spotX - 1.0f - this.radius, this.centerY - this.radius, this.spotX + 1.1f + this.radius, this.centerY + this.radius);
        this.paint.setColor(this.enabled ? this.borderColor : this.disabledColor);
        canvas.drawRoundRect(this.rect, this.radius, this.radius, this.paint);
        float spotR = (float)this.spotSize * 0.5f;
        this.rect.set(this.spotX - spotR, this.centerY - spotR, this.spotX + spotR, this.centerY + spotR);
        this.paint.setColor(this.enabled ? this.spotColor : this.disabledColor);
        canvas.drawRoundRect(this.rect, spotR, spotR, this.paint);
    }

    private void calculateEffect(double value) {
        int fromColor;
        int toColor;
        float mapToggleX;
        this.spotX = mapToggleX = (float)SpringUtil.mapValueFromRangeToRange(value, 0.0, 1.0, this.spotMinX, this.spotMaxX);
        double min = 0.0;
        double max = 0.0;
        if (this.previousToggleStatus == ToggleStatus.off && this.toggleStatus == ToggleStatus.mid) {
            toColor = this.offBorderColor;
            fromColor = this.midColor;
        } else if (this.previousToggleStatus == ToggleStatus.off && this.toggleStatus == ToggleStatus.on) {
            toColor = this.offBorderColor;
            fromColor = this.onColor;
        } else if (this.previousToggleStatus == ToggleStatus.mid && this.toggleStatus == ToggleStatus.on) {
            toColor = this.midColor;
            fromColor = this.onColor;
        } else if (this.previousToggleStatus == ToggleStatus.on && this.toggleStatus == ToggleStatus.off) {
            toColor = this.offBorderColor;
            fromColor = this.onColor;
        } else if (this.previousToggleStatus == ToggleStatus.on && this.toggleStatus == ToggleStatus.mid) {
            toColor = this.midColor;
            fromColor = this.onColor;
        } else {
            toColor = this.offBorderColor;
            fromColor = this.onColor;
        }
        min = this.previousToggleStatus == ToggleStatus.off ? 0.0 : (this.previousToggleStatus == ToggleStatus.mid ? 0.5 : 1.0);
        max = this.toggleStatus == ToggleStatus.off ? 0.0 : (this.toggleStatus == ToggleStatus.mid ? 0.5 : 1.0);
        if (min == max) {
            min = 0.0;
            max = 1.0;
        } else if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        this.offLineWidth = (float)SpringUtil.mapValueFromRangeToRange(min + max - value, min, max, 0.0, this.spotSize);
        int fromB = Color.blue((int)fromColor);
        int fromR = Color.red((int)fromColor);
        int fromG = Color.green((int)fromColor);
        int toB = Color.blue((int)toColor);
        int toR = Color.red((int)toColor);
        int toG = Color.green((int)toColor);
        int springB = (int)SpringUtil.mapValueFromRangeToRange(min + max - value, min, max, fromB, toB);
        int springR = (int)SpringUtil.mapValueFromRangeToRange(min + max - value, min, max, fromR, toR);
        int springG = (int)SpringUtil.mapValueFromRangeToRange(min + max - value, min, max, fromG, toG);
        springB = this.clamp(springB, 0, 255);
        springR = this.clamp(springR, 0, 255);
        springG = this.clamp(springG, 0, 255);
        this.borderColor = Color.rgb((int)springR, (int)springG, (int)springB);
        this.postInvalidate();
    }

    public void setOnToggleChanged(OnToggleChanged onToggleChanged) {
        this.listener = onToggleChanged;
    }

    public boolean isAnimate() {
        return this.defaultAnimate;
    }

    public void setAnimate(boolean animate) {
        this.defaultAnimate = animate;
    }

    public int getOnColor() {
        return this.onColor;
    }

    public void setOnColor(int onColor) {
        this.onColor = onColor;
        this.postInvalidate();
    }

    public int getOffBorderColor() {
        return this.offBorderColor;
    }

    public void setOffBorderColor(int offBorderColor) {
        this.offBorderColor = offBorderColor;
        this.postInvalidate();
    }

    public int getOffColor() {
        return this.offColor;
    }

    public void setOffColor(int offColor) {
        this.offColor = offColor;
        this.postInvalidate();
    }

    public int getMidColor() {
        return this.midColor;
    }

    public void setMidColor(int midColor) {
        this.midColor = midColor;
        this.postInvalidate();
    }

    public int getSpotColor() {
        return this.spotColor;
    }

    public void setSpotColor(int spotColor) {
        this.spotColor = spotColor;
        this.postInvalidate();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.postInvalidate();
    }

    public ToggleStatus getToggleStatus() {
        return this.toggleStatus;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.postInvalidate();
    }

    public int getSpotSize() {
        return this.spotSize;
    }

    public void setSpotSize(int spotSize) {
        this.spotSize = spotSize;
        this.postInvalidate();
    }

    public boolean isMidSelectable() {
        return this.midSelectable;
    }

    public void setMidSelectable(boolean midSelectable) {
        this.midSelectable = midSelectable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.postInvalidate();
        super.setEnabled(enabled);
    }

    public static interface OnToggleChanged {
        public void onToggle(ToggleStatus var1, boolean var2, int var3);
    }

    public static enum ToggleStatus {
        on,
        mid,
        off;

    }
}

