/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import net.badata.protobuf.converter.annotation.ProtoClass;
import net.badata.protobuf.converter.annotation.ProtoClasses;
import net.badata.protobuf.converter.resolver.FieldResolver;
import net.badata.protobuf.converter.type.TypeConverter;
import net.badata.protobuf.converter.utils.StringUtils;

public final class FieldUtils {
    private static final String HASSER_PREFIX = "has";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String PROTOBUF_LIST_GETTER_POSTFIX = "List";
    private static final String PROTOBUF_LIST_SETTER_PREFIX = "addAll";

    public static boolean isComplexType(Field field) {
        return FieldUtils.isComplexType(field.getType());
    }

    public static boolean isComplexType(Class<?> type) {
        return type.isAnnotationPresent(ProtoClass.class) || type.isAnnotationPresent(ProtoClasses.class);
    }

    public static boolean isCollectionType(Field field) {
        return FieldUtils.isCollectionType(field.getType());
    }

    public static boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static String createProtobufHasserName(FieldResolver fieldResolver) {
        if (FieldUtils.isCollectionType(fieldResolver.getProtobufType())) {
            return null;
        }
        return StringUtils.createMethodName(HASSER_PREFIX, fieldResolver.getProtobufName());
    }

    public static String createProtobufGetterName(FieldResolver fieldResolver) {
        String getterName = StringUtils.createMethodName(GETTER_PREFIX, fieldResolver.getProtobufName());
        if (FieldUtils.isCollectionType(fieldResolver.getProtobufType())) {
            return getterName + PROTOBUF_LIST_GETTER_POSTFIX;
        }
        return getterName;
    }

    public static String createProtobufSetterName(FieldResolver fieldResolver) {
        if (FieldUtils.isCollectionType(fieldResolver.getProtobufType())) {
            return StringUtils.createMethodName(PROTOBUF_LIST_SETTER_PREFIX, fieldResolver.getProtobufName());
        }
        return StringUtils.createMethodName(SETTER_PREFIX, fieldResolver.getProtobufName());
    }

    public static String createDomainGetterName(FieldResolver fieldResolver) {
        if (fieldResolver.getDomainType() == Boolean.TYPE) {
            return StringUtils.createMethodName(BOOLEAN_GETTER_PREFIX, fieldResolver.getDomainName());
        }
        return StringUtils.createMethodName(GETTER_PREFIX, fieldResolver.getDomainName());
    }

    public static String createDomainSetterName(FieldResolver fieldResolver) {
        return StringUtils.createMethodName(SETTER_PREFIX, fieldResolver.getDomainName());
    }

    public static Class<?> extractCollectionType(Field field) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        return (Class)genericType.getActualTypeArguments()[0];
    }

    public static Class<?> extractProtobufFieldType(Class<? extends TypeConverter> typeConverterClass, Class<?> defaultType) {
        Type[] interfaceTypes;
        for (Type interfaceType : interfaceTypes = typeConverterClass.getGenericInterfaces()) {
            ParameterizedType parameterizedType = (ParameterizedType)interfaceType;
            if (!parameterizedType.getRawType().equals(TypeConverter.class)) continue;
            Type extractedType = parameterizedType.getActualTypeArguments()[1];
            if (extractedType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)extractedType).getRawType();
            }
            return Object.class.equals((Object)extractedType) ? defaultType : (Class)extractedType;
        }
        return defaultType;
    }

    private FieldUtils() {
    }
}

