/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.badata.protobuf.converter.annotation.ProtoField;
import net.badata.protobuf.converter.utils.FieldUtils;

public class FieldsIgnore {
    private final Map<Class<?>, Set<String>> ignoreMapping = new HashMap();

    public FieldsIgnore add(Class<?> ignoredClass) {
        this.ignoreMapping.put(ignoredClass, Collections.emptySet());
        return this;
    }

    public FieldsIgnore add(Class<?> ignoredClass, String ... fields) {
        if (fields != null) {
            Set<String> ignoredFields = this.ignoreMapping.get(ignoredClass);
            if (ignoredFields == null || ignoredFields.isEmpty()) {
                ignoredFields = new HashSet<String>();
                this.ignoreMapping.put(ignoredClass, ignoredFields);
            }
            ignoredFields.addAll(Arrays.asList(fields));
        }
        return this;
    }

    public FieldsIgnore addAll(FieldsIgnore ignoredFields) {
        this.ignoreMapping.putAll(ignoredFields.ignoreMapping);
        return this;
    }

    public FieldsIgnore remove(Class<?> ignoredClass, String ... fields) {
        Set<String> ignoredFields;
        if (fields != null && (ignoredFields = this.ignoreMapping.get(ignoredClass)) != null && !ignoredFields.isEmpty()) {
            ignoredFields.removeAll(Arrays.asList(fields));
            if (ignoredFields.isEmpty()) {
                this.ignoreMapping.remove(ignoredClass);
            }
        }
        return this;
    }

    public FieldsIgnore remove(Class<?> ignoredClass) {
        this.ignoreMapping.remove(ignoredClass);
        return this;
    }

    public void clear() {
        this.ignoreMapping.clear();
    }

    protected boolean ignored(Field field) {
        return !field.isAnnotationPresent(ProtoField.class) || this.isClassIgnored(field) || this.isFieldIgnored(field);
    }

    private boolean isClassIgnored(Field field) {
        Class<?> verifiedClass = FieldUtils.isCollectionType(field) ? FieldUtils.extractCollectionType(field) : field.getType();
        Set<String> ignoredFields = this.ignoreMapping.get(verifiedClass);
        return ignoredFields != null && ignoredFields.isEmpty();
    }

    private boolean isFieldIgnored(Field field) {
        Set<String> ignoredFields = this.ignoreMapping.get(field.getDeclaringClass());
        if (ignoredFields != null) {
            ProtoField annotation = field.getAnnotation(ProtoField.class);
            return ignoredFields.isEmpty() || ignoredFields.contains(field.getName()) || ignoredFields.contains(annotation.name());
        }
        return false;
    }

    public FieldsIgnore copy() {
        FieldsIgnore copy = new FieldsIgnore();
        copy.ignoreMapping.putAll(this.ignoreMapping);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldsIgnore that = (FieldsIgnore)obj;
        return this.ignoreMapping.equals(that.ignoreMapping);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * this.ignoreMapping.hashCode() + result;
        return result;
    }
}

