/*
 * Decompiled with CFR 0.152.
 */
package com.aspsine.swipetoloadlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Scroller;
import com.aspsine.swipetoloadlayout.OnLoadMoreListener;
import com.aspsine.swipetoloadlayout.OnRefreshListener;
import com.aspsine.swipetoloadlayout.R;
import com.aspsine.swipetoloadlayout.SwipeLoadMoreTrigger;
import com.aspsine.swipetoloadlayout.SwipeRefreshTrigger;
import com.aspsine.swipetoloadlayout.SwipeTrigger;

public class SwipeToLoadLayout
extends ViewGroup {
    private static final String TAG = SwipeToLoadLayout.class.getSimpleName();
    private static final int DEFAULT_RELEASE_TO_REFRESHING_SCROLLING_DURATION = 200;
    private static final int DEFAULT_REFRESH_COMPLETE_DELAY_DURATION = 300;
    private static final int DEFAULT_REFRESH_COMPLETE_TO_DEFAULT_SCROLLING_DURATION = 500;
    private static final int DEFAULT_DEFAULT_TO_REFRESHING_SCROLLING_DURATION = 500;
    private static final int DEFAULT_RELEASE_TO_LOADING_MORE_SCROLLING_DURATION = 200;
    private static final int DEFAULT_LOAD_MORE_COMPLETE_DELAY_DURATION = 300;
    private static final int DEFAULT_LOAD_MORE_COMPLETE_TO_DEFAULT_SCROLLING_DURATION = 300;
    private static final int DEFAULT_DEFAULT_TO_LOADING_MORE_SCROLLING_DURATION = 300;
    private static final float DEFAULT_DRAG_RATIO = 0.5f;
    private static final int INVALID_POINTER = -1;
    private static final int INVALID_COORDINATE = -1;
    private AutoScroller mAutoScroller;
    private OnRefreshListener mRefreshListener;
    private OnLoadMoreListener mLoadMoreListener;
    private View mHeaderView;
    private View mTargetView;
    private View mFooterView;
    private int mHeaderHeight;
    private int mFooterHeight;
    private boolean mHasHeaderView;
    private boolean mHasFooterView;
    private final int mTouchSlop;
    private byte mStatus = 0;
    private int mHeaderOffset;
    private int mTargetOffset;
    private int mFooterOffset;
    private float mInitDownY;
    private float mInitDownX;
    private float mLastY;
    private float mLastX;
    private int mActivePointerId;
    private boolean mLoading;
    private boolean mRefreshEnabled = true;
    private boolean mLoadMoreEnabled = true;
    private int mStyle = 0;
    private float mRefreshTriggerOffset;
    private float mLoadMoreTriggerOffset;
    private float mRefreshFinalDragOffset;
    private float mLoadMoreFinalDragOffset;
    private int mReleaseToRefreshingScrollingDuration = 200;
    private int mRefreshCompleteDelayDuration = 300;
    private int mRefreshCompleteToDefaultScrollingDuration = 500;
    private int mDefaultToRefreshingScrollingDuration = 500;
    private int mReleaseToLoadingMoreScrollingDuration = 200;
    private int mLoadMoreCompleteDelayDuration = 300;
    private int mLoadMoreCompleteToDefaultScrollingDuration = 300;
    private int mDefaultToLoadingMoreScrollingDuration = 300;
    RefreshCallback mRefreshCallback = new RefreshCallback(){

        @Override
        public void onPrepare() {
            if (SwipeToLoadLayout.this.mHeaderView != null && SwipeToLoadLayout.this.mHeaderView instanceof SwipeTrigger && STATUS.isStatusDefault(SwipeToLoadLayout.this.mStatus)) {
                SwipeToLoadLayout.this.mHeaderView.setVisibility(0);
                ((SwipeTrigger)SwipeToLoadLayout.this.mHeaderView).onPrepare();
            }
        }

        @Override
        public void onSwipe(int y, boolean isComplete) {
            if (SwipeToLoadLayout.this.mHeaderView != null && SwipeToLoadLayout.this.mHeaderView instanceof SwipeTrigger && STATUS.isRefreshStatus(SwipeToLoadLayout.this.mStatus)) {
                if (SwipeToLoadLayout.this.mHeaderView.getVisibility() != 0) {
                    SwipeToLoadLayout.this.mHeaderView.setVisibility(0);
                }
                ((SwipeTrigger)SwipeToLoadLayout.this.mHeaderView).onSwipe(y, isComplete);
            }
        }

        @Override
        public void onRelease() {
            if (SwipeToLoadLayout.this.mHeaderView != null && SwipeToLoadLayout.this.mHeaderView instanceof SwipeTrigger && STATUS.isReleaseToRefresh(SwipeToLoadLayout.this.mStatus)) {
                ((SwipeTrigger)SwipeToLoadLayout.this.mHeaderView).onRelease();
            }
        }

        @Override
        public void onRefresh() {
            if (SwipeToLoadLayout.this.mHeaderView != null && STATUS.isRefreshing(SwipeToLoadLayout.this.mStatus) && SwipeToLoadLayout.this.mLoading) {
                if (SwipeToLoadLayout.this.mHeaderView instanceof SwipeRefreshTrigger) {
                    ((SwipeRefreshTrigger)SwipeToLoadLayout.this.mHeaderView).onRefresh();
                }
                if (SwipeToLoadLayout.this.mRefreshListener != null) {
                    SwipeToLoadLayout.this.mRefreshListener.onRefresh();
                }
            }
        }

        @Override
        public void complete() {
            if (SwipeToLoadLayout.this.mHeaderView != null && SwipeToLoadLayout.this.mHeaderView instanceof SwipeTrigger) {
                ((SwipeTrigger)SwipeToLoadLayout.this.mHeaderView).complete();
            }
        }

        @Override
        public void onReset() {
            if (SwipeToLoadLayout.this.mHeaderView != null && SwipeToLoadLayout.this.mHeaderView instanceof SwipeTrigger && STATUS.isStatusDefault(SwipeToLoadLayout.this.mStatus)) {
                ((SwipeTrigger)SwipeToLoadLayout.this.mHeaderView).onReset();
                SwipeToLoadLayout.this.mHeaderView.setVisibility(8);
            }
        }
    };
    LoadMoreCallback mLoadMoreCallback = new LoadMoreCallback(){

        @Override
        public void onPrepare() {
            if (SwipeToLoadLayout.this.mFooterView != null && SwipeToLoadLayout.this.mFooterView instanceof SwipeTrigger && STATUS.isStatusDefault(SwipeToLoadLayout.this.mStatus)) {
                SwipeToLoadLayout.this.mFooterView.setVisibility(0);
                ((SwipeTrigger)SwipeToLoadLayout.this.mFooterView).onPrepare();
            }
        }

        @Override
        public void onSwipe(int y, boolean isComplete) {
            if (SwipeToLoadLayout.this.mFooterView != null && SwipeToLoadLayout.this.mFooterView instanceof SwipeTrigger && STATUS.isLoadMoreStatus(SwipeToLoadLayout.this.mStatus)) {
                if (SwipeToLoadLayout.this.mFooterView.getVisibility() != 0) {
                    SwipeToLoadLayout.this.mFooterView.setVisibility(0);
                }
                ((SwipeTrigger)SwipeToLoadLayout.this.mFooterView).onSwipe(y, isComplete);
            }
        }

        @Override
        public void onRelease() {
            if (SwipeToLoadLayout.this.mFooterView != null && SwipeToLoadLayout.this.mFooterView instanceof SwipeTrigger && STATUS.isReleaseToLoadMore(SwipeToLoadLayout.this.mStatus)) {
                ((SwipeTrigger)SwipeToLoadLayout.this.mFooterView).onRelease();
            }
        }

        @Override
        public void onLoadMore() {
            if (SwipeToLoadLayout.this.mFooterView != null && STATUS.isLoadingMore(SwipeToLoadLayout.this.mStatus) && SwipeToLoadLayout.this.mLoading) {
                if (SwipeToLoadLayout.this.mFooterView instanceof SwipeLoadMoreTrigger) {
                    ((SwipeLoadMoreTrigger)SwipeToLoadLayout.this.mFooterView).onLoadMore();
                }
                if (SwipeToLoadLayout.this.mLoadMoreListener != null) {
                    SwipeToLoadLayout.this.mLoadMoreListener.onLoadMore();
                }
            }
        }

        @Override
        public void complete() {
            if (SwipeToLoadLayout.this.mFooterView != null && SwipeToLoadLayout.this.mFooterView instanceof SwipeTrigger) {
                ((SwipeTrigger)SwipeToLoadLayout.this.mFooterView).complete();
            }
        }

        @Override
        public void onReset() {
            if (SwipeToLoadLayout.this.mFooterView != null && SwipeToLoadLayout.this.mFooterView instanceof SwipeTrigger && STATUS.isStatusDefault(SwipeToLoadLayout.this.mStatus)) {
                ((SwipeTrigger)SwipeToLoadLayout.this.mFooterView).onReset();
                SwipeToLoadLayout.this.mFooterView.setVisibility(8);
            }
        }
    };

    public SwipeToLoadLayout(Context context) {
        this(context, null);
    }

    public SwipeToLoadLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwipeToLoadLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeToLoadLayout, defStyleAttr, 0);
        try {
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.SwipeToLoadLayout_refresh_enabled) {
                    this.setRefreshEnabled(a.getBoolean(attr, true));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_load_more_enabled) {
                    this.setLoadMoreEnabled(a.getBoolean(attr, true));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_swipe_style) {
                    this.setSwipeStyle(a.getInt(attr, 0));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_refresh_final_drag_offset) {
                    this.setRefreshFinalDragOffset(a.getDimensionPixelOffset(attr, 0));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_load_more_final_drag_offset) {
                    this.setLoadMoreFinalDragOffset(a.getDimensionPixelOffset(attr, 0));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_refresh_trigger_offset) {
                    this.setRefreshTriggerOffset(a.getDimensionPixelOffset(attr, 0));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_load_more_trigger_offset) {
                    this.setLoadMoreTriggerOffset(a.getDimensionPixelOffset(attr, 0));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_release_to_refreshing_scrolling_duration) {
                    this.setReleaseToRefreshingScrollingDuration(a.getInt(attr, 200));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_refresh_complete_delay_duration) {
                    this.setRefreshCompleteDelayDuration(a.getInt(attr, 300));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_refresh_complete_to_default_scrolling_duration) {
                    this.setRefreshCompleteToDefaultScrollingDuration(a.getInt(attr, 500));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_default_to_refreshing_scrolling_duration) {
                    this.setDefaultToRefreshingScrollingDuration(a.getInt(attr, 500));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_release_to_loading_more_scrolling_duration) {
                    this.setReleaseToLoadingMoreScrollingDuration(a.getInt(attr, 200));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_load_more_complete_delay_duration) {
                    this.setLoadMoreCompleteDelayDuration(a.getInt(attr, 300));
                    continue;
                }
                if (attr == R.styleable.SwipeToLoadLayout_load_more_complete_to_default_scrolling_duration) {
                    this.setLoadMoreCompleteToDefaultScrollingDuration(a.getInt(attr, 300));
                    continue;
                }
                if (attr != R.styleable.SwipeToLoadLayout_default_to_loading_more_scrolling_duration) continue;
                this.setDefaultToLoadingMoreScrollingDuration(a.getInt(attr, 300));
            }
        }
        finally {
            a.recycle();
        }
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mAutoScroller = new AutoScroller();
    }

    public boolean isRefreshEnabled() {
        return this.mRefreshEnabled;
    }

    public boolean isLoadMoreEnabled() {
        return this.mLoadMoreEnabled;
    }

    public boolean isRefreshing() {
        return STATUS.isRefreshing(this.mStatus) && this.mLoading;
    }

    public boolean isLoadingMore() {
        return STATUS.isLoadingMore(this.mStatus) && this.mLoading;
    }

    public void setRefreshHeaderView(View view) {
        if (view instanceof SwipeRefreshTrigger) {
            if (this.mHeaderView != null && this.mHeaderView != view) {
                this.removeView(this.mHeaderView);
            }
            if (this.mHeaderView != view) {
                this.mHeaderView = view;
                this.addView(view);
            }
        } else {
            Log.e((String)TAG, (String)"Refresh header view must be an implement of SwipeRefreshTrigger");
        }
    }

    public void setLoadMoreFooterView(View view) {
        if (view instanceof SwipeLoadMoreTrigger) {
            if (this.mFooterView != null && this.mFooterView != view) {
                this.removeView(this.mFooterView);
            }
            if (this.mFooterView != view) {
                this.mFooterView = view;
                this.addView(this.mFooterView);
            }
        } else {
            Log.e((String)TAG, (String)"Load more footer view must be an implement of SwipeLoadTrigger");
        }
    }

    public void setRefreshEnabled(boolean enable) {
        this.mRefreshEnabled = enable;
    }

    public void setLoadMoreEnabled(boolean enable) {
        this.mLoadMoreEnabled = enable;
    }

    public void setSwipeStyle(int style) {
        this.mStyle = style;
        this.requestLayout();
    }

    public void setRefreshTriggerOffset(int offset) {
        this.mRefreshTriggerOffset = offset;
    }

    public void setLoadMoreTriggerOffset(int offset) {
        this.mLoadMoreTriggerOffset = offset;
    }

    public void setRefreshFinalDragOffset(int offset) {
        this.mRefreshFinalDragOffset = offset;
    }

    public void setLoadMoreFinalDragOffset(int offset) {
        this.mLoadMoreFinalDragOffset = offset;
    }

    public void setReleaseToRefreshingScrollingDuration(int duration) {
        this.mReleaseToRefreshingScrollingDuration = duration;
    }

    public void setRefreshCompleteDelayDuration(int duration) {
        this.mRefreshCompleteDelayDuration = duration;
    }

    public void setRefreshCompleteToDefaultScrollingDuration(int duration) {
        this.mRefreshCompleteToDefaultScrollingDuration = duration;
    }

    public void setDefaultToRefreshingScrollingDuration(int duration) {
        this.mDefaultToRefreshingScrollingDuration = duration;
    }

    public void setReleaseToLoadingMoreScrollingDuration(int duration) {
        this.mReleaseToLoadingMoreScrollingDuration = duration;
    }

    public void setLoadMoreCompleteDelayDuration(int duration) {
        this.mLoadMoreCompleteDelayDuration = duration;
    }

    public void setLoadMoreCompleteToDefaultScrollingDuration(int duration) {
        this.mLoadMoreCompleteToDefaultScrollingDuration = duration;
    }

    public void setDefaultToLoadingMoreScrollingDuration(int duration) {
        this.mDefaultToLoadingMoreScrollingDuration = duration;
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mRefreshListener = listener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    public void setRefreshing(boolean refreshing) {
        if (!this.isRefreshEnabled() || this.mHeaderView == null) {
            return;
        }
        this.mLoading = refreshing;
        if (refreshing) {
            if (STATUS.isLoadingMore(this.mStatus)) {
                return;
            }
            this.setStatus((byte)-3);
            int duration = (float)this.mHeaderOffset > this.mRefreshTriggerOffset ? this.mReleaseToRefreshingScrollingDuration : this.mDefaultToRefreshingScrollingDuration;
            this.mAutoScroller.autoScroll(this.mHeaderHeight - this.mHeaderOffset, duration);
        } else if (STATUS.isRefreshing(this.mStatus)) {
            this.setStatus((byte)-4);
            this.mRefreshCallback.complete();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SwipeToLoadLayout.this.mAutoScroller.autoScroll(-SwipeToLoadLayout.this.mHeaderOffset, SwipeToLoadLayout.this.mRefreshCompleteToDefaultScrollingDuration);
                }
            }, this.mRefreshCompleteDelayDuration);
        } else if (STATUS.isSwipingToRefresh(this.mStatus)) {
            this.mAutoScroller.autoScroll(-this.mHeaderOffset, this.mRefreshCompleteToDefaultScrollingDuration);
        }
    }

    public void setLoadingMore(boolean loadingMore) {
        if (!this.isLoadMoreEnabled() || this.mFooterView == null) {
            return;
        }
        this.mLoading = loadingMore;
        if (loadingMore) {
            if (STATUS.isRefreshing(this.mStatus)) {
                return;
            }
            this.setStatus((byte)3);
            int duration = (float)(-this.mFooterOffset) > this.mLoadMoreTriggerOffset ? this.mReleaseToLoadingMoreScrollingDuration : this.mDefaultToLoadingMoreScrollingDuration;
            this.mAutoScroller.autoScroll(-this.mFooterOffset - this.mFooterHeight, duration);
        } else if (STATUS.isLoadingMore(this.mStatus)) {
            this.setStatus((byte)4);
            this.mLoadMoreCallback.complete();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SwipeToLoadLayout.this.mAutoScroller.autoScroll(-SwipeToLoadLayout.this.mFooterOffset, SwipeToLoadLayout.this.mLoadMoreCompleteToDefaultScrollingDuration);
                }
            }, this.mLoadMoreCompleteDelayDuration);
        } else if (STATUS.isSwipingToLoadMore(this.mStatus)) {
            this.mAutoScroller.autoScroll(-this.mFooterOffset, this.mLoadMoreCompleteToDefaultScrollingDuration);
        }
    }

    private void autoScrollFinished(boolean autoScrollAbort) {
        if (this.mLoading) {
            if (STATUS.isRefreshing(this.mStatus) && !autoScrollAbort) {
                this.mRefreshCallback.onRefresh();
            } else if (STATUS.isLoadingMore(this.mStatus) && !autoScrollAbort) {
                this.mLoadMoreCallback.onLoadMore();
            }
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childNum = this.getChildCount();
        if (childNum == 0) {
            return;
        }
        if (0 >= childNum || childNum >= 4) {
            throw new IllegalStateException("Children num must equal or less than 3");
        }
        this.mHeaderView = this.findViewById(R.id.swipe_refresh_header);
        this.mTargetView = this.findViewById(R.id.swipe_target);
        this.mFooterView = this.findViewById(R.id.swipe_load_more_footer);
        if (this.mTargetView == null) {
            return;
        }
        if (this.mHeaderView != null && this.mHeaderView instanceof SwipeTrigger) {
            this.mHeaderView.setVisibility(8);
        }
        if (this.mFooterView != null && this.mFooterView instanceof SwipeTrigger) {
            this.mFooterView.setVisibility(8);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.MarginLayoutParams lp;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView != null) {
            View headerView = this.mHeaderView;
            this.measureChildWithMargins(headerView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (ViewGroup.MarginLayoutParams)headerView.getLayoutParams();
            this.mHeaderHeight = headerView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            if (this.mRefreshTriggerOffset < (float)this.mHeaderHeight) {
                this.mRefreshTriggerOffset = this.mHeaderHeight;
            }
        }
        if (this.mTargetView != null) {
            View targetView = this.mTargetView;
            this.measureChildWithMargins(targetView, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
        if (this.mFooterView != null) {
            View footerView = this.mFooterView;
            this.measureChildWithMargins(footerView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (ViewGroup.MarginLayoutParams)footerView.getLayoutParams();
            this.mFooterHeight = footerView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            if (this.mLoadMoreTriggerOffset < (float)this.mFooterHeight) {
                this.mLoadMoreTriggerOffset = this.mFooterHeight;
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutChildren();
        this.mHasHeaderView = this.mHeaderView != null;
        this.mHasFooterView = this.mFooterView != null;
    }

    private void layoutChildren() {
        ViewGroup.MarginLayoutParams lp;
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        if (this.mTargetView == null) {
            return;
        }
        if (this.mHeaderView != null) {
            int headerTop;
            View headerView = this.mHeaderView;
            lp = (ViewGroup.MarginLayoutParams)headerView.getLayoutParams();
            int headerLeft = paddingLeft + lp.leftMargin;
            switch (this.mStyle) {
                case 0: {
                    headerTop = paddingTop + lp.topMargin - this.mHeaderHeight + this.mHeaderOffset;
                    break;
                }
                case 1: {
                    headerTop = paddingTop + lp.topMargin - this.mHeaderHeight + this.mHeaderOffset;
                    break;
                }
                case 2: {
                    headerTop = paddingTop + lp.topMargin;
                    break;
                }
                case 3: {
                    headerTop = paddingTop + lp.topMargin - this.mHeaderHeight / 2 + this.mHeaderOffset / 2;
                    break;
                }
                default: {
                    headerTop = paddingTop + lp.topMargin - this.mHeaderHeight + this.mHeaderOffset;
                }
            }
            int headerRight = headerLeft + headerView.getMeasuredWidth();
            int headerBottom = headerTop + headerView.getMeasuredHeight();
            headerView.layout(headerLeft, headerTop, headerRight, headerBottom);
        }
        if (this.mTargetView != null) {
            int targetTop;
            View targetView = this.mTargetView;
            lp = (ViewGroup.MarginLayoutParams)targetView.getLayoutParams();
            int targetLeft = paddingLeft + lp.leftMargin;
            switch (this.mStyle) {
                case 0: {
                    targetTop = paddingTop + lp.topMargin + this.mTargetOffset;
                    break;
                }
                case 1: {
                    targetTop = paddingTop + lp.topMargin;
                    break;
                }
                case 2: {
                    targetTop = paddingTop + lp.topMargin + this.mTargetOffset;
                    break;
                }
                case 3: {
                    targetTop = paddingTop + lp.topMargin + this.mTargetOffset;
                    break;
                }
                default: {
                    targetTop = paddingTop + lp.topMargin + this.mTargetOffset;
                }
            }
            int targetRight = targetLeft + targetView.getMeasuredWidth();
            int targetBottom = targetTop + targetView.getMeasuredHeight();
            targetView.layout(targetLeft, targetTop, targetRight, targetBottom);
        }
        if (this.mFooterView != null) {
            int footerBottom;
            View footerView = this.mFooterView;
            lp = (ViewGroup.MarginLayoutParams)footerView.getLayoutParams();
            int footerLeft = paddingLeft + lp.leftMargin;
            switch (this.mStyle) {
                case 0: {
                    footerBottom = height - paddingBottom - lp.bottomMargin + this.mFooterHeight + this.mFooterOffset;
                    break;
                }
                case 1: {
                    footerBottom = height - paddingBottom - lp.bottomMargin + this.mFooterHeight + this.mFooterOffset;
                    break;
                }
                case 2: {
                    footerBottom = height - paddingBottom - lp.bottomMargin;
                    break;
                }
                case 3: {
                    footerBottom = height - paddingBottom - lp.bottomMargin + this.mFooterHeight / 2 + this.mFooterOffset / 2;
                    break;
                }
                default: {
                    footerBottom = height - paddingBottom - lp.bottomMargin + this.mFooterHeight + this.mFooterOffset;
                }
            }
            int footerTop = footerBottom - footerView.getMeasuredHeight();
            int footerRight = footerLeft + footerView.getMeasuredWidth();
            footerView.layout(footerLeft, footerTop, footerRight, footerBottom);
        }
        if (this.mStyle == 0 || this.mStyle == 1) {
            if (this.mHeaderView != null) {
                this.mHeaderView.bringToFront();
            }
            if (this.mFooterView != null) {
                this.mFooterView.bringToFront();
            }
        } else if ((this.mStyle == 2 || this.mStyle == 3) && this.mTargetView != null) {
            this.mTargetView.bringToFront();
        }
    }

    private boolean onCheckCanRefresh() {
        return this.mRefreshEnabled && !this.canChildScrollUp() && this.mHasHeaderView && this.mRefreshTriggerOffset > 0.0f;
    }

    private boolean onCheckCanLoadMore() {
        return this.mLoadMoreEnabled && !this.canChildScrollDown() && this.mHasFooterView && this.mLoadMoreTriggerOffset > 0.0f;
    }

    protected boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTargetView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1) || this.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    protected boolean canChildScrollDown() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTargetView;
                return absListView.getChildCount() > 0 && (absListView.getLastVisiblePosition() < absListView.getChildCount() - 1 || absListView.getChildAt(absListView.getChildCount() - 1).getBottom() > absListView.getPaddingBottom());
            }
            return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1) || this.mTargetView.getScrollY() < 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 1: {
                this.onActivePointerUp();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        switch (action) {
            case 0: {
                if (!(STATUS.isRefreshComplete(this.mStatus) || STATUS.isLoadMoreComplete(this.mStatus) || STATUS.isRefreshing(this.mStatus) || STATUS.isLoadingMore(this.mStatus))) {
                    this.mAutoScroller.abortIfRunning();
                }
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                this.mInitDownY = this.getMotionEventY(event, this.mActivePointerId);
                this.mInitDownX = this.getMotionEventX(event, this.mActivePointerId);
                if (this.mInitDownY == -1.0f) {
                    return false;
                }
                this.mLastY = this.mInitDownY;
                this.mLastX = this.mInitDownX;
                break;
            }
            case 2: {
                boolean triggerCondition;
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float y = this.getMotionEventY(event, this.mActivePointerId);
                float x = this.getMotionEventX(event, this.mActivePointerId);
                float yInitDiff = y - this.mInitDownY;
                float xInitDiff = x - this.mInitDownX;
                this.mLastY = y;
                this.mLastX = x;
                boolean moved = Math.abs(yInitDiff) > Math.abs(xInitDiff);
                boolean bl = triggerCondition = yInitDiff > 0.0f && moved && this.onCheckCanRefresh() || yInitDiff < 0.0f && moved && this.onCheckCanLoadMore();
                if (!triggerCondition) break;
                return true;
            }
            case 6: {
                this.onSecondaryPointerUp(event);
                this.mLastY = this.getMotionEventY(event, this.mActivePointerId);
                this.mLastX = this.getMotionEventX(event, this.mActivePointerId);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                return true;
            }
            case 2: {
                float y = this.getMotionEventY(event, this.mActivePointerId);
                float x = this.getMotionEventX(event, this.mActivePointerId);
                float yDiff = y - this.mLastY;
                float xDiff = x - this.mLastX;
                this.mLastY = y;
                this.mLastX = x;
                if (Math.abs(xDiff) > Math.abs(yDiff) && Math.abs(xDiff) > (float)this.mTouchSlop) {
                    return false;
                }
                if (STATUS.isStatusDefault(this.mStatus)) {
                    if (yDiff > 0.0f && this.onCheckCanRefresh()) {
                        this.mRefreshCallback.onPrepare();
                        this.setStatus((byte)-1);
                    } else if (yDiff < 0.0f && this.onCheckCanLoadMore()) {
                        this.mLoadMoreCallback.onPrepare();
                        this.setStatus((byte)1);
                    }
                }
                if (STATUS.isSwipingToRefresh(this.mStatus) || STATUS.isSwipingToLoadMore(this.mStatus) || STATUS.isReleaseToRefresh(this.mStatus) || STATUS.isReleaseToLoadMore(this.mStatus)) {
                    this.fingerScroll(yDiff);
                }
                return true;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)pointerIndex);
                if (pointerId != -1) {
                    this.mActivePointerId = pointerId;
                }
                this.mLastY = this.getMotionEventY(event, this.mActivePointerId);
                this.mLastX = this.getMotionEventX(event, this.mActivePointerId);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(event);
                this.mLastY = this.getMotionEventY(event, this.mActivePointerId);
                this.mLastX = this.getMotionEventX(event, this.mActivePointerId);
                break;
            }
            case 1: 
            case 3: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                this.mActivePointerId = -1;
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private void fingerScroll(float yDiff) {
        float ratio = 0.5f;
        if (STATUS.isSwipingToRefresh(this.mStatus) || STATUS.isReleaseToRefresh(this.mStatus)) {
            if (yDiff > 0.0f) {
                ratio = 0.5f;
            } else if (yDiff < 0.0f) {
                ratio = 2.0f;
            }
        } else if (STATUS.isSwipingToLoadMore(this.mStatus) || STATUS.isReleaseToLoadMore(this.mStatus)) {
            if (yDiff > 0.0f) {
                ratio = 2.0f;
            } else if (yDiff < 0.0f) {
                ratio = 0.5f;
            }
        } else if (STATUS.isRefreshing(this.mStatus)) {
            ratio = yDiff < 0.0f && (float)this.mTargetOffset <= this.mRefreshTriggerOffset ? 0.0f : (yDiff > 0.0f ? 0.5f : 2.0f);
        } else if (STATUS.isLoadingMore(this.mStatus)) {
            ratio = yDiff > 0.0f && (float)(-this.mTargetOffset) <= this.mLoadMoreTriggerOffset ? 0.0f : (yDiff < 0.0f ? 0.5f : 2.0f);
        }
        float yScrolled = yDiff * ratio;
        float tmpTargetOffset = yScrolled + (float)this.mTargetOffset;
        if (tmpTargetOffset > 0.0f && this.mTargetOffset < 0 || yScrolled + (float)this.mTargetOffset < 0.0f && this.mTargetOffset > 0) {
            yScrolled = -this.mTargetOffset;
        }
        if (this.mRefreshFinalDragOffset >= this.mRefreshTriggerOffset && tmpTargetOffset > this.mRefreshFinalDragOffset) {
            yScrolled = this.mRefreshFinalDragOffset - (float)this.mTargetOffset;
        } else if (this.mLoadMoreFinalDragOffset >= this.mLoadMoreTriggerOffset && -tmpTargetOffset > this.mLoadMoreFinalDragOffset) {
            yScrolled = -this.mLoadMoreFinalDragOffset - (float)this.mTargetOffset;
        }
        this.updateScroll(yScrolled);
    }

    private void updateScroll(float yScrolled) {
        if (yScrolled == 0.0f) {
            return;
        }
        this.mTargetOffset = (int)((float)this.mTargetOffset + yScrolled);
        if (this.mTargetOffset > 0) {
            if (STATUS.isRefreshStatus(this.mStatus)) {
                this.mHeaderOffset = this.mTargetOffset;
                this.mFooterOffset = 0;
                if ((float)this.mTargetOffset < this.mRefreshTriggerOffset) {
                    if (STATUS.isReleaseToRefresh(this.mStatus)) {
                        this.setStatus((byte)-1);
                    }
                } else if ((float)this.mTargetOffset >= this.mRefreshTriggerOffset && !STATUS.isRefreshing(this.mStatus)) {
                    this.setStatus((byte)-2);
                }
            } else if (STATUS.isStatusDefault(this.mStatus)) {
                this.mHeaderOffset = this.mTargetOffset;
                this.mFooterOffset = 0;
            }
        } else if (this.mTargetOffset < 0) {
            if (STATUS.isLoadMoreStatus(this.mStatus)) {
                this.mFooterOffset = this.mTargetOffset;
                this.mHeaderOffset = 0;
                if ((float)(-this.mTargetOffset) < this.mLoadMoreTriggerOffset) {
                    if (STATUS.isReleaseToLoadMore(this.mStatus)) {
                        this.setStatus((byte)1);
                    }
                } else if ((float)(-this.mTargetOffset) >= this.mLoadMoreTriggerOffset && !STATUS.isLoadingMore(this.mStatus)) {
                    this.setStatus((byte)2);
                }
            } else if (STATUS.isStatusDefault(this.mStatus)) {
                this.mFooterOffset = this.mTargetOffset;
                this.mHeaderOffset = 0;
            }
        } else if (this.mTargetOffset == 0) {
            if (STATUS.isRefreshing(this.mStatus) && this.mLoading) {
                this.mHeaderOffset = this.mTargetOffset = 1;
                this.mFooterOffset = 0;
            } else if (STATUS.isLoadingMore(this.mStatus) && this.mLoading) {
                this.mFooterOffset = this.mTargetOffset = -1;
                this.mHeaderOffset = 0;
            } else {
                this.mLoading = false;
                this.mHeaderOffset = 0;
                this.mFooterOffset = 0;
                if (STATUS.isRefreshComplete(this.mStatus) || STATUS.isSwipingToRefresh(this.mStatus) || STATUS.isReleaseToRefresh(this.mStatus)) {
                    this.setStatus((byte)0);
                    this.mRefreshCallback.onReset();
                } else if (STATUS.isLoadMoreComplete(this.mStatus) || STATUS.isSwipingToLoadMore(this.mStatus) || STATUS.isReleaseToLoadMore(this.mStatus)) {
                    this.setStatus((byte)0);
                    this.mLoadMoreCallback.onReset();
                }
            }
        }
        if (this.mTargetOffset > 0) {
            this.mRefreshCallback.onSwipe(this.mTargetOffset, STATUS.isRefreshComplete(this.mStatus));
        } else if (this.mTargetOffset < 0) {
            this.mLoadMoreCallback.onSwipe(this.mTargetOffset, STATUS.isLoadMoreComplete(this.mStatus));
        }
        this.layoutChildren();
        this.invalidate();
    }

    private void onActivePointerUp() {
        if (STATUS.isSwipingToRefresh(this.mStatus)) {
            this.setRefreshing(false);
        } else if (STATUS.isSwipingToLoadMore(this.mStatus)) {
            this.setLoadingMore(false);
        } else if (STATUS.isReleaseToRefresh(this.mStatus)) {
            this.mRefreshCallback.onRelease();
            this.setRefreshing(true);
        } else if (STATUS.isReleaseToLoadMore(this.mStatus)) {
            this.mLoadMoreCallback.onRelease();
            this.setLoadingMore(true);
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private float getMotionEventY(MotionEvent event, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)event, (int)index);
    }

    private float getMotionEventX(MotionEvent event, int activePointId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)activePointId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getX((MotionEvent)event, (int)index);
    }

    private void setStatus(byte status) {
        this.mStatus = status;
        STATUS.printStatus(status);
    }

    private static final class STATUS {
        private static final byte STATUS_REFRESH_RETURNING = -5;
        private static final byte STATS_REFRESH_COMPLETE = -4;
        private static final byte STATUS_REFRESHING = -3;
        private static final byte STATUS_RELEASE_TO_REFRESH = -2;
        private static final byte STATUS_SWIPING_TO_REFRESH = -1;
        private static final byte STATUS_DEFAULT = 0;
        private static final byte STATUS_SWIPING_TO_LOAD_MORE = 1;
        private static final byte STATUS_RELEASE_TO_LOAD_MORE = 2;
        private static final byte STATUS_LOADING_MORE = 3;
        private static final byte STATUS_LOAD_MORE_COMPLETE = 4;
        private static final byte STATUS_LOAD_MORE_RETURNING = 5;

        private STATUS() {
        }

        private static boolean isRefreshing(byte status) {
            return status == -3;
        }

        private static boolean isLoadingMore(byte status) {
            return status == 3;
        }

        private static boolean isRefreshComplete(byte status) {
            return status == -4;
        }

        private static boolean isLoadMoreComplete(byte status) {
            return status == 4;
        }

        private static boolean isRefreshReturning(byte status) {
            return status == -5;
        }

        private static boolean isLoadMoreReturning(byte status) {
            return status == 5;
        }

        private static boolean isReleaseToRefresh(byte status) {
            return status == -2;
        }

        private static boolean isReleaseToLoadMore(byte status) {
            return status == 2;
        }

        private static boolean isSwipingToRefresh(byte status) {
            return status == -1;
        }

        private static boolean isSwipingToLoadMore(byte status) {
            return status == 1;
        }

        private static boolean isRefreshStatus(byte status) {
            return status < 0;
        }

        public static boolean isLoadMoreStatus(int status) {
            return status > 0;
        }

        private static boolean isStatusDefault(byte status) {
            return status == 0;
        }

        private static String getStatus(int status) {
            String statusInfo;
            switch (status) {
                case -5: {
                    statusInfo = "status_refresh_returning";
                    break;
                }
                case -4: {
                    statusInfo = "stats_refresh_complete";
                    break;
                }
                case -3: {
                    statusInfo = "status_refreshing";
                    break;
                }
                case -2: {
                    statusInfo = "status_release_to_refresh";
                    break;
                }
                case -1: {
                    statusInfo = "status_swiping_to_refresh";
                    break;
                }
                case 0: {
                    statusInfo = "status_default";
                    break;
                }
                case 1: {
                    statusInfo = "status_swiping_to_load_more";
                    break;
                }
                case 2: {
                    statusInfo = "status_release_to_load_more";
                    break;
                }
                case 3: {
                    statusInfo = "status_loading_more";
                    break;
                }
                case 4: {
                    statusInfo = "status_load_more_complete";
                    break;
                }
                case 5: {
                    statusInfo = "status_load_more_returning";
                    break;
                }
                default: {
                    statusInfo = "status_illegal!";
                }
            }
            return statusInfo;
        }

        private static void printStatus(int status) {
            Log.d((String)TAG, (String)("printStatus:" + STATUS.getStatus(status)));
        }
    }

    abstract class LoadMoreCallback
    implements SwipeTrigger,
    SwipeLoadMoreTrigger {
        LoadMoreCallback() {
        }
    }

    abstract class RefreshCallback
    implements SwipeTrigger,
    SwipeRefreshTrigger {
        RefreshCallback() {
        }
    }

    private class AutoScroller
    implements Runnable {
        private Scroller mScroller;
        private int mmLastY;
        private boolean mRunning = false;
        private boolean mAbort = false;

        public AutoScroller() {
            this.mScroller = new Scroller(SwipeToLoadLayout.this.getContext());
        }

        @Override
        public void run() {
            boolean finish = !this.mScroller.computeScrollOffset() || this.mScroller.isFinished();
            int currY = this.mScroller.getCurrY();
            int yDiff = currY - this.mmLastY;
            if (finish) {
                this.finish();
            } else {
                this.mmLastY = currY;
                SwipeToLoadLayout.this.updateScroll(yDiff);
                SwipeToLoadLayout.this.post(this);
            }
        }

        private void finish() {
            this.mmLastY = 0;
            this.mRunning = false;
            SwipeToLoadLayout.this.removeCallbacks(this);
            SwipeToLoadLayout.this.autoScrollFinished(this.mAbort);
        }

        public void abortIfRunning() {
            if (this.mRunning) {
                if (!this.mScroller.isFinished()) {
                    this.mAbort = true;
                    this.mScroller.forceFinished(true);
                }
                this.finish();
                this.mAbort = false;
            }
        }

        private void autoScroll(int yScrolled, int duration) {
            SwipeToLoadLayout.this.removeCallbacks(this);
            this.mmLastY = 0;
            if (!this.mScroller.isFinished()) {
                this.mScroller.forceFinished(true);
            }
            this.mScroller.startScroll(0, 0, 0, yScrolled, duration);
            SwipeToLoadLayout.this.post(this);
            this.mRunning = true;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static final class STYLE {
        public static final int CLASSIC = 0;
        public static final int ABOVE = 1;
        public static final int BLEW = 2;
        public static final int SCALE = 3;
    }
}

