/*
 * Decompiled with CFR 0.152.
 */
package com.aspsine.fragmentnavigator;

import android.os.Bundle;
import androidx.annotation.IdRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.aspsine.fragmentnavigator.FragmentNavigatorAdapter;

public class FragmentNavigator {
    private static final String EXTRA_CURRENT_POSITION = "extra_current_position";
    private FragmentManager mFragmentManager;
    private FragmentNavigatorAdapter mAdapter;
    @IdRes
    private int mContainerViewId;
    private int mCurrentPosition = -1;
    private int mDefaultPosition;

    public FragmentNavigator(FragmentManager fragmentManager, FragmentNavigatorAdapter adapter, @IdRes int containerViewId) {
        this.mFragmentManager = fragmentManager;
        this.mAdapter = adapter;
        this.mContainerViewId = containerViewId;
    }

    public void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mCurrentPosition = savedInstanceState.getInt(EXTRA_CURRENT_POSITION, this.mDefaultPosition);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(EXTRA_CURRENT_POSITION, this.mCurrentPosition);
    }

    public void showFragment(int position) {
        this.showFragment(position, false);
    }

    public void showFragment(int position, boolean reset) {
        this.showFragment(position, reset, false);
    }

    public void showFragment(int position, boolean reset, boolean allowingStateLoss) {
        this.mCurrentPosition = position;
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            if (position == i) {
                if (reset) {
                    this.remove(position, transaction);
                    this.add(position, transaction);
                    continue;
                }
                this.show(i, transaction);
                continue;
            }
            this.hide(i, transaction);
        }
        if (allowingStateLoss) {
            transaction.commitAllowingStateLoss();
        } else {
            transaction.commit();
        }
    }

    public void resetFragments() {
        this.resetFragments(this.mCurrentPosition);
    }

    public void resetFragments(int position) {
        this.resetFragments(position, false);
    }

    public void resetFragments(int position, boolean allowingStateLoss) {
        this.mCurrentPosition = position;
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        this.removeAll(transaction);
        this.add(position, transaction);
        if (allowingStateLoss) {
            transaction.commitAllowingStateLoss();
        } else {
            transaction.commit();
        }
    }

    public void removeAllFragment() {
        this.removeAllFragment(false);
    }

    public void removeAllFragment(boolean allowingStateLoss) {
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        this.removeAll(transaction);
        if (allowingStateLoss) {
            transaction.commitAllowingStateLoss();
        } else {
            transaction.commit();
        }
    }

    public int getCurrentPosition() {
        return this.mCurrentPosition;
    }

    public Fragment getCurrentFragment() {
        return this.getFragment(this.mCurrentPosition);
    }

    public Fragment getFragment(int position) {
        String tag = this.mAdapter.getTag(position);
        return this.mFragmentManager.findFragmentByTag(tag);
    }

    private void show(int position, FragmentTransaction transaction) {
        String tag = this.mAdapter.getTag(position);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(tag);
        if (fragment == null) {
            this.add(position, transaction);
        } else {
            transaction.show(fragment);
        }
    }

    private void hide(int position, FragmentTransaction transaction) {
        String tag = this.mAdapter.getTag(position);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(tag);
        if (fragment != null) {
            transaction.hide(fragment);
        }
    }

    private void add(int position, FragmentTransaction transaction) {
        Fragment fragment = this.mAdapter.onCreateFragment(position);
        String tag = this.mAdapter.getTag(position);
        transaction.add(this.mContainerViewId, fragment, tag);
    }

    private void removeAll(FragmentTransaction transaction) {
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            this.remove(i, transaction);
        }
    }

    private void remove(int position, FragmentTransaction transaction) {
        String tag = this.mAdapter.getTag(position);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(tag);
        if (fragment != null) {
            transaction.remove(fragment);
        }
    }

    public void setDefaultPosition(int defaultPosition) {
        this.mDefaultPosition = defaultPosition;
        if (this.mCurrentPosition == -1) {
            this.mCurrentPosition = defaultPosition;
        }
    }
}

