/*
 * Decompiled with CFR 0.152.
 */
package com.visualizer.amplitude;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.visualizer.amplitude.AudioRecordView$WhenMappings;
import com.visualizer.amplitude.ExtensionsKt;
import com.visualizer.amplitude.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 O2\u00020\u0001:\u0003NOPB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u000209H\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010E\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u0007H\u0002J\u0010\u0010H\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0007H\u0002J\b\u0010J\u001a\u00020AH\u0002J\u0010\u0010J\u001a\u00020A2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010K\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0014J\u0006\u0010L\u001a\u00020AJ\u000e\u0010M\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001a\"\u0004\b-\u0010\u001cR$\u0010.\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001a\"\u0004\b0\u0010\u001cR\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/visualizer/amplitude/AudioRecordView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "chunkAlignTo", "Lcom/visualizer/amplitude/AudioRecordView$AlignTo;", "getChunkAlignTo", "()Lcom/visualizer/amplitude/AudioRecordView$AlignTo;", "setChunkAlignTo", "(Lcom/visualizer/amplitude/AudioRecordView$AlignTo;)V", "value", "chunkColor", "getChunkColor", "()I", "setChunkColor", "(I)V", "chunkHeights", "Ljava/util/ArrayList;", "", "chunkMaxHeight", "getChunkMaxHeight", "()F", "setChunkMaxHeight", "(F)V", "chunkMinHeight", "getChunkMinHeight", "setChunkMinHeight", "chunkPaint", "Landroid/graphics/Paint;", "", "chunkRoundedCorners", "getChunkRoundedCorners", "()Z", "setChunkRoundedCorners", "(Z)V", "chunkSoftTransition", "getChunkSoftTransition", "setChunkSoftTransition", "chunkSpace", "getChunkSpace", "setChunkSpace", "chunkWidth", "getChunkWidth", "setChunkWidth", "chunkWidths", "direction", "Lcom/visualizer/amplitude/AudioRecordView$Direction;", "getDirection", "()Lcom/visualizer/amplitude/AudioRecordView$Direction;", "setDirection", "(Lcom/visualizer/amplitude/AudioRecordView$Direction;)V", "lastUpdateTime", "", "maxReportableAmp", "topBottomPadding", "uninitialized", "usageWidth", "calculateScaleFactor", "updateTimeInterval", "drawAlignBottom", "", "canvas", "Landroid/graphics/Canvas;", "drawAlignCenter", "drawChunks", "getChunkX", "index", "handleNewFFT", "fft", "init", "onDraw", "recreate", "update", "AlignTo", "Companion", "Direction", "audio_release"})
public final class AudioRecordView
extends View {
    private final float maxReportableAmp;
    private final float uninitialized;
    @NotNull
    private AlignTo chunkAlignTo;
    @NotNull
    private Direction direction;
    private final Paint chunkPaint;
    private long lastUpdateTime;
    private float usageWidth;
    private ArrayList<Float> chunkHeights;
    private ArrayList<Float> chunkWidths;
    private float topBottomPadding;
    private boolean chunkSoftTransition;
    private int chunkColor;
    private float chunkWidth;
    private float chunkSpace;
    private float chunkMaxHeight;
    private float chunkMinHeight;
    private boolean chunkRoundedCorners;
    private static final String LOG_TAG;
    @NotNull
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public final AlignTo getChunkAlignTo() {
        return this.chunkAlignTo;
    }

    public final void setChunkAlignTo(@NotNull AlignTo alignTo) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignTo), (String)"<set-?>");
        this.chunkAlignTo = alignTo;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"<set-?>");
        this.direction = direction;
    }

    public final boolean getChunkSoftTransition() {
        return this.chunkSoftTransition;
    }

    public final void setChunkSoftTransition(boolean bl) {
        this.chunkSoftTransition = bl;
    }

    public final int getChunkColor() {
        return this.chunkColor;
    }

    public final void setChunkColor(int value) {
        this.chunkPaint.setColor(value);
        this.chunkColor = value;
    }

    public final float getChunkWidth() {
        return this.chunkWidth;
    }

    public final void setChunkWidth(float value) {
        this.chunkPaint.setStrokeWidth(value);
        this.chunkWidth = value;
    }

    public final float getChunkSpace() {
        return this.chunkSpace;
    }

    public final void setChunkSpace(float f) {
        this.chunkSpace = f;
    }

    public final float getChunkMaxHeight() {
        return this.chunkMaxHeight;
    }

    public final void setChunkMaxHeight(float f) {
        this.chunkMaxHeight = f;
    }

    public final float getChunkMinHeight() {
        return this.chunkMinHeight;
    }

    public final void setChunkMinHeight(float f) {
        this.chunkMinHeight = f;
    }

    public final boolean getChunkRoundedCorners() {
        return this.chunkRoundedCorners;
    }

    public final void setChunkRoundedCorners(boolean value) {
        if (value) {
            this.chunkPaint.setStrokeCap(Paint.Cap.ROUND);
        } else {
            this.chunkPaint.setStrokeCap(Paint.Cap.BUTT);
        }
        this.chunkRoundedCorners = value;
    }

    public final void recreate() {
        this.usageWidth = 0.0f;
        this.chunkWidths.clear();
        this.chunkHeights.clear();
        this.invalidate();
    }

    public final void update(int fft) {
        if (this.getHeight() == 0) {
            Log.w((String)LOG_TAG, (String)"You must call the update fun when the view is displayed");
            return;
        }
        try {
            this.handleNewFFT(fft);
            this.invalidate();
            this.lastUpdateTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            String string = Reflection.getOrCreateKotlinClass(AudioRecordView.class).getSimpleName();
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = e.getClass().getSimpleName();
            }
            Log.e((String)string, (String)string2);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawChunks(canvas);
    }

    private final void init() {
        this.chunkPaint.setStrokeWidth(this.chunkWidth);
        this.chunkPaint.setColor(this.chunkColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AudioRecordView, 0, 0);
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$apply = typedArray;
        boolean bl3 = false;
        try {
            this.chunkSpace = $this$apply.getDimension(R.styleable.AudioRecordView_chunkSpace, this.chunkSpace);
            this.chunkMaxHeight = $this$apply.getDimension(R.styleable.AudioRecordView_chunkMaxHeight, this.chunkMaxHeight);
            this.chunkMinHeight = $this$apply.getDimension(R.styleable.AudioRecordView_chunkMinHeight, this.chunkMinHeight);
            this.setChunkRoundedCorners($this$apply.getBoolean(R.styleable.AudioRecordView_chunkRoundedCorners, this.chunkRoundedCorners));
            this.setChunkWidth($this$apply.getDimension(R.styleable.AudioRecordView_chunkWidth, this.chunkWidth));
            this.setChunkColor($this$apply.getColor(R.styleable.AudioRecordView_chunkColor, this.chunkColor));
            int n = $this$apply.getInt(R.styleable.AudioRecordView_chunkAlignTo, this.chunkAlignTo.getValue());
            this.chunkAlignTo = n == AlignTo.BOTTOM.getValue() ? AlignTo.BOTTOM : AlignTo.CENTER;
            n = $this$apply.getInt(R.styleable.AudioRecordView_direction, this.direction.getValue());
            this.direction = n == Direction.RightToLeft.getValue() ? Direction.RightToLeft : Direction.LeftToRight;
            this.chunkSoftTransition = $this$apply.getBoolean(R.styleable.AudioRecordView_chunkSoftTransition, this.chunkSoftTransition);
            this.setWillNotDraw(false);
            this.chunkPaint.setAntiAlias(true);
        }
        finally {
            $this$apply.recycle();
        }
    }

    private final void handleNewFFT(int fft) {
        if (fft == 0) {
            return;
        }
        float chunkHorizontalScale = this.chunkWidth + this.chunkSpace;
        float maxChunkCount = (float)this.getWidth() / chunkHorizontalScale;
        Collection collection = this.chunkHeights;
        boolean bl = false;
        if (!collection.isEmpty() && (float)this.chunkHeights.size() >= maxChunkCount) {
            Intrinsics.checkNotNullExpressionValue((Object)this.chunkHeights.remove(0), (String)"chunkHeights.removeAt(0)");
        } else {
            this.usageWidth += chunkHorizontalScale;
            this.chunkWidths.add(Float.valueOf(this.usageWidth));
        }
        if (this.chunkMaxHeight == this.uninitialized) {
            this.chunkMaxHeight = (float)this.getHeight() - this.topBottomPadding * (float)2;
        } else if (this.chunkMaxHeight > (float)this.getHeight() - this.topBottomPadding * (float)2) {
            this.chunkMaxHeight = (float)this.getHeight() - this.topBottomPadding * (float)2;
        }
        float verticalDrawScale = this.chunkMaxHeight - this.chunkMinHeight;
        if (verticalDrawScale == 0.0f) {
            return;
        }
        float point = this.maxReportableAmp / verticalDrawScale;
        if (point == 0.0f) {
            return;
        }
        float fftPoint = (float)fft / point;
        if (this.chunkSoftTransition) {
            Collection collection2 = this.chunkHeights;
            boolean bl2 = false;
            if (!collection2.isEmpty()) {
                long updateTimeInterval = System.currentTimeMillis() - this.lastUpdateTime;
                float scaleFactor = this.calculateScaleFactor(updateTimeInterval);
                float prevFftWithoutAdditionalSize = ((Number)CollectionsKt.last((List)this.chunkHeights)).floatValue() - this.chunkMinHeight;
                fftPoint = ExtensionsKt.softTransition(fftPoint, prevFftWithoutAdditionalSize, 2.2f, scaleFactor);
            }
        }
        if ((fftPoint += this.chunkMinHeight) > this.chunkMaxHeight) {
            fftPoint = this.chunkMaxHeight;
        } else if (fftPoint < this.chunkMinHeight) {
            fftPoint = this.chunkMinHeight;
        }
        this.chunkHeights.add(this.chunkHeights.size(), Float.valueOf(fftPoint));
    }

    private final float calculateScaleFactor(long updateTimeInterval) {
        long l = updateTimeInterval;
        long l2 = l;
        return 0L <= l2 && (long)50 >= l2 ? 1.6f : ((long)50 <= (l2 = l) && (long)100 >= l2 ? 2.2f : ((long)100 <= (l2 = l) && (long)150 >= l2 ? 2.8f : ((long)100 <= (l2 = l) && (long)150 >= l2 ? 3.4f : ((long)150 <= (l2 = l) && (long)200 >= l2 ? 4.2f : ((long)200 <= (l2 = l) && (long)500 >= l2 ? 4.8f : 5.4f)))));
    }

    private final void drawChunks(Canvas canvas) {
        switch (AudioRecordView$WhenMappings.$EnumSwitchMapping$0[this.chunkAlignTo.ordinal()]) {
            case 1: {
                this.drawAlignBottom(canvas);
                break;
            }
            default: {
                this.drawAlignCenter(canvas);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawAlignCenter(Canvas canvas) {
        int verticalCenter = this.getHeight() / 2;
        int n = 0;
        int n2 = this.chunkHeights.size() - 1;
        while (n < n2) {
            void i;
            float chunkX = this.getChunkX((int)i);
            float startY = (float)verticalCenter - ((Number)this.chunkHeights.get((int)i)).floatValue() / (float)2;
            float stopY = (float)verticalCenter + ((Number)this.chunkHeights.get((int)i)).floatValue() / (float)2;
            canvas.drawLine(chunkX, startY, chunkX, stopY, this.chunkPaint);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawAlignBottom(Canvas canvas) {
        int n = 0;
        int n2 = this.chunkHeights.size() - 1;
        while (n < n2) {
            void i;
            float chunkX = this.getChunkX((int)i);
            float startY = (float)this.getHeight() - this.topBottomPadding;
            Float f = this.chunkHeights.get((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"chunkHeights[i]");
            float stopY = startY - ((Number)f).floatValue();
            canvas.drawLine(chunkX, startY, chunkX, stopY, this.chunkPaint);
            ++i;
        }
    }

    private final float getChunkX(int index) {
        float f;
        if (this.direction == Direction.RightToLeft) {
            float f2 = this.getWidth();
            Float f3 = this.chunkWidths.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"chunkWidths[index]");
            f = f2 - ((Number)f3).floatValue();
        } else {
            Float f4 = this.chunkWidths.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"chunkWidths[index]");
            f = ((Number)f4).floatValue();
        }
        return f;
    }

    @JvmOverloads
    public AudioRecordView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxReportableAmp = 22760.0f;
        this.chunkAlignTo = AlignTo.CENTER;
        this.direction = Direction.LeftToRight;
        this.chunkPaint = new Paint();
        this.chunkHeights = new ArrayList();
        this.chunkWidths = new ArrayList();
        this.topBottomPadding = ExtensionsKt.dp(6);
        this.chunkColor = -65536;
        this.chunkWidth = ExtensionsKt.dp(2);
        this.chunkSpace = ExtensionsKt.dp(1);
        this.chunkMaxHeight = this.uninitialized;
        this.chunkMinHeight = ExtensionsKt.dp(3);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            this.init(it);
        } else {
            AudioRecordView audioRecordView = this;
            boolean bl = false;
            boolean bl4 = false;
            AudioRecordView $this$run = audioRecordView;
            boolean bl5 = false;
            $this$run.init();
        }
    }

    public /* synthetic */ AudioRecordView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public AudioRecordView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AudioRecordView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        LOG_TAG = AudioRecordView.class.getSimpleName();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/visualizer/amplitude/AudioRecordView$AlignTo;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "setValue", "(I)V", "CENTER", "BOTTOM", "audio_release"})
    public static final class AlignTo
    extends Enum<AlignTo> {
        public static final /* enum */ AlignTo CENTER;
        public static final /* enum */ AlignTo BOTTOM;
        private static final /* synthetic */ AlignTo[] $VALUES;
        private int value;

        static {
            AlignTo[] alignToArray = new AlignTo[2];
            AlignTo[] alignToArray2 = alignToArray;
            alignToArray[0] = CENTER = new AlignTo(1);
            alignToArray[1] = BOTTOM = new AlignTo(2);
            $VALUES = alignToArray;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        private AlignTo(int value) {
            this.value = value;
        }

        public static AlignTo[] values() {
            return (AlignTo[])$VALUES.clone();
        }

        public static AlignTo valueOf(String string) {
            return Enum.valueOf(AlignTo.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/visualizer/amplitude/AudioRecordView$Direction;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "setValue", "(I)V", "RightToLeft", "LeftToRight", "audio_release"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction RightToLeft;
        public static final /* enum */ Direction LeftToRight;
        private static final /* synthetic */ Direction[] $VALUES;
        private int value;

        static {
            Direction[] directionArray = new Direction[2];
            Direction[] directionArray2 = directionArray;
            directionArray[0] = RightToLeft = new Direction(1);
            directionArray[1] = LeftToRight = new Direction(2);
            $VALUES = directionArray;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        private Direction(int value) {
            this.value = value;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/visualizer/amplitude/AudioRecordView$Companion;", "", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

