/*
 * Decompiled with CFR 0.152.
 */
package com.github.device;

import com.github.device.Device;
import com.github.device.DeviceType;
import com.github.device.IOSRuntime;
import com.github.interfaces.ISimulatorManager;
import com.github.utils.CommandPromptUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SimulatorManager
implements ISimulatorManager {
    static final Logger logger = Logger.getLogger(SimulatorManager.class);
    private CommandPromptUtil commandPromptUtil = new CommandPromptUtil();
    String ANSI_RED_BACKGROUND = "\u001b[41m";
    Process screenRecordProcess;

    @Override
    public List<Device> getAllSimulators(String osType) throws InterruptedException, IOException {
        List<Device> devices = this.getAllAvailableSimulators();
        List<Device> deviceListForOS = devices.stream().filter(device -> osType.equals(device.getOs())).collect(SimulatorManager.toList());
        return deviceListForOS;
    }

    @Override
    public Device getDevice(String deviceName, String osVersion, String osType) throws InterruptedException, IOException {
        List<Device> allSimulators = this.getAllSimulators(osType);
        Optional<Device> device = allSimulators.stream().filter(d -> deviceName.equals(d.getName()) && osVersion.equals(d.getOsVersion()) && osType.equals(d.getOs())).findFirst();
        return device.orElseThrow(() -> new RuntimeException("Device Not found with deviceName-" + deviceName + " osVersion-" + osVersion + " osType-" + osType));
    }

    @Override
    public String getSimulatorUDID(String deviceName, String osVersion, String osType) throws Throwable {
        Device device = this.getDevice(deviceName, osVersion, osType);
        return device.getUdid();
    }

    @Override
    public String getSimulatorState(String deviceName, String osVersion, String osType) throws Throwable {
        Device device = this.getDevice(deviceName, osVersion, osType);
        return device.getState();
    }

    @Override
    public void bootSimulator(String deviceName, String osVersion, String osType) throws Throwable {
        String simulatorUDID = this.getSimulatorUDID(deviceName, osVersion, osType);
        this.commandPromptUtil.runCommandThruProcess("xcrun simctl boot " + simulatorUDID);
        logger.debug((Object)(this.ANSI_RED_BACKGROUND + "Waiting for Simulator to Boot Completely....."));
        this.commandPromptUtil.runCommandThruProcess("xcrun simctl launch booted com.apple.springboard");
        this.commandPromptUtil.runCommandThruProcess("open -a Simulator --args -CurrentDeviceUDID " + simulatorUDID);
    }

    @Override
    public Device getSimulatorDetailsFromUDID(String UDID) {
        List<Device> allSimulators = null;
        try {
            allSimulators = this.getAllAvailableSimulators();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Optional<Device> device = allSimulators.stream().filter(d -> UDID.equals(d.getUdid())).findFirst();
        return device.orElseThrow(() -> new RuntimeException("Device Not found"));
    }

    @Override
    public void captureScreenshot(String UDID, String fileName, String fileDestination, String format) throws IOException, InterruptedException {
        String xcodeVersion = this.commandPromptUtil.runCommandThruProcess("xcodebuild -version").split("(\\n)|(Xcode)")[1].trim();
        if ((double)Float.valueOf(xcodeVersion).floatValue() < 8.2) {
            new RuntimeException("Screenshot capture is only supported with xcode version 8.2 and above");
        } else {
            this.commandPromptUtil.runCommandThruProcess("xcrun simctl io " + UDID + " screenshot " + fileDestination + "/" + fileName + "." + format);
        }
    }

    @Override
    public boolean shutDownAllBootedSimulators() throws IOException, InterruptedException {
        List<String> bootedDevices = this.commandPromptUtil.runCommand("xcrun simctl list | grep Booted");
        bootedDevices.forEach(bootedUDID -> {
            try {
                this.commandPromptUtil.runCommandThruProcess("xcrun simctl shutdown " + bootedUDID);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        String bootedDeviceCountAfterShutDown = this.commandPromptUtil.runCommandThruProcess("xcrun simctl list | grep Booted | wc -l");
        if (Integer.valueOf(bootedDeviceCountAfterShutDown.trim()) == 0) {
            logger.debug((Object)(this.ANSI_RED_BACKGROUND + "All Booted Simulators Shut..."));
            return true;
        }
        logger.debug((Object)(this.ANSI_RED_BACKGROUND + "Simulators that needs to be ShutDown are" + this.commandPromptUtil.runCommand("xcrun simctl list | grep Booted")));
        return false;
    }

    @Override
    public List<Device> getAllBootedSimulators(String osType) throws InterruptedException, IOException {
        List<Device> allSimulators = this.getAllSimulators(osType);
        List<Device> bootedSim = allSimulators.stream().filter(device -> device.getState().equalsIgnoreCase("Booted")).collect(Collectors.toList());
        return bootedSim;
    }

    @Override
    public void uploadMediaToSimulator(String deviceName, String osVersion, String osType, String filePath) throws Throwable {
        String simulatorUDID = this.getSimulatorUDID(deviceName, osVersion, osType);
        String execute = "xcrun simctl addmedia " + simulatorUDID + " " + filePath;
        this.commandPromptUtil.execForProcessToExecute(execute).waitFor();
    }

    @Override
    public void startScreenRecording(String pathWithFileName) throws IOException {
        System.out.println("xcrun simctl io booted recordVideo " + pathWithFileName);
        this.screenRecordProcess = this.commandPromptUtil.execForProcessToExecute("xcrun simctl io booted recordVideo " + pathWithFileName);
        System.out.println(this.screenRecordProcess);
    }

    @Override
    public Process startScreenRecording(String UDID, String pathWithFileName) throws IOException {
        System.out.println("xcrun simctl io " + UDID + " recordVideo " + pathWithFileName);
        this.screenRecordProcess = this.commandPromptUtil.execForProcessToExecute("xcrun simctl io " + UDID + " recordVideo " + pathWithFileName);
        System.out.println(this.screenRecordProcess);
        return this.screenRecordProcess;
    }

    @Override
    public void stopScreenRecording() throws IOException, InterruptedException {
        Integer processId = this.getPid(this.screenRecordProcess);
        String command = "kill -9 " + processId;
        System.out.println("Stopping Video Recording" + command);
        this.commandPromptUtil.execForProcessToExecute(command);
    }

    @Override
    public void installAppOnSimulator(String deviceName, String osVersion, String osType, String appPath) throws Throwable {
        String simulatorUDID = this.getSimulatorUDID(deviceName, osVersion, osType);
        String execute = "xcrun simctl install " + simulatorUDID + " " + appPath;
        this.commandPromptUtil.execForProcessToExecute(execute).waitFor();
    }

    @Override
    public void uninstallAppFromSimulator(String deviceName, String osVersion, String osType, String bundleID) throws Throwable {
        String simulatorUDID = this.getSimulatorUDID(deviceName, osVersion, osType);
        String execute = "xcrun simctl uninstall " + simulatorUDID + " " + bundleID;
        this.commandPromptUtil.execForProcessToExecute(execute).waitFor();
    }

    @Override
    public void createSimulator(String simName, String deviceName, String osVersion, String osType) throws Throwable {
        List<DeviceType> deviceTypes = this.getAllDeviceTypes();
        DeviceType deviceType = deviceTypes.stream().filter(d -> deviceName.equals(d.getName())).findFirst().get();
        List<IOSRuntime> deviceIOSRuntimes = this.getAllRuntimes();
        IOSRuntime IOSRuntime2 = deviceIOSRuntimes.stream().filter(r -> osType.equals(r.getOs()) && osVersion.equals(r.getVersion())).findFirst().get();
        this.commandPromptUtil.runCommandThruProcess("xcrun simctl create " + simName + " " + deviceType.getIdentifier() + " " + IOSRuntime2.getIdentifier());
    }

    @Override
    public void deleteSimulator(String deviceName, String osVersion, String osType) throws Throwable {
        String simulatorUDID = this.getSimulatorUDID(deviceName, osVersion, osType);
        this.commandPromptUtil.runCommandThruProcess("xcrun simctl delete " + simulatorUDID);
    }

    public List<Device> getAllAvailableSimulators() throws IOException, InterruptedException {
        CommandPromptUtil commandPromptUtil = new CommandPromptUtil();
        String simulatorJsonString = commandPromptUtil.runCommandThruProcess("xcrun simctl list -j devices");
        JSONObject simulatorsJson = new JSONObject(simulatorJsonString);
        JSONObject devicesByTypeJson = (JSONObject)simulatorsJson.get("devices");
        Iterator keys = devicesByTypeJson.keys();
        ArrayList<Device> deviceList = new ArrayList<Device>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONArray devicesJson = (JSONArray)devicesByTypeJson.get(key);
            devicesJson.forEach(deviceJson -> deviceList.add(new Device((JSONObject)deviceJson, key)));
        }
        return deviceList;
    }

    private List<DeviceType> getAllDeviceTypes() throws IOException, InterruptedException {
        CommandPromptUtil commandPromptUtil = new CommandPromptUtil();
        String deviceTypesJSONString = commandPromptUtil.runCommandThruProcess("xcrun simctl list -j devicetypes");
        JSONObject devicesTypesJSON = new JSONObject(deviceTypesJSONString);
        JSONArray devicesTypes = devicesTypesJSON.getJSONArray("devicetypes");
        ArrayList<DeviceType> deviceTypes = new ArrayList<DeviceType>();
        devicesTypes.forEach(deviceType -> {
            String name = ((JSONObject)deviceType).getString("name");
            String identifier = ((JSONObject)deviceType).getString("identifier");
            deviceTypes.add(new DeviceType(name, identifier));
        });
        return deviceTypes;
    }

    private List<IOSRuntime> getAllRuntimes() throws IOException, InterruptedException {
        CommandPromptUtil commandPromptUtil = new CommandPromptUtil();
        String runtimesJSONString = commandPromptUtil.runCommandThruProcess("xcrun simctl list -j runtimes");
        JSONArray runtimesJSON = new JSONObject(runtimesJSONString).getJSONArray("runtimes");
        ArrayList<IOSRuntime> IOSRuntimes = new ArrayList<IOSRuntime>();
        runtimesJSON.forEach(runtime -> IOSRuntimes.add(new IOSRuntime((JSONObject)runtime)));
        return IOSRuntimes;
    }

    public int getPid(Process process) {
        try {
            Class<?> cProcessImpl = process.getClass();
            Field fPid = cProcessImpl.getDeclaredField("pid");
            if (!fPid.isAccessible()) {
                fPid.setAccessible(true);
            }
            return fPid.getInt(process);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static <T> Collector<T, ?, List<T>> toList() {
        return Collectors.toCollection(ArrayList::new);
    }
}

