/*
 * Decompiled with CFR 0.152.
 */
package com.github.device;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Device {
    private String udid;
    private String name;
    private String state = "Not Supported";
    private boolean isAvailable;
    private String osVersion;
    private String os = "Not Supported";
    private String deviceType = "Not Supported";
    private String brand = "Not Supported";
    private String apiLevel = "Not Supported";
    private boolean isDevice;
    private String deviceModel = "Not Supported";
    private String screenSize;
    private String deviceManufacturer;
    private boolean isCloud = false;
    private static Map<String, String> deviceIdentifier = new HashMap<String, String>();

    public Device(JSONObject deviceJson, String deviceType) {
        this.udid = deviceJson.getString("udid");
        this.name = deviceJson.getString("name");
        this.state = deviceJson.getString("state");
        this.isAvailable = deviceJson.getBoolean("isAvailable");
        this.deviceType = deviceType;
        this.getOSAndVersion(deviceType);
        this.deviceModel = deviceIdentifier.getOrDefault(this.name, "Not Supported");
        this.deviceManufacturer = "apple";
    }

    private void getOSAndVersion(String deviceType) {
        String[] osAndVersion = deviceType.split(" ");
        if (osAndVersion.length == 2) {
            this.os = osAndVersion[0];
            this.osVersion = osAndVersion[1];
        } else {
            String[] splitDeviceType = deviceType.split("\\.");
            if (splitDeviceType.length == 5 && (osAndVersion = splitDeviceType[splitDeviceType.length - 1].split("-")).length == 3) {
                this.os = osAndVersion[0];
                this.osVersion = osAndVersion[1] + "." + osAndVersion[2];
            }
        }
    }

    public Device(JSONObject deviceJson) {
        this.udid = deviceJson.getString("udid");
        this.name = deviceJson.getString("name");
        this.osVersion = deviceJson.getString("osVersion");
        this.brand = deviceJson.getString("brand");
        this.apiLevel = deviceJson.getString("apiLevel");
        this.isDevice = deviceJson.getBoolean("isDevice");
        this.deviceModel = deviceJson.getString("deviceModel");
        this.screenSize = deviceJson.getString("screenSize");
        this.os = deviceJson.getString("os");
        this.deviceManufacturer = deviceJson.getString("deviceManufacturer");
    }

    public Device() {
    }

    public String getUdid() {
        return this.udid;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOs() {
        return this.os;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getApiLevel() {
        return this.apiLevel;
    }

    public boolean isDevice() {
        return this.isDevice;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public boolean isCloud() {
        return this.isCloud;
    }

    public void setUdid(String udid) {
        this.udid = udid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setApiLevel(String apiLevel) {
        this.apiLevel = apiLevel;
    }

    public void setDevice(boolean isDevice) {
        this.isDevice = isDevice;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setScreenSize(String screenSize) {
        this.screenSize = screenSize;
    }

    public void setDeviceManufacturer(String deviceManufacturer) {
        this.deviceManufacturer = deviceManufacturer;
    }

    public void setCloud(boolean isCloud) {
        this.isCloud = isCloud;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$udid = this.getUdid();
        String other$udid = other.getUdid();
        if (this$udid == null ? other$udid != null : !this$udid.equals(other$udid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        if (this.isAvailable() != other.isAvailable()) {
            return false;
        }
        String this$osVersion = this.getOsVersion();
        String other$osVersion = other.getOsVersion();
        if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$apiLevel = this.getApiLevel();
        String other$apiLevel = other.getApiLevel();
        if (this$apiLevel == null ? other$apiLevel != null : !this$apiLevel.equals(other$apiLevel)) {
            return false;
        }
        if (this.isDevice() != other.isDevice()) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        if (this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel)) {
            return false;
        }
        String this$screenSize = this.getScreenSize();
        String other$screenSize = other.getScreenSize();
        if (this$screenSize == null ? other$screenSize != null : !this$screenSize.equals(other$screenSize)) {
            return false;
        }
        String this$deviceManufacturer = this.getDeviceManufacturer();
        String other$deviceManufacturer = other.getDeviceManufacturer();
        if (this$deviceManufacturer == null ? other$deviceManufacturer != null : !this$deviceManufacturer.equals(other$deviceManufacturer)) {
            return false;
        }
        return this.isCloud() == other.isCloud();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $udid = this.getUdid();
        result = result * 59 + ($udid == null ? 43 : $udid.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        result = result * 59 + (this.isAvailable() ? 79 : 97);
        String $osVersion = this.getOsVersion();
        result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $apiLevel = this.getApiLevel();
        result = result * 59 + ($apiLevel == null ? 43 : $apiLevel.hashCode());
        result = result * 59 + (this.isDevice() ? 79 : 97);
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        String $screenSize = this.getScreenSize();
        result = result * 59 + ($screenSize == null ? 43 : $screenSize.hashCode());
        String $deviceManufacturer = this.getDeviceManufacturer();
        result = result * 59 + ($deviceManufacturer == null ? 43 : $deviceManufacturer.hashCode());
        result = result * 59 + (this.isCloud() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Device(udid=" + this.getUdid() + ", name=" + this.getName() + ", state=" + this.getState() + ", isAvailable=" + this.isAvailable() + ", osVersion=" + this.getOsVersion() + ", os=" + this.getOs() + ", deviceType=" + this.getDeviceType() + ", brand=" + this.getBrand() + ", apiLevel=" + this.getApiLevel() + ", isDevice=" + this.isDevice() + ", deviceModel=" + this.getDeviceModel() + ", screenSize=" + this.getScreenSize() + ", deviceManufacturer=" + this.getDeviceManufacturer() + ", isCloud=" + this.isCloud() + ")";
    }

    static {
        deviceIdentifier.put("iPhone 5s", "iPhone6,1");
        deviceIdentifier.put("iPhone 6", "iPhone7,2");
        deviceIdentifier.put("iPhone 6 Plus", "iPhone7,1");
        deviceIdentifier.put("iPhone 6s", "iPhone8,1");
        deviceIdentifier.put("iPhone 6s Plus", "iPhone8,2");
        deviceIdentifier.put("iPhone 7", "iPhone9,1");
        deviceIdentifier.put("iPhone 7 Plus", "iPhone9,2");
        deviceIdentifier.put("iPhone 8", "iPhone10,1");
        deviceIdentifier.put("iPhone 8 Plus", "iPhone10,2");
        deviceIdentifier.put("iPhone SE", "iPhone8,4");
        deviceIdentifier.put("iPhone X", "iPhone10,3");
    }
}

