/*
 * Decompiled with CFR 0.152.
 */
package com.dou361.ijkplayer.widget;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SeekBar;
import android.widget.TextView;
import com.dou361.ijkplayer.R;
import com.dou361.ijkplayer.adapter.StreamSelectAdapter;
import com.dou361.ijkplayer.bean.VideoijkBean;
import com.dou361.ijkplayer.listener.OnControlPanelVisibilityChangeListener;
import com.dou361.ijkplayer.listener.OnPlayerBackListener;
import com.dou361.ijkplayer.listener.OnShowThumbnailListener;
import com.dou361.ijkplayer.utils.NetworkUtils;
import com.dou361.ijkplayer.widget.IjkVideoView;
import com.dou361.ijkplayer.widget.LayoutQuery;
import java.util.ArrayList;
import java.util.List;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class PlayerView {
    private static final String TAG = PlayerView.class.getSimpleName();
    private final Context mContext;
    private final Activity mActivity;
    private final LayoutQuery query;
    private final IjkVideoView videoView;
    private final View rl_box;
    private final View ll_topbar;
    private final View ll_bottombar;
    private final ImageView iv_trumb;
    private final ImageView iv_rotation;
    private final ImageView iv_back;
    private final ImageView iv_menu;
    private final ImageView iv_bar_player;
    private final ImageView iv_player;
    private final ImageView iv_fullscreen;
    private final View settingsContainer;
    private final View volumeControllerContainer;
    private final View brightnessControllerContainer;
    private final SeekBar volumeController;
    private final SeekBar brightnessController;
    private final TextView tv_steam;
    private final TextView tv_speed;
    private final SeekBar seekBar;
    private final LinearLayout streamSelectView;
    private final ListView streamSelectListView;
    private final StreamSelectAdapter streamSelectAdapter;
    private List<VideoijkBean> listVideos = new ArrayList<VideoijkBean>();
    private int status = 330;
    private int currentPosition;
    private long newPosition = -1L;
    private int rotation = 0;
    private int currentShowType = 0;
    private long duration;
    private int volume;
    private final int mMaxVolume;
    private final int screenWidthPixels;
    private final int initHeight;
    private float brightness;
    private String currentUrl;
    private int currentSelect;
    private int bgState;
    private int autoConnectTime = 5000;
    private boolean playerSupport;
    private boolean isLive;
    private boolean isShowControlPanl;
    private boolean isForbidTouch;
    private boolean isForbidHideControlPanl;
    private boolean isHasSwitchStream;
    private boolean isDragging;
    private boolean isGNetWork = true;
    private boolean isCharge;
    private int maxPlaytime;
    private boolean isOnlyFullScreen;
    private boolean isForbidDoulbeUp;
    private boolean isErrorStop = true;
    private boolean isPortrait = true;
    private boolean isHideCenterPlayer;
    private boolean isAutoReConnect = true;
    private boolean isHideTopBar;
    private boolean isHideBottonBar;
    private final AudioManager audioManager;
    private static final int MESSAGE_SHOW_PROGRESS = 1;
    private static final int MESSAGE_SEEK_NEW_POSITION = 3;
    private static final int MESSAGE_HIDE_CENTER_BOX = 4;
    private static final int MESSAGE_RESTART_PLAY = 5;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    PlayerView.this.query.id(R.id.app_video_volume_box).gone();
                    PlayerView.this.query.id(R.id.app_video_brightness_box).gone();
                    PlayerView.this.query.id(R.id.app_video_fastForward_box).gone();
                    break;
                }
                case 3: {
                    if (PlayerView.this.isLive || PlayerView.this.newPosition < 0L) break;
                    PlayerView.this.videoView.seekTo((int)PlayerView.this.newPosition);
                    PlayerView.this.newPosition = -1L;
                    break;
                }
                case 1: {
                    long pos = PlayerView.this.syncProgress();
                    if (PlayerView.this.isDragging || !PlayerView.this.isShowControlPanl) break;
                    msg = this.obtainMessage(1);
                    this.sendMessageDelayed(msg, 1000L - pos % 1000L);
                    PlayerView.this.updatePausePlay();
                    break;
                }
                case 5: {
                    PlayerView.this.status = 331;
                    PlayerView.this.startPlay();
                    PlayerView.this.updatePausePlay();
                }
            }
        }
    };
    private AutoPlayRunnable mAutoPlayRunnable = new AutoPlayRunnable();
    private final OrientationEventListener orientationEventListener;
    private OnControlPanelVisibilityChangeListener onControlPanelVisibilityChangeListener;
    private OnShowThumbnailListener mOnShowThumbnailListener;
    private OnPlayerBackListener mPlayerBack;
    private IMediaPlayer.OnInfoListener onInfoListener;
    private final View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getId() == R.id.app_video_menu) {
                PlayerView.this.showMenu();
            } else if (v.getId() == R.id.app_video_stream) {
                PlayerView.this.showStreamSelectView();
            } else if (v.getId() == R.id.ijk_iv_rotation) {
                PlayerView.this.setPlayerRotation();
            } else if (v.getId() == R.id.app_video_fullscreen) {
                PlayerView.this.toggleFullScreen();
            } else if (v.getId() == R.id.app_video_play || v.getId() == R.id.play_icon) {
                if (PlayerView.this.videoView.isPlaying()) {
                    if (PlayerView.this.isLive) {
                        PlayerView.this.videoView.stopPlayback();
                    } else {
                        PlayerView.this.pausePlay();
                    }
                } else {
                    PlayerView.this.startPlay();
                    if (PlayerView.this.videoView.isPlaying()) {
                        PlayerView.this.status = 332;
                        PlayerView.this.hideStatusUI();
                    }
                }
                PlayerView.this.updatePausePlay();
            } else if (v.getId() == R.id.app_video_finish) {
                if (!PlayerView.this.isOnlyFullScreen && !PlayerView.this.isPortrait) {
                    PlayerView.this.mActivity.setRequestedOrientation(1);
                } else if (PlayerView.this.mPlayerBack != null) {
                    PlayerView.this.mPlayerBack.onPlayerBack();
                } else {
                    PlayerView.this.mActivity.finish();
                }
            } else if (v.getId() == R.id.app_video_netTie_icon) {
                PlayerView.this.isGNetWork = false;
                PlayerView.this.hideStatusUI();
                PlayerView.this.startPlay();
                PlayerView.this.updatePausePlay();
            } else if (v.getId() == R.id.app_video_replay_icon) {
                PlayerView.this.status = 331;
                PlayerView.this.hideStatusUI();
                PlayerView.this.startPlay();
                PlayerView.this.updatePausePlay();
            }
        }
    };
    private final SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (!fromUser) {
                return;
            }
            long duration = PlayerView.this.getDuration();
            int position = (int)((double)(duration * (long)progress) * 1.0 / 1000.0);
            String time = PlayerView.this.generateTime(position);
            PlayerView.this.query.id(R.id.app_video_currentTime).text(time);
            PlayerView.this.query.id(R.id.app_video_currentTime_full).text(time);
            PlayerView.this.query.id(R.id.app_video_currentTime_left).text(time);
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            PlayerView.this.isDragging = true;
            PlayerView.this.mHandler.removeMessages(1);
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            long duration = PlayerView.this.getDuration();
            PlayerView.this.videoView.seekTo((int)((double)(duration * (long)seekBar.getProgress()) * 1.0 / 1000.0));
            PlayerView.this.mHandler.removeMessages(1);
            PlayerView.this.isDragging = false;
            PlayerView.this.mHandler.sendEmptyMessageDelayed(1, 1000L);
        }
    };
    private final SeekBar.OnSeekBarChangeListener onBrightnessControllerChangeListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            PlayerView.this.setBrightness(progress);
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            PlayerView.this.brightness = -1.0f;
        }
    };
    private final SeekBar.OnSeekBarChangeListener onVolumeControllerChangeListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            int index = (int)((double)(PlayerView.this.mMaxVolume * progress) * 0.01);
            if (index > PlayerView.this.mMaxVolume) {
                index = PlayerView.this.mMaxVolume;
            } else if (index < 0) {
                index = 0;
            }
            PlayerView.this.audioManager.setStreamVolume(3, index, 0);
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            PlayerView.this.volume = -1;
        }
    };

    public void setBrightness(int value) {
        WindowManager.LayoutParams layout2 = this.mActivity.getWindow().getAttributes();
        if (this.brightness < 0.0f) {
            this.brightness = this.mActivity.getWindow().getAttributes().screenBrightness;
            if (this.brightness <= 0.0f) {
                this.brightness = 0.5f;
            } else if (this.brightness < 0.01f) {
                this.brightness = 0.01f;
            }
        }
        if (value < 1) {
            value = 1;
        }
        if (value > 100) {
            value = 100;
        }
        layout2.screenBrightness = 1.0f * (float)value / 100.0f;
        if (layout2.screenBrightness > 1.0f) {
            layout2.screenBrightness = 1.0f;
        } else if (layout2.screenBrightness < 0.01f) {
            layout2.screenBrightness = 0.01f;
        }
        this.mActivity.getWindow().setAttributes(layout2);
    }

    public PlayerView(Activity activity) {
        this(activity, null);
    }

    public PlayerView(Activity activity, View rootView) {
        this.mActivity = activity;
        this.mContext = activity;
        try {
            IjkMediaPlayer.loadLibrariesOnce(null);
            IjkMediaPlayer.native_profileBegin((String)"libijkplayer.so");
            this.playerSupport = true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"loadLibraries error", (Throwable)e);
        }
        this.screenWidthPixels = this.mContext.getResources().getDisplayMetrics().widthPixels;
        this.audioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mMaxVolume = this.audioManager.getStreamMaxVolume(3);
        if (rootView == null) {
            this.query = new LayoutQuery(this.mActivity);
            this.rl_box = this.mActivity.findViewById(R.id.app_video_box);
            this.videoView = (IjkVideoView)this.mActivity.findViewById(R.id.video_view);
            this.settingsContainer = this.mActivity.findViewById(R.id.simple_player_settings_container);
            this.settingsContainer.setVisibility(8);
            this.volumeControllerContainer = this.mActivity.findViewById(R.id.simple_player_volume_controller_container);
            this.volumeController = (SeekBar)this.mActivity.findViewById(R.id.simple_player_volume_controller);
            this.volumeController.setMax(100);
            this.volumeController.setOnSeekBarChangeListener(this.onVolumeControllerChangeListener);
            this.brightnessControllerContainer = this.mActivity.findViewById(R.id.simple_player_brightness_controller_container);
            this.brightnessController = (SeekBar)this.mActivity.findViewById(R.id.simple_player_brightness_controller);
            this.brightnessController.setMax(100);
        } else {
            this.query = new LayoutQuery((Context)this.mActivity, rootView);
            this.rl_box = rootView.findViewById(R.id.app_video_box);
            this.videoView = (IjkVideoView)rootView.findViewById(R.id.video_view);
            this.settingsContainer = rootView.findViewById(R.id.simple_player_settings_container);
            this.settingsContainer.setVisibility(8);
            this.volumeControllerContainer = rootView.findViewById(R.id.simple_player_volume_controller_container);
            this.volumeController = (SeekBar)rootView.findViewById(R.id.simple_player_volume_controller);
            this.volumeController.setMax(100);
            this.volumeController.setOnSeekBarChangeListener(this.onVolumeControllerChangeListener);
            this.brightnessControllerContainer = rootView.findViewById(R.id.simple_player_brightness_controller_container);
            this.brightnessController = (SeekBar)rootView.findViewById(R.id.simple_player_brightness_controller);
            this.brightnessController.setMax(100);
        }
        try {
            int e = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness");
            float progress = 1.0f * (float)e / 255.0f;
            WindowManager.LayoutParams layout2 = this.mActivity.getWindow().getAttributes();
            layout2.screenBrightness = progress;
            this.mActivity.getWindow().setAttributes(layout2);
        }
        catch (Settings.SettingNotFoundException var7) {
            var7.printStackTrace();
        }
        this.brightnessController.setOnSeekBarChangeListener(this.onBrightnessControllerChangeListener);
        if (rootView == null) {
            this.streamSelectView = (LinearLayout)this.mActivity.findViewById(R.id.simple_player_select_stream_container);
            this.streamSelectListView = (ListView)this.mActivity.findViewById(R.id.simple_player_select_streams_list);
            this.ll_topbar = this.mActivity.findViewById(R.id.app_video_top_box);
            this.ll_bottombar = this.mActivity.findViewById(R.id.ll_bottom_bar);
            this.iv_trumb = (ImageView)this.mActivity.findViewById(R.id.iv_trumb);
            this.iv_back = (ImageView)this.mActivity.findViewById(R.id.app_video_finish);
            this.iv_menu = (ImageView)this.mActivity.findViewById(R.id.app_video_menu);
            this.iv_bar_player = (ImageView)this.mActivity.findViewById(R.id.app_video_play);
            this.iv_player = (ImageView)this.mActivity.findViewById(R.id.play_icon);
            this.iv_rotation = (ImageView)this.mActivity.findViewById(R.id.ijk_iv_rotation);
            this.iv_fullscreen = (ImageView)this.mActivity.findViewById(R.id.app_video_fullscreen);
            this.tv_steam = (TextView)this.mActivity.findViewById(R.id.app_video_stream);
            this.tv_speed = (TextView)this.mActivity.findViewById(R.id.app_video_speed);
            this.seekBar = (SeekBar)this.mActivity.findViewById(R.id.app_video_seekBar);
        } else {
            this.streamSelectView = (LinearLayout)rootView.findViewById(R.id.simple_player_select_stream_container);
            this.streamSelectListView = (ListView)rootView.findViewById(R.id.simple_player_select_streams_list);
            this.ll_topbar = rootView.findViewById(R.id.app_video_top_box);
            this.ll_bottombar = rootView.findViewById(R.id.ll_bottom_bar);
            this.iv_trumb = (ImageView)rootView.findViewById(R.id.iv_trumb);
            this.iv_back = (ImageView)rootView.findViewById(R.id.app_video_finish);
            this.iv_menu = (ImageView)rootView.findViewById(R.id.app_video_menu);
            this.iv_bar_player = (ImageView)rootView.findViewById(R.id.app_video_play);
            this.iv_player = (ImageView)rootView.findViewById(R.id.play_icon);
            this.iv_rotation = (ImageView)rootView.findViewById(R.id.ijk_iv_rotation);
            this.iv_fullscreen = (ImageView)rootView.findViewById(R.id.app_video_fullscreen);
            this.tv_steam = (TextView)rootView.findViewById(R.id.app_video_stream);
            this.tv_speed = (TextView)rootView.findViewById(R.id.app_video_speed);
            this.seekBar = (SeekBar)rootView.findViewById(R.id.app_video_seekBar);
        }
        this.seekBar.setMax(1000);
        this.seekBar.setOnSeekBarChangeListener(this.mSeekListener);
        this.iv_bar_player.setOnClickListener(this.onClickListener);
        this.iv_player.setOnClickListener(this.onClickListener);
        this.iv_fullscreen.setOnClickListener(this.onClickListener);
        this.iv_rotation.setOnClickListener(this.onClickListener);
        this.tv_steam.setOnClickListener(this.onClickListener);
        this.iv_back.setOnClickListener(this.onClickListener);
        this.iv_menu.setOnClickListener(this.onClickListener);
        this.query.id(R.id.app_video_netTie_icon).clicked(this.onClickListener);
        this.query.id(R.id.app_video_replay_icon).clicked(this.onClickListener);
        this.videoView.setOnInfoListener(new IMediaPlayer.OnInfoListener(){

            public boolean onInfo(IMediaPlayer mp, int what, int extra) {
                if (what == 703 || what == 503) {
                    Log.e((String)"", (String)("dou361.====extra=======" + extra));
                    if (PlayerView.this.tv_speed != null) {
                        PlayerView.this.tv_speed.setText((CharSequence)PlayerView.this.getFormatSize(extra));
                    }
                }
                PlayerView.this.statusChange(what);
                if (PlayerView.this.onInfoListener != null) {
                    PlayerView.this.onInfoListener.onInfo(mp, what, extra);
                }
                if (PlayerView.this.isCharge && PlayerView.this.maxPlaytime < PlayerView.this.getCurrentPosition()) {
                    PlayerView.this.query.id(R.id.app_video_freeTie).visible();
                    PlayerView.this.pausePlay();
                }
                return true;
            }
        });
        this.streamSelectAdapter = new StreamSelectAdapter(this.mContext, this.listVideos);
        this.streamSelectListView.setAdapter((ListAdapter)this.streamSelectAdapter);
        this.streamSelectListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PlayerView.this.hideStreamSelectView();
                if (PlayerView.this.currentSelect == position) {
                    return;
                }
                PlayerView.this.currentSelect = position;
                PlayerView.this.switchStream(position);
                for (int i = 0; i < PlayerView.this.listVideos.size(); ++i) {
                    if (i == position) {
                        ((VideoijkBean)PlayerView.this.listVideos.get(i)).setSelect(true);
                        continue;
                    }
                    ((VideoijkBean)PlayerView.this.listVideos.get(i)).setSelect(false);
                }
                PlayerView.this.streamSelectAdapter.notifyDataSetChanged();
                PlayerView.this.startPlay();
            }
        });
        final GestureDetector gestureDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new PlayerGestureListener());
        this.rl_box.setClickable(true);
        this.rl_box.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                switch (motionEvent.getAction() & 0xFF) {
                    case 0: {
                        if (PlayerView.this.mAutoPlayRunnable == null) break;
                        PlayerView.this.mAutoPlayRunnable.stop();
                    }
                }
                if (gestureDetector.onTouchEvent(motionEvent)) {
                    return true;
                }
                switch (motionEvent.getAction() & 0xFF) {
                    case 1: {
                        PlayerView.this.endGesture();
                    }
                }
                return false;
            }
        });
        this.orientationEventListener = new OrientationEventListener((Context)this.mActivity){

            public void onOrientationChanged(int orientation) {
                if (orientation >= 0 && orientation <= 30 || orientation >= 330 || orientation >= 150 && orientation <= 210) {
                    if (PlayerView.this.isPortrait) {
                        PlayerView.this.mActivity.setRequestedOrientation(4);
                        PlayerView.this.orientationEventListener.disable();
                    }
                } else if ((orientation >= 90 && orientation <= 120 || orientation >= 240 && orientation <= 300) && !PlayerView.this.isPortrait) {
                    PlayerView.this.mActivity.setRequestedOrientation(4);
                    PlayerView.this.orientationEventListener.disable();
                }
            }
        };
        if (this.isOnlyFullScreen) {
            this.mActivity.setRequestedOrientation(0);
        }
        this.isPortrait = this.getScreenOrientation() == 1;
        this.initHeight = this.rl_box.getLayoutParams().height;
        this.hideAll();
        if (!this.playerSupport) {
            this.showStatus(this.mActivity.getResources().getString(R.string.not_support));
        } else {
            this.query.id(R.id.ll_bg).visible();
        }
    }

    public PlayerView onPause() {
        this.bgState = this.videoView.isPlaying() ? 0 : 1;
        this.getCurrentPosition();
        this.videoView.onPause();
        return this;
    }

    public PlayerView onResume() {
        this.videoView.onResume();
        if (this.isLive) {
            this.videoView.seekTo(0);
        } else {
            this.videoView.seekTo(this.currentPosition);
        }
        if (this.bgState != 0) {
            this.pausePlay();
        }
        return this;
    }

    public PlayerView onDestroy() {
        this.orientationEventListener.disable();
        this.mHandler.removeMessages(5);
        this.mHandler.removeMessages(3);
        this.videoView.stopPlayback();
        return this;
    }

    public PlayerView onConfigurationChanged(Configuration newConfig) {
        this.isPortrait = newConfig.orientation == 1;
        this.doOnConfigurationChanged(this.isPortrait);
        return this;
    }

    public boolean onBackPressed() {
        if (!this.isOnlyFullScreen && this.getScreenOrientation() == 0) {
            this.mActivity.setRequestedOrientation(1);
            return true;
        }
        return false;
    }

    public PlayerView showThumbnail(OnShowThumbnailListener onShowThumbnailListener) {
        this.mOnShowThumbnailListener = onShowThumbnailListener;
        if (this.mOnShowThumbnailListener != null && this.iv_trumb != null) {
            this.mOnShowThumbnailListener.onShowThumbnail(this.iv_trumb);
        }
        return this;
    }

    public PlayerView setOnInfoListener(IMediaPlayer.OnInfoListener onInfoListener) {
        this.onInfoListener = onInfoListener;
        return this;
    }

    public PlayerView setPlayerBackListener(OnPlayerBackListener listener) {
        this.mPlayerBack = listener;
        return this;
    }

    public PlayerView setOnControlPanelVisibilityChangListenter(OnControlPanelVisibilityChangeListener listener) {
        this.onControlPanelVisibilityChangeListener = listener;
        return this;
    }

    public PlayerView toggleAspectRatio() {
        if (this.videoView != null) {
            this.videoView.toggleAspectRatio();
        }
        return this;
    }

    public PlayerView setScaleType(int showType) {
        this.currentShowType = showType;
        this.videoView.setAspectRatio(this.currentShowType);
        return this;
    }

    public PlayerView setPlayerRotation() {
        if (this.rotation == 0) {
            this.rotation = 90;
        } else if (this.rotation == 90) {
            this.rotation = 270;
        } else if (this.rotation == 270) {
            this.rotation = 0;
        }
        this.setPlayerRotation(this.rotation);
        return this;
    }

    public PlayerView setPlayerRotation(int rotation) {
        if (this.videoView != null) {
            this.videoView.setPlayerRotation(rotation);
            this.videoView.setAspectRatio(this.currentShowType);
        }
        return this;
    }

    public PlayerView setPlaySource(List<VideoijkBean> list) {
        this.listVideos.clear();
        if (list != null && list.size() > 0) {
            this.listVideos.addAll(list);
            this.switchStream(0);
        }
        return this;
    }

    public PlayerView setPlaySource(VideoijkBean videoijkBean) {
        this.listVideos.clear();
        if (videoijkBean != null) {
            this.listVideos.add(videoijkBean);
            this.switchStream(0);
        }
        return this;
    }

    public PlayerView setPlaySource(String stream, String url) {
        VideoijkBean mVideoijkBean = new VideoijkBean();
        mVideoijkBean.setStream(stream);
        mVideoijkBean.setUrl(url);
        this.setPlaySource(mVideoijkBean);
        return this;
    }

    public PlayerView setPlaySource(String url) {
        this.setPlaySource("\u6807\u6e05", url);
        return this;
    }

    public PlayerView autoPlay(String path) {
        this.setPlaySource(path);
        this.startPlay();
        return this;
    }

    public PlayerView startPlay() {
        if (this.isLive) {
            this.videoView.setVideoPath(this.currentUrl);
            this.videoView.seekTo(0);
        } else if (this.isHasSwitchStream || this.status == 331) {
            this.videoView.setRender(2);
            this.videoView.setVideoPath(this.currentUrl);
            this.videoView.seekTo(this.currentPosition);
            this.isHasSwitchStream = false;
        }
        this.hideStatusUI();
        if (this.isGNetWork && (NetworkUtils.getNetworkType(this.mContext) == 4 || NetworkUtils.getNetworkType(this.mContext) == 5 || NetworkUtils.getNetworkType(this.mContext) == 6)) {
            this.query.id(R.id.app_video_netTie).visible();
        } else if (this.isCharge && this.maxPlaytime < this.getCurrentPosition()) {
            this.query.id(R.id.app_video_freeTie).visible();
        } else if (this.playerSupport) {
            this.query.id(R.id.app_video_loading).visible();
            this.videoView.start();
        } else {
            this.showStatus(this.mActivity.getResources().getString(R.string.not_support));
        }
        return this;
    }

    public PlayerView setTitle(String title) {
        this.query.id(R.id.app_video_title).text(title);
        return this;
    }

    public PlayerView switchStream(int index) {
        if (this.listVideos.size() > index) {
            this.tv_steam.setText((CharSequence)this.listVideos.get(index).getStream());
            this.currentUrl = this.listVideos.get(index).getUrl();
            this.listVideos.get(index).setSelect(true);
            this.isLive();
            if (this.videoView.isPlaying()) {
                this.getCurrentPosition();
                this.videoView.release(false);
            }
            this.isHasSwitchStream = true;
        }
        return this;
    }

    public PlayerView pausePlay() {
        this.status = 335;
        this.getCurrentPosition();
        this.videoView.pause();
        return this;
    }

    public PlayerView stopPlay() {
        this.videoView.stopPlayback();
        this.isErrorStop = true;
        if (this.mHandler != null) {
            this.mHandler.removeMessages(5);
        }
        return this;
    }

    public PlayerView seekTo(int playtime) {
        this.videoView.seekTo(playtime);
        return this;
    }

    public int getCurrentPosition() {
        this.currentPosition = !this.isLive ? this.videoView.getCurrentPosition() : -1;
        return this.currentPosition;
    }

    public long getDuration() {
        this.duration = this.videoView.getDuration();
        return this.duration;
    }

    public PlayerView setNetWorkTypeTie(boolean isGNetWork) {
        this.isGNetWork = isGNetWork;
        return this;
    }

    public PlayerView setChargeTie(boolean isCharge, int maxPlaytime) {
        this.isCharge = isCharge;
        this.maxPlaytime = maxPlaytime * 1000;
        return this;
    }

    public PlayerView setOnlyFullScreen(boolean isFull) {
        this.isOnlyFullScreen = isFull;
        this.tryFullScreen(this.isOnlyFullScreen);
        if (this.isOnlyFullScreen) {
            this.mActivity.setRequestedOrientation(0);
        } else {
            this.mActivity.setRequestedOrientation(4);
        }
        return this;
    }

    public PlayerView setForbidDoulbeUp(boolean flag) {
        this.isForbidDoulbeUp = flag;
        return this;
    }

    public PlayerView setForbidHideControlPanl(boolean flag) {
        this.isForbidHideControlPanl = flag;
        return this;
    }

    public boolean isLive() {
        this.isLive = this.currentUrl != null && (this.currentUrl.startsWith("rtmp://") || this.currentUrl.startsWith("http://") && this.currentUrl.endsWith(".m3u8") || this.currentUrl.startsWith("http://") && this.currentUrl.endsWith(".flv"));
        return this.isLive;
    }

    public PlayerView forbidTouch(boolean forbidTouch) {
        this.isForbidTouch = forbidTouch;
        return this;
    }

    public PlayerView hideAllUI() {
        if (this.query != null) {
            this.hideAll();
        }
        return this;
    }

    public View getTopBarView() {
        return this.ll_topbar;
    }

    public View getBottonBarView() {
        return this.ll_bottombar;
    }

    public ImageView getRationView() {
        return this.iv_rotation;
    }

    public ImageView getBackView() {
        return this.iv_back;
    }

    public ImageView getMenuView() {
        return this.iv_menu;
    }

    public ImageView getFullScreenView() {
        return this.iv_fullscreen;
    }

    public ImageView getBarPlayerView() {
        return this.iv_bar_player;
    }

    public ImageView getPlayerView() {
        return this.iv_player;
    }

    public PlayerView hideBack(boolean isHide) {
        this.iv_back.setVisibility(isHide ? 8 : 0);
        return this;
    }

    public PlayerView hideMenu(boolean isHide) {
        this.iv_menu.setVisibility(isHide ? 8 : 0);
        return this;
    }

    public PlayerView hideSteam(boolean isHide) {
        this.tv_steam.setVisibility(isHide ? 8 : 0);
        return this;
    }

    public PlayerView hideRotation(boolean isHide) {
        this.iv_rotation.setVisibility(isHide ? 8 : 0);
        return this;
    }

    public PlayerView hideFullscreen(boolean isHide) {
        this.iv_fullscreen.setVisibility(isHide ? 8 : 0);
        return this;
    }

    public PlayerView hideCenterPlayer(boolean isHide) {
        this.isHideCenterPlayer = isHide;
        this.iv_player.setVisibility(this.isHideCenterPlayer ? 8 : 0);
        return this;
    }

    public PlayerView hideHideTopBar(boolean isHide) {
        this.isHideTopBar = isHide;
        this.ll_topbar.setVisibility(this.isHideTopBar ? 8 : 0);
        return this;
    }

    public PlayerView hideBottonBar(boolean isHide) {
        this.isHideBottonBar = isHide;
        this.ll_bottombar.setVisibility(this.isHideBottonBar ? 8 : 0);
        return this;
    }

    public PlayerView hideControlPanl(boolean isHide) {
        this.hideBottonBar(isHide);
        this.hideHideTopBar(isHide);
        return this;
    }

    public PlayerView setAutoReConnect(boolean isAuto, int connectTime) {
        this.isAutoReConnect = isAuto;
        this.autoConnectTime = connectTime;
        return this;
    }

    public PlayerView operatorPanl() {
        this.isShowControlPanl = !this.isShowControlPanl;
        this.query.id(R.id.simple_player_settings_container).gone();
        this.query.id(R.id.simple_player_select_stream_container).gone();
        if (this.isShowControlPanl) {
            this.ll_topbar.setVisibility(this.isHideTopBar ? 8 : 0);
            this.ll_bottombar.setVisibility(this.isHideBottonBar ? 8 : 0);
            if (this.isLive) {
                this.query.id(R.id.app_video_process_panl).invisible();
            } else {
                this.query.id(R.id.app_video_process_panl).visible();
            }
            if (this.isOnlyFullScreen || this.isForbidDoulbeUp) {
                this.iv_fullscreen.setVisibility(8);
            } else {
                this.iv_fullscreen.setVisibility(0);
            }
            if (this.onControlPanelVisibilityChangeListener != null) {
                this.onControlPanelVisibilityChangeListener.change(true);
            }
            if (this.status == 334 || this.status == 333 || this.status == 332 || this.status == 335) {
                if (this.isHideCenterPlayer) {
                    this.iv_player.setVisibility(8);
                } else {
                    this.iv_player.setVisibility(this.isLive ? 8 : 0);
                }
            } else {
                this.iv_player.setVisibility(8);
            }
            this.updatePausePlay();
            this.mHandler.sendEmptyMessage(1);
            this.mAutoPlayRunnable.start();
        } else {
            if (this.isHideTopBar) {
                this.ll_topbar.setVisibility(8);
            } else {
                this.ll_topbar.setVisibility(this.isForbidHideControlPanl ? 0 : 8);
            }
            if (this.isHideBottonBar) {
                this.ll_bottombar.setVisibility(8);
            } else {
                this.ll_bottombar.setVisibility(this.isForbidHideControlPanl ? 0 : 8);
            }
            if (!this.isLive && this.status == 335 && !this.videoView.isPlaying()) {
                if (this.isHideCenterPlayer) {
                    this.iv_player.setVisibility(8);
                } else {
                    this.iv_player.setVisibility(0);
                }
            } else {
                this.iv_player.setVisibility(8);
            }
            this.mHandler.removeMessages(1);
            if (this.onControlPanelVisibilityChangeListener != null) {
                this.onControlPanelVisibilityChangeListener.change(false);
            }
            this.mAutoPlayRunnable.stop();
        }
        return this;
    }

    public PlayerView toggleFullScreen() {
        if (this.getScreenOrientation() == 0) {
            this.mActivity.setRequestedOrientation(1);
        } else {
            this.mActivity.setRequestedOrientation(0);
        }
        this.updateFullScreenButton();
        return this;
    }

    public PlayerView showMenu() {
        this.volumeController.setProgress(this.audioManager.getStreamVolume(3) * 100 / this.mMaxVolume);
        this.brightnessController.setProgress((int)(this.mActivity.getWindow().getAttributes().screenBrightness * 100.0f));
        this.settingsContainer.setVisibility(0);
        if (!this.isForbidHideControlPanl) {
            this.ll_topbar.setVisibility(8);
            this.ll_bottombar.setVisibility(8);
        }
        return this;
    }

    public PlayerView toggleProcessDurationOrientation() {
        this.setProcessDurationOrientation(0);
        return this;
    }

    public PlayerView setShowSpeed(boolean isShow) {
        this.tv_speed.setVisibility(isShow ? 0 : 8);
        return this;
    }

    public PlayerView setProcessDurationOrientation(int portrait) {
        if (portrait == 2) {
            this.query.id(R.id.app_video_currentTime_full).gone();
            this.query.id(R.id.app_video_endTime_full).gone();
            this.query.id(R.id.app_video_center).gone();
            this.query.id(R.id.app_video_lift).visible();
        } else if (portrait == 1) {
            this.query.id(R.id.app_video_currentTime_full).visible();
            this.query.id(R.id.app_video_endTime_full).visible();
            this.query.id(R.id.app_video_center).gone();
            this.query.id(R.id.app_video_lift).gone();
        } else {
            this.query.id(R.id.app_video_currentTime_full).gone();
            this.query.id(R.id.app_video_endTime_full).gone();
            this.query.id(R.id.app_video_center).visible();
            this.query.id(R.id.app_video_lift).gone();
        }
        return this;
    }

    public int getScreenOrientation() {
        int orientation;
        int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 0: {
                    orientation = 1;
                    break;
                }
                case 1: {
                    orientation = 0;
                    break;
                }
                case 2: {
                    orientation = 9;
                    break;
                }
                case 3: {
                    orientation = 8;
                    break;
                }
                default: {
                    orientation = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 1: {
                    orientation = 1;
                    break;
                }
                case 2: {
                    orientation = 8;
                    break;
                }
                case 3: {
                    orientation = 9;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    private void statusChange(int newStatus) {
        if (newStatus == 336) {
            this.status = 336;
            this.currentPosition = 0;
            this.hideAll();
            this.showStatus("\u64ad\u653e\u7ed3\u675f");
        } else if (newStatus == 332 || newStatus == 701) {
            this.status = 332;
            this.hideStatusUI();
            this.query.id(R.id.app_video_loading).visible();
        } else if (newStatus == 3 || newStatus == 334 || newStatus == 333 || newStatus == 702 || newStatus == 335) {
            this.status = this.status == 335 ? 335 : 334;
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PlayerView.this.hideStatusUI();
                    PlayerView.this.isShowControlPanl = false;
                    if (!PlayerView.this.isForbidTouch) {
                        PlayerView.this.operatorPanl();
                    }
                    PlayerView.this.query.id(R.id.ll_bg).gone();
                }
            }, 500L);
        } else if (newStatus == -10000) {
            this.status = 331;
            if (!this.isGNetWork || NetworkUtils.getNetworkType(this.mContext) != 4 && NetworkUtils.getNetworkType(this.mContext) != 5 && NetworkUtils.getNetworkType(this.mContext) != 6) {
                if (this.isCharge && this.maxPlaytime < this.getCurrentPosition()) {
                    this.query.id(R.id.app_video_freeTie).visible();
                } else {
                    this.hideAll();
                    if (this.isLive) {
                        this.showStatus("\u83b7\u53d6\u4e0d\u5230\u76f4\u64ad\u6e90");
                    } else {
                        this.showStatus(this.mActivity.getResources().getString(R.string.small_problem));
                    }
                    if (!this.isErrorStop && this.isAutoReConnect) {
                        this.mHandler.sendEmptyMessageDelayed(5, (long)this.autoConnectTime);
                    }
                }
            } else {
                this.query.id(R.id.app_video_netTie).visible();
            }
        } else if (newStatus == 331 || newStatus == 1 || newStatus == -1004 || newStatus == -1007 || newStatus == -1010 || newStatus == -110 || newStatus == 100) {
            this.status = 331;
            if (!this.isGNetWork || NetworkUtils.getNetworkType(this.mContext) != 4 && NetworkUtils.getNetworkType(this.mContext) != 5 && NetworkUtils.getNetworkType(this.mContext) != 6) {
                if (this.isCharge && this.maxPlaytime < this.getCurrentPosition()) {
                    this.query.id(R.id.app_video_freeTie).visible();
                } else {
                    this.hideStatusUI();
                    if (this.isLive) {
                        this.showStatus(this.mActivity.getResources().getString(R.string.small_problem));
                    } else {
                        this.showStatus(this.mActivity.getResources().getString(R.string.small_problem));
                    }
                    if (!this.isErrorStop && this.isAutoReConnect) {
                        this.mHandler.sendEmptyMessageDelayed(5, (long)this.autoConnectTime);
                    }
                }
            } else {
                this.query.id(R.id.app_video_netTie).visible();
            }
        }
    }

    private void showStatus(String statusText) {
        this.query.id(R.id.app_video_replay).visible();
        this.query.id(R.id.app_video_status_text).text(statusText);
    }

    private void doOnConfigurationChanged(final boolean portrait) {
        if (this.videoView != null && !this.isOnlyFullScreen) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PlayerView.this.tryFullScreen(!portrait);
                    if (portrait) {
                        PlayerView.this.query.id(R.id.app_video_box).height(PlayerView.this.initHeight, false);
                    } else {
                        int heightPixels = ((PlayerView)PlayerView.this).mActivity.getResources().getDisplayMetrics().heightPixels;
                        int widthPixels = ((PlayerView)PlayerView.this).mActivity.getResources().getDisplayMetrics().widthPixels;
                        PlayerView.this.query.id(R.id.app_video_box).height(Math.min(heightPixels, widthPixels), false);
                    }
                    PlayerView.this.updateFullScreenButton();
                }
            });
            this.orientationEventListener.enable();
        }
    }

    private void setFullScreen(boolean fullScreen) {
        if (this.mActivity != null) {
            WindowManager.LayoutParams attrs = this.mActivity.getWindow().getAttributes();
            if (fullScreen) {
                attrs.flags |= 0x400;
                this.mActivity.getWindow().setAttributes(attrs);
                this.mActivity.getWindow().addFlags(512);
            } else {
                attrs.flags &= 0xFFFFFBFF;
                this.mActivity.getWindow().setAttributes(attrs);
                this.mActivity.getWindow().clearFlags(512);
            }
            this.toggleProcessDurationOrientation();
        }
    }

    private void tryFullScreen(boolean fullScreen) {
        ActionBar supportActionBar;
        if (this.mActivity instanceof AppCompatActivity && (supportActionBar = ((AppCompatActivity)this.mActivity).getSupportActionBar()) != null) {
            if (fullScreen) {
                supportActionBar.hide();
            } else {
                supportActionBar.show();
            }
        }
        this.setFullScreen(fullScreen);
    }

    private void hideStatusUI() {
        this.iv_player.setVisibility(8);
        this.query.id(R.id.simple_player_settings_container).gone();
        this.query.id(R.id.simple_player_select_stream_container).gone();
        this.query.id(R.id.app_video_replay).gone();
        this.query.id(R.id.app_video_netTie).gone();
        this.query.id(R.id.app_video_freeTie).gone();
        this.query.id(R.id.app_video_loading).gone();
        if (this.onControlPanelVisibilityChangeListener != null) {
            this.onControlPanelVisibilityChangeListener.change(false);
        }
    }

    private void hideAll() {
        if (!this.isForbidHideControlPanl) {
            this.ll_topbar.setVisibility(8);
            this.ll_bottombar.setVisibility(8);
        }
        this.hideStatusUI();
    }

    private void showStreamSelectView() {
        this.streamSelectView.setVisibility(0);
        if (!this.isForbidHideControlPanl) {
            this.ll_topbar.setVisibility(8);
            this.ll_bottombar.setVisibility(8);
        }
        this.streamSelectListView.setItemsCanFocus(true);
    }

    private void hideStreamSelectView() {
        this.streamSelectView.setVisibility(8);
    }

    private void endGesture() {
        this.volume = -1;
        this.brightness = -1.0f;
        if (this.newPosition >= 0L) {
            this.mHandler.removeMessages(3);
            this.mHandler.sendEmptyMessage(3);
        }
        this.mHandler.removeMessages(4);
        this.mHandler.sendEmptyMessageDelayed(4, 500L);
        if (this.mAutoPlayRunnable != null) {
            this.mAutoPlayRunnable.start();
        }
    }

    private long syncProgress() {
        if (this.isDragging) {
            return 0L;
        }
        long position = this.videoView.getCurrentPosition();
        long duration = this.videoView.getDuration();
        if (this.seekBar != null) {
            if (duration > 0L) {
                long pos = 1000L * position / duration;
                this.seekBar.setProgress((int)pos);
            }
            int percent = this.videoView.getBufferPercentage();
            this.seekBar.setSecondaryProgress(percent * 10);
        }
        if (this.isCharge && this.maxPlaytime + 1000 < this.getCurrentPosition()) {
            this.query.id(R.id.app_video_freeTie).visible();
            this.pausePlay();
        } else {
            this.query.id(R.id.app_video_currentTime).text(this.generateTime(position));
            this.query.id(R.id.app_video_currentTime_full).text(this.generateTime(position));
            this.query.id(R.id.app_video_currentTime_left).text(this.generateTime(position));
            this.query.id(R.id.app_video_endTime).text(this.generateTime(duration));
            this.query.id(R.id.app_video_endTime_full).text(this.generateTime(duration));
            this.query.id(R.id.app_video_endTime_left).text(this.generateTime(duration));
        }
        return position;
    }

    private String generateTime(long time) {
        int totalSeconds = (int)(time / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
    }

    private String getFormatSize(int size) {
        long fileSize = size;
        String showSize = "";
        if (fileSize >= 0L && fileSize < 1024L) {
            showSize = fileSize + "Kb/s";
        } else if (fileSize >= 1024L && fileSize < 0x100000L) {
            showSize = Long.toString(fileSize / 1024L) + "KB/s";
        } else if (fileSize >= 0x100000L && fileSize < 0x40000000L) {
            showSize = Long.toString(fileSize / 0x100000L) + "MB/s";
        }
        return showSize;
    }

    private void updatePausePlay() {
        if (this.videoView.isPlaying()) {
            if (this.isLive) {
                this.iv_bar_player.setImageResource(R.drawable.simple_player_stop_white_24dp);
            } else {
                this.iv_bar_player.setImageResource(R.drawable.simple_player_icon_media_pause);
                this.iv_player.setImageResource(R.drawable.simple_player_center_pause);
            }
        } else {
            this.iv_bar_player.setImageResource(R.drawable.simple_player_arrow_white_24dp);
            this.iv_player.setImageResource(R.drawable.simple_player_center_play);
        }
    }

    private void updateFullScreenButton() {
        if (this.getScreenOrientation() == 0) {
            this.iv_fullscreen.setImageResource(R.drawable.simple_player_icon_fullscreen_shrink);
        } else {
            this.iv_fullscreen.setImageResource(R.drawable.simple_player_icon_fullscreen_stretch);
        }
    }

    private void onVolumeSlide(float percent) {
        int index;
        if (this.volume == -1) {
            this.volume = this.audioManager.getStreamVolume(3);
            if (this.volume < 0) {
                this.volume = 0;
            }
        }
        if ((index = (int)(percent * (float)this.mMaxVolume) + this.volume) > this.mMaxVolume) {
            index = this.mMaxVolume;
        } else if (index < 0) {
            index = 0;
        }
        this.audioManager.setStreamVolume(3, index, 0);
        int i = (int)((double)index * 1.0 / (double)this.mMaxVolume * 100.0);
        String s = i + "%";
        if (i == 0) {
            s = "off";
        }
        this.query.id(R.id.app_video_volume_icon).image(i == 0 ? R.drawable.simple_player_volume_off_white_36dp : R.drawable.simple_player_volume_up_white_36dp);
        this.query.id(R.id.app_video_brightness_box).gone();
        this.query.id(R.id.app_video_volume_box).visible();
        this.query.id(R.id.app_video_volume_box).visible();
        this.query.id(R.id.app_video_volume).text(s).visible();
    }

    private void onProgressSlide(float percent) {
        int position = this.videoView.getCurrentPosition();
        long duration = this.videoView.getDuration();
        long deltaMax = Math.min(100000L, duration - (long)position);
        long delta = (long)((float)deltaMax * percent);
        this.newPosition = delta + (long)position;
        if (this.newPosition > duration) {
            this.newPosition = duration;
        } else if (this.newPosition <= 0L) {
            this.newPosition = 0L;
            delta = -position;
        }
        int showDelta = (int)delta / 1000;
        if (showDelta != 0) {
            this.query.id(R.id.app_video_fastForward_box).visible();
            String text = showDelta > 0 ? "+" + showDelta : "" + showDelta;
            this.query.id(R.id.app_video_fastForward).text(text + "s");
            this.query.id(R.id.app_video_fastForward_target).text(this.generateTime(this.newPosition) + "/");
            this.query.id(R.id.app_video_fastForward_all).text(this.generateTime(duration));
        }
    }

    private void onBrightnessSlide(float percent) {
        if (this.brightness < 0.0f) {
            this.brightness = this.mActivity.getWindow().getAttributes().screenBrightness;
            if (this.brightness <= 0.0f) {
                this.brightness = 0.5f;
            } else if (this.brightness < 0.01f) {
                this.brightness = 0.01f;
            }
        }
        Log.d((String)this.getClass().getSimpleName(), (String)("brightness:" + this.brightness + ",percent:" + percent));
        this.query.id(R.id.app_video_brightness_box).visible();
        WindowManager.LayoutParams lpa = this.mActivity.getWindow().getAttributes();
        lpa.screenBrightness = this.brightness + percent;
        if (lpa.screenBrightness > 1.0f) {
            lpa.screenBrightness = 1.0f;
        } else if (lpa.screenBrightness < 0.01f) {
            lpa.screenBrightness = 0.01f;
        }
        this.query.id(R.id.app_video_brightness).text((int)(lpa.screenBrightness * 100.0f) + "%");
        this.mActivity.getWindow().setAttributes(lpa);
    }

    public class PlayerGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private boolean isDownTouch;
        private boolean isVolume;
        private boolean isLandscape;

        public boolean onDoubleTap(MotionEvent e) {
            if (!(PlayerView.this.isForbidTouch || PlayerView.this.isOnlyFullScreen || PlayerView.this.isForbidDoulbeUp)) {
                PlayerView.this.toggleFullScreen();
            }
            return true;
        }

        public boolean onDown(MotionEvent e) {
            this.isDownTouch = true;
            return super.onDown(e);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!PlayerView.this.isForbidTouch) {
                float mOldX = e1.getX();
                float mOldY = e1.getY();
                float deltaY = mOldY - e2.getY();
                float deltaX = mOldX - e2.getX();
                if (this.isDownTouch) {
                    this.isLandscape = Math.abs(distanceX) >= Math.abs(distanceY);
                    this.isVolume = mOldX > (float)PlayerView.this.screenWidthPixels * 0.5f;
                    this.isDownTouch = false;
                }
                if (this.isLandscape) {
                    if (!PlayerView.this.isLive) {
                        PlayerView.this.onProgressSlide(-deltaX / (float)PlayerView.this.videoView.getWidth());
                    }
                } else {
                    float percent = deltaY / (float)PlayerView.this.videoView.getHeight();
                    if (this.isVolume) {
                        PlayerView.this.onVolumeSlide(percent);
                    } else {
                        PlayerView.this.onBrightnessSlide(percent);
                    }
                }
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (!PlayerView.this.isForbidTouch) {
                PlayerView.this.operatorPanl();
            }
            return true;
        }
    }

    private class AutoPlayRunnable
    implements Runnable {
        private int AUTO_PLAY_INTERVAL = 5000;
        private boolean mShouldAutoPlay = false;

        public void start() {
            if (!this.mShouldAutoPlay) {
                this.mShouldAutoPlay = true;
                PlayerView.this.mHandler.removeCallbacks((Runnable)this);
                PlayerView.this.mHandler.postDelayed((Runnable)this, (long)this.AUTO_PLAY_INTERVAL);
            }
        }

        public void stop() {
            if (this.mShouldAutoPlay) {
                PlayerView.this.mHandler.removeCallbacks((Runnable)this);
                this.mShouldAutoPlay = false;
            }
        }

        @Override
        public void run() {
            if (this.mShouldAutoPlay) {
                PlayerView.this.mHandler.removeCallbacks((Runnable)this);
                if (!PlayerView.this.isForbidTouch && !PlayerView.this.isShowControlPanl) {
                    PlayerView.this.operatorPanl();
                }
            }
        }
    }
}

