/*
 * Decompiled with CFR 0.152.
 */
package com.dou361.ijkplayer.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class LayoutQuery {
    private Context context;
    private Activity activity;
    private View rootView;
    private View view;

    public LayoutQuery(Context context, View view) {
        this.context = context;
        this.rootView = view;
    }

    public LayoutQuery(Activity activity) {
        this.context = activity;
        this.activity = activity;
    }

    public LayoutQuery id(int id2) {
        this.view = this.rootView == null ? this.activity.findViewById(id2) : this.rootView.findViewById(id2);
        return this;
    }

    public LayoutQuery image(int resId) {
        if (this.view instanceof ImageView) {
            ((ImageView)this.view).setImageResource(resId);
        }
        return this;
    }

    public LayoutQuery visible() {
        if (this.view != null) {
            this.view.setVisibility(0);
        }
        return this;
    }

    public LayoutQuery gone() {
        if (this.view != null) {
            this.view.setVisibility(8);
        }
        return this;
    }

    public LayoutQuery invisible() {
        if (this.view != null) {
            this.view.setVisibility(4);
        }
        return this;
    }

    public LayoutQuery clicked(View.OnClickListener handler) {
        if (this.view != null) {
            this.view.setOnClickListener(handler);
        }
        return this;
    }

    public LayoutQuery text(CharSequence text) {
        if (this.view != null && this.view instanceof TextView) {
            ((TextView)this.view).setText(text);
        }
        return this;
    }

    public LayoutQuery visibility(int visible) {
        if (this.view != null) {
            this.view.setVisibility(visible);
        }
        return this;
    }

    private void size(boolean width, int n, boolean dip) {
        if (this.view != null) {
            ViewGroup.LayoutParams lp = this.view.getLayoutParams();
            if (n > 0 && dip) {
                n = this.dip2pixel(this.context, n);
            }
            if (width) {
                lp.width = n;
            } else {
                lp.height = n;
            }
            this.view.setLayoutParams(lp);
        }
    }

    public void height(int height, boolean dip) {
        this.size(false, height, dip);
    }

    public int dip2pixel(Context context, float n) {
        int value = (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return value;
    }

    public float pixel2dip(Context context, float n) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = n / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }
}

