/*
 * Decompiled with CFR 0.152.
 */
package com.dou361.ijkplayer.widget;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import com.dou361.ijkplayer.widget.FileMediaDataSource;
import com.dou361.ijkplayer.widget.IMediaController;
import com.dou361.ijkplayer.widget.IRenderView;
import com.dou361.ijkplayer.widget.SurfaceRenderView;
import com.dou361.ijkplayer.widget.TextureRenderView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.TextureMediaPlayer;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

public class IjkVideoView
extends FrameLayout
implements MediaController.MediaPlayerControl {
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private Uri mUri;
    private Map<String, String> mHeaders;
    private int mCurrentState = 330;
    private int mTargetState = 330;
    private IRenderView.ISurfaceHolder mSurfaceHolder = null;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoRotationDegree;
    private IMediaPlayer mMediaPlayer;
    private IMediaController mMediaController;
    private IMediaPlayer.OnCompletionListener mOnCompletionListener;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private IMediaPlayer.OnErrorListener mOnErrorListener;
    private IMediaPlayer.OnInfoListener mOnInfoListener;
    private long mSeekWhenPrepared;
    private boolean mCanPause = true;
    private Context mAppContext;
    private IRenderView mRenderView;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private boolean usingAndroidPlayer = false;
    private boolean usingMediaCodec = false;
    private boolean usingMediaCodecAutoRotate = false;
    private boolean usingOpenSLES = false;
    private String pixelFormat = "";
    private boolean enableBackgroundPlay = false;
    IMediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sarNum, int sarDen) {
            IjkVideoView.this.mVideoWidth = mp.getVideoWidth();
            IjkVideoView.this.mVideoHeight = mp.getVideoHeight();
            IjkVideoView.this.mVideoSarNum = mp.getVideoSarNum();
            IjkVideoView.this.mVideoSarDen = mp.getVideoSarDen();
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                }
                IjkVideoView.this.requestLayout();
            }
        }
    };
    IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            IjkVideoView.this.mCurrentState = 333;
            if (IjkVideoView.this.mOnPreparedListener != null) {
                IjkVideoView.this.mOnPreparedListener.onPrepared(IjkVideoView.this.mMediaPlayer);
            }
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.setEnabled(true);
            }
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(IjkVideoView.this.mMediaPlayer, IjkVideoView.this.mCurrentState, 0);
            }
            IjkVideoView.this.mVideoWidth = mp.getVideoWidth();
            IjkVideoView.this.mVideoHeight = mp.getVideoHeight();
            long seekToPosition = IjkVideoView.this.mSeekWhenPrepared;
            if (seekToPosition != 0L) {
                IjkVideoView.this.seekTo((int)seekToPosition);
            }
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                    if (!IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mSurfaceWidth == IjkVideoView.this.mVideoWidth && IjkVideoView.this.mSurfaceHeight == IjkVideoView.this.mVideoHeight) {
                        if (IjkVideoView.this.mTargetState == 334) {
                            IjkVideoView.this.start();
                            if (IjkVideoView.this.mMediaController != null) {
                                IjkVideoView.this.mMediaController.show();
                            }
                        } else if (!(IjkVideoView.this.isPlaying() || seekToPosition == 0L && IjkVideoView.this.getCurrentPosition() <= 0 || IjkVideoView.this.mMediaController == null)) {
                            IjkVideoView.this.mMediaController.show(0);
                        }
                    }
                }
            } else if (IjkVideoView.this.mTargetState == 334) {
                IjkVideoView.this.start();
            }
        }
    };
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            IjkVideoView.this.mCurrentState = 336;
            IjkVideoView.this.mTargetState = 336;
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnCompletionListener != null) {
                IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
            }
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(IjkVideoView.this.mMediaPlayer, 336, 0);
            }
        }
    };
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int arg1, int arg2) {
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(mp, arg1, arg2);
            }
            switch (arg1) {
                case 700: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_VIDEO_TRACK_LAGGING:");
                    break;
                }
                case 3: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_VIDEO_RENDERING_START:");
                    break;
                }
                case 701: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BUFFERING_START:");
                    break;
                }
                case 702: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BUFFERING_END:");
                    break;
                }
                case 703: {
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_NETWORK_BANDWIDTH: " + arg2));
                    break;
                }
                case 800: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BAD_INTERLEAVING:");
                    break;
                }
                case 801: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_NOT_SEEKABLE:");
                    break;
                }
                case 802: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_METADATA_UPDATE:");
                    break;
                }
                case 901: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_UNSUPPORTED_SUBTITLE:");
                    break;
                }
                case 902: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_SUBTITLE_TIMED_OUT:");
                    break;
                }
                case 10001: {
                    IjkVideoView.this.mVideoRotationDegree = arg2;
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + arg2));
                    if (IjkVideoView.this.mRenderView == null) break;
                    IjkVideoView.this.mRenderView.setVideoRotation(arg2);
                    break;
                }
                case 10002: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_AUDIO_RENDERING_START:");
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int framework_err, int impl_err) {
            Log.d((String)IjkVideoView.this.TAG, (String)("Error: " + framework_err + "," + impl_err));
            IjkVideoView.this.mCurrentState = 331;
            IjkVideoView.this.mTargetState = 331;
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnErrorListener != null) {
                IjkVideoView.this.mOnErrorListener.onError(IjkVideoView.this.mMediaPlayer, framework_err, impl_err);
            }
            if (IjkVideoView.this.mOnInfoListener != null && IjkVideoView.this.mOnInfoListener.onInfo(IjkVideoView.this.mMediaPlayer, framework_err, 0)) {
                return true;
            }
            if (IjkVideoView.this.getWindowToken() != null) {
                Resources r = IjkVideoView.this.mAppContext.getResources();
                String message = "Unknown error";
                if (framework_err == 200) {
                    message = "Invalid progressive playback";
                }
                new AlertDialog.Builder(IjkVideoView.this.getContext()).setMessage((CharSequence)message).setPositiveButton((CharSequence)"error", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (IjkVideoView.this.mOnCompletionListener != null) {
                            IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
            }
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer mp, int percent) {
            IjkVideoView.this.mCurrentBufferPercentage = percent;
        }
    };
    IRenderView.IRenderCallback mSHCallback = new IRenderView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(@NonNull IRenderView.ISurfaceHolder holder, int format, int w, int h) {
            boolean hasValidSize;
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceChanged: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceWidth = w;
            IjkVideoView.this.mSurfaceHeight = h;
            boolean isValidState = IjkVideoView.this.mTargetState == 334;
            boolean bl = hasValidSize = !IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mVideoWidth == w && IjkVideoView.this.mVideoHeight == h;
            if (IjkVideoView.this.mMediaPlayer != null && isValidState && hasValidSize) {
                if (IjkVideoView.this.mSeekWhenPrepared != 0L) {
                    IjkVideoView.this.seekTo((int)IjkVideoView.this.mSeekWhenPrepared);
                }
                IjkVideoView.this.start();
            }
        }

        @Override
        public void onSurfaceCreated(@NonNull IRenderView.ISurfaceHolder holder, int width, int height) {
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceCreated: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = holder;
            if (IjkVideoView.this.mMediaPlayer != null) {
                IjkVideoView.this.bindSurfaceHolder(IjkVideoView.this.mMediaPlayer, holder);
            } else {
                IjkVideoView.this.openVideo();
            }
        }

        @Override
        public void onSurfaceDestroyed(@NonNull IRenderView.ISurfaceHolder holder) {
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = null;
            IjkVideoView.this.releaseWithoutStop();
        }
    };
    private static final int[] s_allAspectRatio = new int[]{0, 1, 2, 3, 4, 5};
    private int mCurrentAspectRatioIndex = 0;
    private int mCurrentAspectRatio = s_allAspectRatio[this.mCurrentAspectRatioIndex];
    public static final int RENDER_SURFACE_VIEW = 1;
    public static final int RENDER_TEXTURE_VIEW = 2;
    private List<Integer> mAllRenders = new ArrayList<Integer>();
    private int mCurrentRenderIndex = 0;
    private int mCurrentRender = 1;

    public IjkVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView(context);
    }

    @TargetApi(value=21)
    public IjkVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initVideoView(context);
    }

    private void initVideoView(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.initBackground();
        this.initRenders();
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 330;
        this.mTargetState = 330;
    }

    public void setRenderView(IRenderView renderView) {
        View renderUIView;
        if (this.mRenderView != null) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setDisplay(null);
            }
            renderUIView = this.mRenderView.getView();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView = null;
            this.removeView(renderUIView);
        }
        if (renderView == null) {
            return;
        }
        this.mRenderView = renderView;
        renderView.setAspectRatio(this.mCurrentAspectRatio);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            renderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            renderView.setVideoSampleAspectRatio(this.mVideoSarNum, this.mVideoSarDen);
        }
        renderUIView = this.mRenderView.getView();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2, 17);
        renderUIView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView(renderUIView);
        this.mRenderView.addRenderCallback(this.mSHCallback);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setPlayerRotation(int rotation) {
        this.mVideoRotationDegree = rotation;
        if (this.mRenderView != null) {
            this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
        }
    }

    public void setRender(int render) {
        switch (render) {
            case 2: {
                TextureRenderView renderView = new TextureRenderView(this.getContext());
                if (this.mMediaPlayer != null) {
                    renderView.getSurfaceHolder().bindToMediaPlayer(this.mMediaPlayer);
                    renderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                    renderView.setVideoSampleAspectRatio(this.mMediaPlayer.getVideoSarNum(), this.mMediaPlayer.getVideoSarDen());
                    renderView.setAspectRatio(this.mCurrentAspectRatio);
                }
                this.setRenderView(renderView);
                break;
            }
            case 1: {
                SurfaceRenderView renderView = new SurfaceRenderView(this.getContext());
                this.setRenderView(renderView);
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)String.format(Locale.getDefault(), "invalid render %d\n", render));
            }
        }
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    private void setVideoURI(Uri uri, Map<String, String> headers) {
        this.mUri = uri;
        this.mHeaders = headers;
        this.mSeekWhenPrepared = 0L;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 330;
            this.mTargetState = 330;
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        this.release(false);
        AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
        am.requestAudioFocus(null, 3, 1);
        try {
            if (this.usingAndroidPlayer) {
                this.mMediaPlayer = new AndroidMediaPlayer();
            } else {
                IjkMediaPlayer ijkMediaPlayer = null;
                if (this.mUri != null) {
                    ijkMediaPlayer = new IjkMediaPlayer();
                    IjkMediaPlayer.native_setLogLevel((int)3);
                    if (this.usingMediaCodec) {
                        ijkMediaPlayer.setOption(4, "mediacodec", 1L);
                        if (this.usingMediaCodecAutoRotate) {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
                        } else {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 0L);
                        }
                    } else {
                        ijkMediaPlayer.setOption(4, "mediacodec", 0L);
                    }
                    if (this.usingOpenSLES) {
                        ijkMediaPlayer.setOption(4, "opensles", 1L);
                    } else {
                        ijkMediaPlayer.setOption(4, "opensles", 0L);
                    }
                    if (TextUtils.isEmpty((CharSequence)this.pixelFormat)) {
                        ijkMediaPlayer.setOption(4, "overlay-format", 842225234L);
                    } else {
                        ijkMediaPlayer.setOption(4, "overlay-format", this.pixelFormat);
                    }
                    ijkMediaPlayer.setOption(4, "framedrop", 1L);
                    ijkMediaPlayer.setOption(4, "start-on-prepared", 0L);
                    ijkMediaPlayer.setOption(1, "http-detect-range-support", 0L);
                    ijkMediaPlayer.setOption(1, "timeout", 10000000L);
                    ijkMediaPlayer.setOption(1, "reconnect", 1L);
                    ijkMediaPlayer.setOption(2, "skip_loop_filter", 48L);
                }
                this.mMediaPlayer = ijkMediaPlayer;
            }
            if (this.enableBackgroundPlay) {
                this.mMediaPlayer = new TextureMediaPlayer(this.mMediaPlayer);
            }
            Context context = this.getContext();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            String scheme = this.mUri.getScheme();
            if (Build.VERSION.SDK_INT >= 23 && this.usingAndroidPlayer && (TextUtils.isEmpty((CharSequence)scheme) || scheme.equalsIgnoreCase("file"))) {
                FileMediaDataSource dataSource = new FileMediaDataSource(new File(this.mUri.toString()));
                this.mMediaPlayer.setDataSource((IMediaDataSource)dataSource);
            } else if (Build.VERSION.SDK_INT > 14) {
                this.mMediaPlayer.setDataSource(this.mAppContext, this.mUri, this.mHeaders);
            } else {
                this.mMediaPlayer.setDataSource(this.mUri.toString());
            }
            this.bindSurfaceHolder(this.mMediaPlayer, this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 332;
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            this.mCurrentState = 331;
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            this.mCurrentState = 331;
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
    }

    public void setMediaController(IMediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            IjkVideoView anchorView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)anchorView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private void bindSurfaceHolder(IMediaPlayer mp, IRenderView.ISurfaceHolder holder) {
        if (mp == null) {
            return;
        }
        if (holder == null) {
            mp.setDisplay(null);
            return;
        }
        holder.bindToMediaPlayer(mp);
    }

    public void releaseWithoutStop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDisplay(null);
        }
    }

    public void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 330;
            if (cleartargetstate) {
                this.mTargetState = 330;
            }
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 334;
        }
        this.mTargetState = 334;
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 335;
        }
        this.mTargetState = 335;
    }

    public void onPause() {
        this.release(false);
    }

    public void onResume() {
        this.openVideo();
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo((long)msec);
            this.mSeekWhenPrepared = 0L;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != 331 && this.mCurrentState != 330 && this.mCurrentState != 332;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return false;
    }

    public boolean canSeekForward() {
        return false;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int toggleAspectRatio() {
        ++this.mCurrentAspectRatioIndex;
        this.mCurrentAspectRatioIndex %= s_allAspectRatio.length;
        this.mCurrentAspectRatio = s_allAspectRatio[this.mCurrentAspectRatioIndex];
        if (this.mRenderView != null) {
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
        }
        return this.mCurrentAspectRatio;
    }

    private void initRenders() {
        this.mAllRenders.clear();
        this.mAllRenders.add(1);
        if (Build.VERSION.SDK_INT >= 14) {
            this.mAllRenders.add(2);
            this.mCurrentRenderIndex = 1;
        } else {
            this.mCurrentRenderIndex = 0;
        }
        this.mCurrentRender = this.mAllRenders.get(this.mCurrentRenderIndex);
        this.setRender(this.mCurrentRender);
    }

    private void initBackground() {
        if (this.enableBackgroundPlay) {
            // empty if block
        }
    }

    public void setAspectRatio(int aspectRatio) {
        for (int i = 0; i < s_allAspectRatio.length; ++i) {
            if (s_allAspectRatio[i] != aspectRatio) continue;
            this.mCurrentAspectRatioIndex = i;
            if (this.mRenderView == null) break;
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
            break;
        }
    }
}

