/*
 * Decompiled with CFR 0.152.
 */
package com.dou361.ijkplayer.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.WindowManager;

public class ResourceUtils {
    private static final String TAG = ResourceUtils.class.getSimpleName();

    public static boolean isRunInMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    private ResourceUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int getResourceIdByName(Context context, String className, String name) {
        int id2 = 0;
        if (context == null) {
            return id2;
        }
        String packageName = context.getPackageName();
        try {
            String var10 = packageName + ".R$" + className;
            Class<?> desireClass = Class.forName(var10);
            if (desireClass != null) {
                id2 = desireClass.getField(name).getInt(desireClass);
            }
        }
        catch (ClassNotFoundException var7) {
            Log.d((String)"dou361", (String)("ClassNotFoundException: class=" + className + " fieldname=" + name));
        }
        catch (IllegalArgumentException var8) {
            Log.d((String)"dou361", (String)("IllegalArgumentException: class=" + className + " fieldname=" + name));
        }
        catch (SecurityException var9) {
            Log.d((String)"dou361", (String)("SecurityException: class=" + className + " fieldname=" + name));
        }
        catch (IllegalAccessException var101) {
            Log.d((String)"dou361", (String)("IllegalAccessException: class=" + className + " fieldname=" + name));
        }
        catch (NoSuchFieldException var11) {
            Log.d((String)"dou361", (String)("NoSuchFieldException: class=" + className + " fieldname=" + name));
        }
        return id2;
    }

    public static TypedArray getTypedArray(Context context, AttributeSet attrs, String name) {
        TypedArray typedArray = null;
        String className = "styleable";
        if (context == null) {
            return null;
        }
        String packageName = context.getPackageName();
        try {
            String var10 = packageName + ".R$" + className;
            Class<?> desireClass = Class.forName(var10);
            if (desireClass != null) {
                int[] ids = (int[])desireClass.getField(name).get(desireClass);
                typedArray = context.obtainStyledAttributes(attrs, ids);
            }
        }
        catch (ClassNotFoundException var7) {
            Log.d((String)"dou361", (String)("ClassNotFoundException: class=" + className + " fieldname=" + name));
        }
        catch (IllegalArgumentException var8) {
            Log.d((String)"dou361", (String)("IllegalArgumentException: class=" + className + " fieldname=" + name));
        }
        catch (SecurityException var9) {
            Log.d((String)"dou361", (String)("SecurityException: class=" + className + " fieldname=" + name));
        }
        catch (IllegalAccessException var101) {
            Log.d((String)"dou361", (String)("IllegalAccessException: class=" + className + " fieldname=" + name));
        }
        catch (NoSuchFieldException var11) {
            Log.d((String)"dou361", (String)("NoSuchFieldException: class=" + className + " fieldname=" + name));
        }
        return typedArray;
    }

    public static int dip2px(Context context, int dip) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f);
    }

    public static int getScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay().getWidth();
    }
}

