/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.scales;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import com.anychart.enums.Interval;
import com.anychart.scales.calendar.Availability;
import java.util.Arrays;
import java.util.Locale;

public class Calendar
extends Base {
    protected Calendar() {
    }

    public static Calendar instantiate() {
        return new Calendar("new anychart.scales.calendar()");
    }

    public Calendar(String jsChart) {
        this.jsBase = "calendar" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void availabilities() {
        APIlib.getInstance().addJSLine(this.jsBase + ".availabilities();");
    }

    public Calendar availabilities(Availability[] availabilities) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".availabilities(%s);", Calendar.arrayToString(availabilities)));
        return this;
    }

    public void getWorkingSchedule(Number startDate, Number endDate, Interval unit, Number count) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getWorkingSchedule(%s, %s, %s, %s);", startDate, endDate, unit != null ? unit.getJsBase() : null, count));
    }

    public void getWorkingSchedule(Number startDate, Number endDate, String unit, Number count) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getWorkingSchedule(%s, %s, %s, %s);", startDate, endDate, Calendar.wrapQuotes(unit), count));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Calendar.wrapQuotes(type)));
    }

    public void timezoneOffset() {
        APIlib.getInstance().addJSLine(this.jsBase + ".timezoneOffset();");
    }

    public Calendar timezoneOffset(Number var_offset) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".timezoneOffset(%s);", var_offset));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Calendar.wrapQuotes(key)));
    }

    public void weekendRange() {
        APIlib.getInstance().addJSLine(this.jsBase + ".weekendRange();");
    }

    public Calendar weekendRange(Number[] var_range) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".weekendRange(%s);", Arrays.toString(var_range)));
        return this;
    }
}

