/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.gantt.rendering;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import java.util.Locale;

public class Settings
extends Base {
    protected Settings() {
    }

    public static Settings instantiate() {
        return new Settings("new anychart.core.gantt.rendering.settings()");
    }

    public Settings(String jsChart) {
        this.jsBase = "settings" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void drawer() {
        APIlib.getInstance().addJSLine(this.jsBase + ".drawer();");
    }

    public Settings drawer(String drawerFunction) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drawer(%s);", Settings.wrapQuotes(drawerFunction)));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Settings.wrapQuotes(type)));
    }

    public void shapes() {
        APIlib.getInstance().addJSLine(this.jsBase + ".shapes();");
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Settings.wrapQuotes(key)));
    }
}

