/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.charts;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Chart;
import com.anychart.core.NoDataSettings;
import com.anychart.core.SeparateChart;
import com.anychart.core.annotations.ChartController;
import com.anychart.core.stock.Grouping;
import com.anychart.core.stock.Plot;
import com.anychart.core.stock.Scroller;
import com.anychart.core.stock.eventmarkers.Controller;
import com.anychart.core.stock.grouping.Level;
import com.anychart.core.ui.Background;
import com.anychart.core.ui.ChartCredits;
import com.anychart.core.ui.Crosshair;
import com.anychart.core.ui.Label;
import com.anychart.core.ui.Title;
import com.anychart.core.ui.Tooltip;
import com.anychart.core.utils.Animation;
import com.anychart.core.utils.Bounds;
import com.anychart.core.utils.ChartA11y;
import com.anychart.core.utils.Exports;
import com.anychart.core.utils.Margin;
import com.anychart.core.utils.Padding;
import com.anychart.core.utils.StockInteractivity;
import com.anychart.enums.ChartDataExportMode;
import com.anychart.enums.HoverMode;
import com.anychart.enums.Interval;
import com.anychart.enums.ScaleTypes;
import com.anychart.enums.Statistics;
import com.anychart.enums.StockRangeAnchor;
import com.anychart.enums.StockRangeType;
import com.anychart.graphics.math.Rect;
import com.anychart.graphics.vector.ColoredFill;
import com.anychart.graphics.vector.Fill;
import com.anychart.graphics.vector.GradientKey;
import com.anychart.graphics.vector.Layer;
import com.anychart.graphics.vector.PaperSize;
import com.anychart.graphics.vector.Stage;
import com.anychart.graphics.vector.Stroke;
import com.anychart.graphics.vector.StrokeLineCap;
import com.anychart.graphics.vector.StrokeLineJoin;
import com.anychart.scales.StockScatterDateTime;
import com.anychart.ui.ContextMenu;
import com.anychart.utils.RectObj;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Locale;

public class Stock
extends Chart {
    protected Stock() {
    }

    public static Stock instantiate() {
        return new Stock("new anychart.charts.stock()");
    }

    public Stock(String jsChart) {
        this.jsBase = "stock" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    @Override
    public Animation animation() {
        return new Animation(this.jsBase + ".animation()");
    }

    @Override
    public Stock animation(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".animation(%s);", value));
        return this;
    }

    @Override
    public Stock animation(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".animation(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock animation(Boolean enabled, Number duration) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".animation(%s, %s);", enabled, duration));
        return this;
    }

    public ChartController annotations() {
        return new ChartController(this.jsBase + ".annotations()");
    }

    @Override
    public void autoRedraw() {
        APIlib.getInstance().addJSLine(this.jsBase + ".autoRedraw();");
    }

    @Override
    public Stock autoRedraw(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".autoRedraw(%s);", value));
        return this;
    }

    @Override
    public Background background() {
        return new Background(this.jsBase + ".background()");
    }

    @Override
    public Stock background(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".background(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void bottom() {
        APIlib.getInstance().addJSLine(this.jsBase + ".bottom();");
    }

    @Override
    public Stock bottom(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", value));
        return this;
    }

    @Override
    public Stock bottom(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Bounds bounds() {
        return new Bounds(this.jsBase + ".bounds()");
    }

    @Override
    public Stock bounds(RectObj value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock bounds(com.anychart.math.Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock bounds(Bounds value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, height));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, width, height));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock cancelMarquee() {
        APIlib.getInstance().addJSLine(this.jsBase + ".cancelMarquee();");
        return this;
    }

    @Override
    public Layer container() {
        return new Layer(this.jsBase + ".container()");
    }

    @Override
    public Stock container(Layer value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".container(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock container(Stage value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".container(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock container(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".container(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public ContextMenu contextMenu() {
        return new ContextMenu(this.jsBase + ".contextMenu()");
    }

    @Override
    public Stock contextMenu(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".contextMenu(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock contextMenu(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".contextMenu(%s);", value));
        return this;
    }

    @Override
    public ChartCredits credits() {
        return new ChartCredits(this.jsBase + ".credits()");
    }

    @Override
    public Stock credits(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".credits(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock credits(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".credits(%s);", value));
        return this;
    }

    public Crosshair crosshair() {
        return new Crosshair(this.jsBase + ".crosshair()");
    }

    public Stock crosshair(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".crosshair(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    public Stock crosshair(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".crosshair(%s);", value));
        return this;
    }

    @Override
    public void dispose() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dispose();");
    }

    @Override
    public Stock draw(Boolean async) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".draw(%s);", async));
        return this;
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public Stock enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    public Controller eventMarkers() {
        return new Controller(this.jsBase + ".eventMarkers()");
    }

    public Stock eventMarkers(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".eventMarkers(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    public Stock eventMarkers(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".eventMarkers(%s);", value));
        return this;
    }

    @Override
    public Exports exports() {
        return new Exports(this.jsBase + ".exports()");
    }

    @Override
    public Stock exports(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".exports(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public com.anychart.math.Rect getPixelBounds() {
        return new com.anychart.math.Rect(this.jsBase + ".getPixelBounds()");
    }

    public void getPlotsCount() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getPlotsCount();");
    }

    @Override
    public void getSelectedPoints() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getSelectedPoints();");
    }

    public void getSelectedRange() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getSelectedRange();");
    }

    @Override
    public void getStat(Statistics key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getStat(%s);", key != null ? key.getJsBase() : null));
    }

    @Override
    public void getStat(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getStat(%s);", Stock.wrapQuotes(key)));
    }

    @Override
    public void globalToLocal(Number xCoord, Number yCoord) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".globalToLocal(%s, %s);", xCoord, yCoord));
    }

    public Grouping grouping() {
        return new Grouping(this.jsBase + ".grouping()");
    }

    public Stock grouping(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".grouping(%s);", value));
        return this;
    }

    public Stock grouping(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".grouping(%s);", Stock.arrayToStringWrapQuotes(value)));
        return this;
    }

    public Stock grouping(Level value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".grouping(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Stock grouping(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".grouping(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    @Override
    public Stock height(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", value));
        return this;
    }

    @Override
    public Stock height(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void inMarquee() {
        APIlib.getInstance().addJSLine(this.jsBase + ".inMarquee();");
    }

    public StockInteractivity interactivity() {
        return new StockInteractivity(this.jsBase + ".interactivity()");
    }

    public SeparateChart interactivity(String value) {
        return new SeparateChart(String.format(Locale.US, this.jsBase + ".interactivity(%s)", Stock.wrapQuotes(value)));
    }

    public SeparateChart interactivity(HoverMode value) {
        return new SeparateChart(String.format(Locale.US, this.jsBase + ".interactivity(%s)", value != null ? value.getJsBase() : null));
    }

    @Override
    public Label label(String index) {
        return new Label(String.format(Locale.US, this.jsBase + ".label(%s)", Stock.wrapQuotes(index)));
    }

    @Override
    public Label label(Number index) {
        return new Label(String.format(Locale.US, this.jsBase + ".label(%s)", index));
    }

    @Override
    public Stock label(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s);", value));
        return this;
    }

    @Override
    public Stock label(String index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", Stock.wrapQuotes(index), value));
        return this;
    }

    @Override
    public Stock label(String index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", Stock.wrapQuotes(index), Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock label(Number index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", index, value));
        return this;
    }

    @Override
    public Stock label(Number index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", index, Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void left() {
        APIlib.getInstance().addJSLine(this.jsBase + ".left();");
    }

    @Override
    public Stock left(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", value));
        return this;
    }

    @Override
    public Stock left(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void localToGlobal(Number xCoord, Number yCoord) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".localToGlobal(%s, %s);", xCoord, yCoord));
    }

    @Override
    public Margin margin() {
        return new Margin(this.jsBase + ".margin()");
    }

    @Override
    public Stock margin(Number[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s);", Arrays.toString(value)));
        return this;
    }

    @Override
    public Stock margin(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s);", Stock.arrayToStringWrapQuotes(value)));
        return this;
    }

    @Override
    public Stock margin(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock margin(String value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(String value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock margin(String value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(String value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), value3, value4));
        return this;
    }

    @Override
    public Stock margin(String value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(String value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock margin(String value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(String value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, value3, value4));
        return this;
    }

    @Override
    public Stock margin(Number value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(Number value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock margin(Number value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(Number value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), value3, value4));
        return this;
    }

    @Override
    public Stock margin(Number value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(Number value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock margin(Number value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock margin(Number value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, value3, value4));
        return this;
    }

    @Override
    public void maxHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxHeight();");
    }

    @Override
    public Stock maxHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", value));
        return this;
    }

    @Override
    public Stock maxHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void maxWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxWidth();");
    }

    @Override
    public Stock maxWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", value));
        return this;
    }

    @Override
    public Stock maxWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void minHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minHeight();");
    }

    @Override
    public Stock minHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", value));
        return this;
    }

    @Override
    public Stock minHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void minWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minWidth();");
    }

    @Override
    public Stock minWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", value));
        return this;
    }

    @Override
    public Stock minWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Padding padding() {
        return new Padding(this.jsBase + ".padding()");
    }

    @Override
    public Stock padding(Number[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s);", Arrays.toString(value)));
        return this;
    }

    @Override
    public Stock padding(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s);", Stock.arrayToStringWrapQuotes(value)));
        return this;
    }

    @Override
    public Stock padding(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock padding(String value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(String value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock padding(String value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(String value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), Stock.wrapQuotes(value2), value3, value4));
        return this;
    }

    @Override
    public Stock padding(String value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(String value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock padding(String value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(String value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Stock.wrapQuotes(value1), value2, value3, value4));
        return this;
    }

    @Override
    public Stock padding(Number value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(Number value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock padding(Number value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(Number value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Stock.wrapQuotes(value2), value3, value4));
        return this;
    }

    @Override
    public Stock padding(Number value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, Stock.wrapQuotes(value3), Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(Number value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, Stock.wrapQuotes(value3), value4));
        return this;
    }

    @Override
    public Stock padding(Number value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, value3, Stock.wrapQuotes(value4)));
        return this;
    }

    @Override
    public Stock padding(Number value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, value3, value4));
        return this;
    }

    public Plot plot(Number index) {
        return new Plot(String.format(Locale.US, this.jsBase + ".plot(%s)", index));
    }

    public Stock plot(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".plot(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    public Stock plot(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".plot(%s);", value));
        return this;
    }

    public Stock plot(Number index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".plot(%s, %s);", index, Stock.wrapQuotes(value)));
        return this;
    }

    public Stock plot(Number index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".plot(%s, %s);", index, value));
        return this;
    }

    public void preserveSelectedRangeOnDataUpdate() {
        APIlib.getInstance().addJSLine(this.jsBase + ".preserveSelectedRangeOnDataUpdate();");
    }

    public Stock preserveSelectedRangeOnDataUpdate(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".preserveSelectedRangeOnDataUpdate(%s);", value));
        return this;
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", Stock.wrapQuotes(paperSizeOrOptions), landscape));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Stock.wrapQuotes(type)));
    }

    @Override
    public void right() {
        APIlib.getInstance().addJSLine(this.jsBase + ".right();");
    }

    @Override
    public Stock right(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", value));
        return this;
    }

    @Override
    public Stock right(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void saveAsJpg(Number width, Number height, Number quality, Boolean forceTransparentWhite, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsJpg(%s, %s, %s, %s, %s);", width, height, quality, forceTransparentWhite, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsJpg(String width, Number height, Number quality, Boolean forceTransparentWhite, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsJpg(%s, %s, %s, %s, %s);", Stock.wrapQuotes(width), height, quality, forceTransparentWhite, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsJson(String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsJson(%s);", Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsPdf(Number paperSizeOrWidthOrOptions, Boolean landscape, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPdf(%s, %s, %s, %s, %s);", paperSizeOrWidthOrOptions, landscape, x, y, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsPdf(String paperSizeOrWidthOrOptions, Boolean landscape, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPdf(%s, %s, %s, %s, %s);", Stock.wrapQuotes(paperSizeOrWidthOrOptions), landscape, x, y, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsPng(Number width, Number height, Number quality, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPng(%s, %s, %s, %s);", width, height, quality, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsPng(String width, Number height, Number quality, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPng(%s, %s, %s, %s);", Stock.wrapQuotes(width), height, quality, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsSvg(String paperSize, Boolean landscape, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsSvg(%s, %s, %s);", Stock.wrapQuotes(paperSize), landscape, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsSvg(Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsSvg(%s, %s);", width, height));
    }

    @Override
    public void saveAsXlsx(ChartDataExportMode chartDataExportMode, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsXlsx(%s, %s);", chartDataExportMode != null ? chartDataExportMode.getJsBase() : null, Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsXlsx(String chartDataExportMode, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsXlsx(%s, %s);", Stock.wrapQuotes(chartDataExportMode), Stock.wrapQuotes(filename)));
    }

    @Override
    public void saveAsXml(String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsXml(%s);", Stock.wrapQuotes(filename)));
    }

    public Scroller scroller() {
        return new Scroller(this.jsBase + ".scroller()");
    }

    public Stock scroller(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scroller(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    public Stock scroller(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scroller(%s);", value));
        return this;
    }

    public Grouping scrollerGrouping() {
        return new Grouping(this.jsBase + ".scrollerGrouping()");
    }

    public Stock scrollerGrouping(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scrollerGrouping(%s);", value));
        return this;
    }

    public Stock scrollerGrouping(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scrollerGrouping(%s);", Stock.arrayToStringWrapQuotes(value)));
        return this;
    }

    public Stock scrollerGrouping(Level value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scrollerGrouping(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Stock scrollerGrouping(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scrollerGrouping(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void selectMarqueeFill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".selectMarqueeFill();");
    }

    @Override
    public Stock selectMarqueeFill(Fill value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s);", Stock.wrapQuotes(color), opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(GradientKey keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Stock.wrapQuotes(mode), opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(String[] keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, Stock.wrapQuotes(mode), opacity));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(GradientKey keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    @Override
    public Stock selectMarqueeFill(String[] keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    @Override
    public void selectMarqueeStroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".selectMarqueeStroke();");
    }

    @Override
    public Stock selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(String color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(String color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Stock selectMarqueeStroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock selectRange(Number start, Number end) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s);", start, end));
        return this;
    }

    public Stock selectRange(Number start, String end) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s);", start, Stock.wrapQuotes(end)));
        return this;
    }

    public Stock selectRange(String start, Number end) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s);", Stock.wrapQuotes(start), end));
        return this;
    }

    public Stock selectRange(String start, String end) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s);", Stock.wrapQuotes(start), Stock.wrapQuotes(end)));
        return this;
    }

    public Stock selectRange(Number start, Number end, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s);", start, end, dispatchEvent));
        return this;
    }

    public Stock selectRange(Number start, String end, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s);", start, Stock.wrapQuotes(end), dispatchEvent));
        return this;
    }

    public Stock selectRange(String start, Number end, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s);", Stock.wrapQuotes(start), end, dispatchEvent));
        return this;
    }

    public Stock selectRange(String start, String end, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s);", Stock.wrapQuotes(start), Stock.wrapQuotes(end), dispatchEvent));
        return this;
    }

    public Stock selectRange(StockRangeType type, Number count, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s);", type != null ? type.getJsBase() : null, count, dispatchEvent));
        return this;
    }

    public Stock selectRange(Interval unit, Number count, StockRangeAnchor anchor, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s, %s);", unit != null ? unit.getJsBase() : null, count, anchor != null ? anchor.getJsBase() : null, dispatchEvent));
        return this;
    }

    public Stock selectRange(Interval unit, Number count, String anchor, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s, %s);", unit != null ? unit.getJsBase() : null, count, Stock.wrapQuotes(anchor), dispatchEvent));
        return this;
    }

    public Stock selectRange(String unit, Number count, StockRangeAnchor anchor, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s, %s);", Stock.wrapQuotes(unit), count, anchor != null ? anchor.getJsBase() : null, dispatchEvent));
        return this;
    }

    public Stock selectRange(String unit, Number count, String anchor, Boolean dispatchEvent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectRange(%s, %s, %s, %s);", Stock.wrapQuotes(unit), count, Stock.wrapQuotes(anchor), dispatchEvent));
        return this;
    }

    @Override
    public Stock startSelectMarquee(Boolean repeat) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".startSelectMarquee(%s);", repeat));
        return this;
    }

    public Stock startZoomMarquee(Boolean repeat, Boolean asRect) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".startZoomMarquee(%s, %s);", repeat, asRect));
        return this;
    }

    @Override
    public Title title() {
        return new Title(this.jsBase + ".title()");
    }

    @Override
    public Stock title(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".title(%s);", value));
        return this;
    }

    @Override
    public Stock title(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".title(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void toJson(Boolean stringify) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toJson(%s);", stringify));
    }

    @Override
    public void toSvg(String paperSize, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toSvg(%s, %s);", Stock.wrapQuotes(paperSize), landscape));
    }

    @Override
    public void toSvg(Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toSvg(%s, %s);", width, height));
    }

    @Override
    public void toXml(Boolean asXmlNode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toXml(%s);", asXmlNode));
    }

    @Override
    public Tooltip tooltip() {
        return new Tooltip(this.jsBase + ".tooltip()");
    }

    @Override
    public Stock tooltip(String tooltipSettings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".tooltip(%s);", Stock.wrapQuotes(tooltipSettings)));
        return this;
    }

    @Override
    public Stock tooltip(Boolean tooltipSettings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".tooltip(%s);", tooltipSettings));
        return this;
    }

    @Override
    public void top() {
        APIlib.getInstance().addJSLine(this.jsBase + ".top();");
    }

    @Override
    public Stock top(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", value));
        return this;
    }

    @Override
    public Stock top(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Stock.wrapQuotes(key)));
    }

    @Override
    public void width() {
        APIlib.getInstance().addJSLine(this.jsBase + ".width();");
    }

    @Override
    public Stock width(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", value));
        return this;
    }

    @Override
    public Stock width(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    public StockScatterDateTime xScale() {
        return new StockScatterDateTime(this.jsBase + ".xScale()");
    }

    public Stock xScale(ScaleTypes value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xScale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Stock xScale(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xScale(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Stock zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    public void zoomMarqueeFill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zoomMarqueeFill();");
    }

    public Stock zoomMarqueeFill(Fill value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Stock zoomMarqueeFill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s);", Stock.wrapQuotes(color), opacity));
        return this;
    }

    public Stock zoomMarqueeFill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    public Stock zoomMarqueeFill(GradientKey keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Stock zoomMarqueeFill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Stock.wrapQuotes(mode), opacity));
        return this;
    }

    public Stock zoomMarqueeFill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    public Stock zoomMarqueeFill(String[] keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Stock zoomMarqueeFill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, Stock.wrapQuotes(mode), opacity));
        return this;
    }

    public Stock zoomMarqueeFill(GradientKey keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public Stock zoomMarqueeFill(String[] keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeFill(%s, %s, %s, %s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public void zoomMarqueeStroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zoomMarqueeStroke();");
    }

    public Stock zoomMarqueeStroke(Stroke color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock zoomMarqueeStroke(Stroke color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock zoomMarqueeStroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock zoomMarqueeStroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock zoomMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock zoomMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock zoomMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock zoomMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock zoomMarqueeStroke(String color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock zoomMarqueeStroke(String color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock zoomMarqueeStroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock zoomMarqueeStroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomMarqueeStroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public ChartA11y a11y() {
        return new ChartA11y(this.jsBase + ".a11y()");
    }

    @Override
    public Stock a11y(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".a11y(%s);", value));
        return this;
    }

    @Override
    public Stock a11y(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".a11y(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void getJpgBase64String(String onSuccessOrOptions, String onError, Number width, Number height, Number quality, Boolean forceTransparentWhite) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getJpgBase64String(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), width, height, quality, forceTransparentWhite));
    }

    @Override
    public void getPdfBase64String(String onSuccessOrOptions, String onError, Number paperSizeOrWidth, Number landscapeOrWidth, Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getPdfBase64String(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), paperSizeOrWidth, landscapeOrWidth, x, y));
    }

    @Override
    public void getPdfBase64String(String onSuccessOrOptions, String onError, Number paperSizeOrWidth, Boolean landscapeOrWidth, Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getPdfBase64String(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), paperSizeOrWidth, landscapeOrWidth, x, y));
    }

    @Override
    public void getPdfBase64String(String onSuccessOrOptions, String onError, String paperSizeOrWidth, Number landscapeOrWidth, Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getPdfBase64String(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), Stock.wrapQuotes(paperSizeOrWidth), landscapeOrWidth, x, y));
    }

    @Override
    public void getPdfBase64String(String onSuccessOrOptions, String onError, String paperSizeOrWidth, Boolean landscapeOrWidth, Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getPdfBase64String(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), Stock.wrapQuotes(paperSizeOrWidth), landscapeOrWidth, x, y));
    }

    @Override
    public void getPngBase64String(String onSuccessOrOptions, String onError, Number width, Number height, Number quality) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getPngBase64String(%s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), width, height, quality));
    }

    @Override
    public void getSvgBase64String(String onSuccessOrOptions, String onError, String paperSizeOrWidth, Boolean landscapeOrHeight) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getSvgBase64String(%s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), Stock.wrapQuotes(paperSizeOrWidth), landscapeOrHeight));
    }

    @Override
    public void getSvgBase64String(String onSuccessOrOptions, String onError, String paperSizeOrWidth, String landscapeOrHeight) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getSvgBase64String(%s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), Stock.wrapQuotes(paperSizeOrWidth), Stock.wrapQuotes(landscapeOrHeight)));
    }

    @Override
    public void getSvgBase64String(String onSuccessOrOptions, String onError, Number paperSizeOrWidth, Boolean landscapeOrHeight) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getSvgBase64String(%s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), paperSizeOrWidth, landscapeOrHeight));
    }

    @Override
    public void getSvgBase64String(String onSuccessOrOptions, String onError, Number paperSizeOrWidth, String landscapeOrHeight) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getSvgBase64String(%s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), paperSizeOrWidth, Stock.wrapQuotes(landscapeOrHeight)));
    }

    @Override
    public NoDataSettings noData() {
        return new NoDataSettings(this.jsBase + ".noData()");
    }

    @Override
    public Stock noData(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".noData(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void shareAsJpg(String onSuccessOrOptions, String onError, Boolean asBase64, Number width, Number height, Number quality, Boolean forceTransparentWhite, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsJpg(%s, %s, %s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, width, height, quality, forceTransparentWhite, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsPdf(String onSuccessOrOptions, String onError, Boolean asBase64, Number paperSizeOrWidth, Number landscapeOrWidth, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsPdf(%s, %s, %s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, paperSizeOrWidth, landscapeOrWidth, x, y, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsPdf(String onSuccessOrOptions, String onError, Boolean asBase64, Number paperSizeOrWidth, Boolean landscapeOrWidth, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsPdf(%s, %s, %s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, paperSizeOrWidth, landscapeOrWidth, x, y, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsPdf(String onSuccessOrOptions, String onError, Boolean asBase64, String paperSizeOrWidth, Number landscapeOrWidth, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsPdf(%s, %s, %s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, Stock.wrapQuotes(paperSizeOrWidth), landscapeOrWidth, x, y, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsPdf(String onSuccessOrOptions, String onError, Boolean asBase64, String paperSizeOrWidth, Boolean landscapeOrWidth, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsPdf(%s, %s, %s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, Stock.wrapQuotes(paperSizeOrWidth), landscapeOrWidth, x, y, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsPng(String onSuccessOrOptions, String onError, Boolean asBase64, Number width, Number height, Number quality, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsPng(%s, %s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, width, height, quality, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsSvg(String onSuccessOrOptions, String onError, Boolean asBase64, String paperSizeOrWidth, Boolean landscapeOrHeight, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsSvg(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, Stock.wrapQuotes(paperSizeOrWidth), landscapeOrHeight, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsSvg(String onSuccessOrOptions, String onError, Boolean asBase64, String paperSizeOrWidth, String landscapeOrHeight, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsSvg(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, Stock.wrapQuotes(paperSizeOrWidth), Stock.wrapQuotes(landscapeOrHeight), Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsSvg(String onSuccessOrOptions, String onError, Boolean asBase64, Number paperSizeOrWidth, Boolean landscapeOrHeight, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsSvg(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, paperSizeOrWidth, landscapeOrHeight, Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareAsSvg(String onSuccessOrOptions, String onError, Boolean asBase64, Number paperSizeOrWidth, String landscapeOrHeight, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareAsSvg(%s, %s, %s, %s, %s, %s);", Stock.wrapQuotes(onSuccessOrOptions), Stock.wrapQuotes(onError), asBase64, paperSizeOrWidth, Stock.wrapQuotes(landscapeOrHeight), Stock.wrapQuotes(filename)));
    }

    @Override
    public void shareWithFacebook(String captionOrOptions, String link, String name, String description) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareWithFacebook(%s, %s, %s, %s);", Stock.wrapQuotes(captionOrOptions), Stock.wrapQuotes(link), Stock.wrapQuotes(name), Stock.wrapQuotes(description)));
    }

    @Override
    public void shareWithLinkedIn(String captionOrOptions, String description) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareWithLinkedIn(%s, %s);", Stock.wrapQuotes(captionOrOptions), Stock.wrapQuotes(description)));
    }

    @Override
    public void shareWithPinterest(String linkOrOptions, String description) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareWithPinterest(%s, %s);", Stock.wrapQuotes(linkOrOptions), Stock.wrapQuotes(description)));
    }

    @Override
    public void shareWithTwitter() {
        APIlib.getInstance().addJSLine(this.jsBase + ".shareWithTwitter();");
    }

    @Override
    public void toA11yTable(String title, Boolean asString) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toA11yTable(%s, %s);", Stock.wrapQuotes(title), asString));
    }

    @Override
    public void toHtmlTable(String title, Boolean asString) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toHtmlTable(%s, %s);", Stock.wrapQuotes(title), asString));
    }

    public Object xScale(Class scaleClass) {
        Object instance = null;
        try {
            instance = scaleClass.getDeclaredConstructor(String.class).newInstance(this.jsBase + ".xScale()");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

