/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.anychart.anychart.Chart;
import com.anychart.anychart.JsObject;
import com.anychart.anychart.R;
import com.anychart.anychart.chart.common.ListenersInterface;

public final class AnyChartView
extends FrameLayout {
    private WebView webView;
    private Chart chart;
    private boolean isRestored;
    private StringBuilder scripts = new StringBuilder();
    private StringBuilder fonts = new StringBuilder();
    protected StringBuilder js = new StringBuilder();
    private String licenceKey = "";
    private View progressBar;
    private String backgroundColor;

    public AnyChartView(Context context) {
        super(context);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("js", this.js.toString());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.js.append(bundle.getString("js"));
            state = bundle.getParcelable("superState");
        }
        this.isRestored = true;
        super.onRestoreInstanceState(state);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_anychart, (ViewGroup)this, true);
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        this.webView = (WebView)view.findViewById(R.id.web_view);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        this.webView.setLongClickable(true);
        this.webView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                AnyChartView.this.webView.setEnabled(false);
                return true;
            }
        });
        JsObject.isRendered = false;
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                if (AnyChartView.this.chart != null) {
                    if (!AnyChartView.this.isRestored) {
                        AnyChartView.this.js.append(AnyChartView.this.chart.generateJs());
                    }
                } else {
                    throw new NullPointerException();
                }
                String resultJs = AnyChartView.this.isRestored ? AnyChartView.this.js.toString() : AnyChartView.this.js.append("chart.container(\"container\");").append("chart.draw();").toString();
                AnyChartView.this.webView.evaluateJavascript("anychart.licenseKey(\"" + AnyChartView.this.licenceKey + "\");anychart.onDocumentReady(function () {\n" + resultJs + "});", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        if (AnyChartView.this.progressBar != null) {
                            AnyChartView.this.progressBar.setVisibility(8);
                        }
                    }
                });
                JsObject.isRendered = true;
                AnyChartView.this.chart.setOnChangeListener(new JsObject.OnChange(){

                    @Override
                    public void onChange(final String jsChange) {
                        AnyChartView.this.js.append(jsChange);
                        AnyChartView.this.webView.post(new Runnable(){

                            @Override
                            public void run() {
                                AnyChartView.this.webView.evaluateJavascript(jsChange, null);
                            }
                        });
                    }
                });
            }
        });
        this.webView.addJavascriptInterface((Object)ListenersInterface.getInstance(), "android");
    }

    private void loadHtml() {
        String htmlData = "<html>\n<head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n    <style type=\"text/css\">\n        html, body, #container {\n            width: 100%;\n            height: 100%;\n            margin: 0;\n            padding: 0;\n" + (this.backgroundColor != null ? "background-color: " + this.backgroundColor + ";" : "") + "        }\n" + this.fonts.toString() + "    </style>\n</head>\n<body>\n<script src=\"file:///android_asset/anychart-bundle.min.js\"></script>" + this.scripts.toString() + "<link rel=\"stylesheet\" href=\"file:///android_asset/anychart-ui.min.css\"/>\n<div id=\"container\"></div>\n</body>\n</html>";
        this.webView.loadDataWithBaseURL("", htmlData, "text/html", "UTF-8", null);
    }

    public void addScript(String url) {
        this.scripts.append("<script src=\"").append(url).append("\"></script>\n");
    }

    public void addCss(String url) {
        this.scripts.append("<link rel=\"stylesheet\" href=\"").append(url).append("\"/>\n");
    }

    public void addFont(String fontFamily, String url) {
        this.fonts.append("@font-face {\n").append("font-family: ").append(fontFamily).append(";\n").append("src: url(").append(url).append(");\n").append("}\n");
    }

    public void setLicenceKey(String key) {
        this.licenceKey = key;
    }

    public void setZoomEnabled(Boolean value) {
        this.webView.getSettings().setBuiltInZoomControls(value.booleanValue());
        this.webView.getSettings().setDisplayZoomControls(value == false);
    }

    public void setChart(Chart chart) {
        this.js.setLength(0);
        this.isRestored = false;
        this.chart = chart;
        this.loadHtml();
    }

    public void setProgressBar(View progressBar) {
        this.progressBar = progressBar;
        progressBar.setVisibility(0);
    }

    public void setBackgroundColor(String color) {
        this.backgroundColor = color;
        this.webView.setBackgroundColor(Color.parseColor((String)color));
    }
}

