/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.anychart.anychart.Chart;
import com.anychart.anychart.JsObject;
import com.anychart.anychart.R;
import com.anychart.anychart.chart.common.CapturePictureListener;
import com.anychart.anychart.chart.common.ListenersInterface;
import java.lang.ref.WeakReference;

public final class AnyChartView
extends FrameLayout {
    private WebView webView;
    private Chart chart;
    private boolean isRestored;
    private StringBuilder scripts = new StringBuilder();
    protected StringBuilder js = new StringBuilder();
    private String licenceKey = "";

    public AnyChartView(Context context) {
        super(context);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("js", this.js.toString());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.js.append(bundle.getString("js"));
            state = bundle.getParcelable("superState");
        }
        this.isRestored = true;
        super.onRestoreInstanceState(state);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_anychart, (ViewGroup)this, true);
        this.webView = (WebView)view.findViewById(R.id.web_view);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        this.webView.setLongClickable(true);
        this.webView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                AnyChartView.this.webView.setEnabled(false);
                return true;
            }
        });
        JsObject.isRendered = false;
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                String resultJs;
                if (AnyChartView.this.chart != null) {
                    if (!JsObject.isRendered && !AnyChartView.this.isRestored) {
                        AnyChartView.this.js.append(AnyChartView.this.chart.generateJs());
                    }
                } else {
                    throw new NullPointerException();
                }
                String string = resultJs = AnyChartView.this.isRestored ? AnyChartView.this.js.toString() : AnyChartView.this.js.append("chart.container(\"container\");").append("chart.draw();").toString();
                if (Build.VERSION.SDK_INT >= 19) {
                    AnyChartView.this.webView.evaluateJavascript("anychart.licenseKey(\"" + AnyChartView.this.licenceKey + "\");anychart.onDocumentReady(function () {\n" + resultJs + "});", null);
                } else {
                    AnyChartView.this.webView.loadUrl("anychart.licenseKey(\"" + AnyChartView.this.licenceKey + "\");javascript:anychart.onDocumentReady(function () {\n" + resultJs + "});");
                }
                AnyChartView.this.chart.setOnChangeListener(new JsObject.OnChange(){

                    @Override
                    public void onChange(final String jsChange) {
                        AnyChartView.this.js.append(jsChange);
                        AnyChartView.this.webView.post(new Runnable(){

                            @Override
                            public void run() {
                                if (Build.VERSION.SDK_INT >= 19) {
                                    AnyChartView.this.webView.evaluateJavascript(jsChange, null);
                                } else {
                                    AnyChartView.this.webView.loadUrl("javascript:" + jsChange);
                                }
                            }
                        });
                    }
                });
            }
        });
        this.webView.addJavascriptInterface((Object)ListenersInterface.getInstance(), "android");
    }

    private void loadHtml() {
        String htmlData = "<html>\n<head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n    <style type=\"text/css\">\n        html, body, #container {\n            width: 100%;\n            height: 100%;\n            margin: 0;\n            padding: 0;\n        }\n    </style>\n</head>\n<body>\n<script src=\"file:///android_asset/anychart-bundle.min.js\"></script>" + this.scripts.toString() + "<link rel=\"stylesheet\" href=\"file:///android_asset/anychart-ui.min.css\"/>\n<div id=\"container\"></div>\n</body>\n</html>";
        this.webView.loadDataWithBaseURL("", htmlData, "text/HTML", "UTF-8", "");
    }

    public void addScript(String url) {
        this.scripts.append("<script src=\"").append(url).append("\"></script>\n");
    }

    public void setLicenceKey(String key) {
        this.licenceKey = key;
    }

    public void setZoomEnabled(Boolean value) {
        this.webView.getSettings().setBuiltInZoomControls(value.booleanValue());
        this.webView.getSettings().setDisplayZoomControls(value == false);
    }

    public void setChart(Chart chart) {
        this.js.setLength(0);
        this.isRestored = false;
        this.chart = chart;
        this.loadHtml();
    }

    public void capturePicture(CapturePictureListener listener) {
        new CapturePictureAsyncTask(this.webView, listener).execute(new Void[0]);
    }

    private static class CapturePictureAsyncTask
    extends AsyncTask<Void, Void, Bitmap> {
        private WeakReference<WebView> webViewReference;
        private CapturePictureListener listener;

        CapturePictureAsyncTask(WebView webView, CapturePictureListener listener) {
            this.webViewReference = new WeakReference<WebView>(webView);
            this.listener = listener;
        }

        protected Bitmap doInBackground(Void ... params) {
            WebView webView = (WebView)this.webViewReference.get();
            if (webView == null) {
                return null;
            }
            try {
                Bitmap bitmap = Bitmap.createBitmap((int)webView.getWidth(), (int)webView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                webView.draw(canvas);
                return bitmap;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap bitmap) {
            this.listener.onDone(bitmap);
        }
    }
}

