/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.CriticalPath;
import com.anychart.anychart.DataEntry;
import com.anychart.anychart.Mapping;
import com.anychart.anychart.Milestones;
import com.anychart.anychart.SeparateChart;
import com.anychart.anychart.SingleValueDataSet;
import com.anychart.anychart.Tasks;
import com.anychart.anychart.Tree;
import com.anychart.anychart.TreeFillingMethod;
import com.anychart.anychart.View;
import com.anychart.anychart.application.MyApplication;
import com.anychart.anychart.chart.common.ListenersInterface;
import java.util.List;
import java.util.Locale;

public class Pert
extends SeparateChart {
    private CriticalPath getCriticalPath;
    private String criticalPath;
    private Tree getData;
    private Double horizontalSpacing;
    private String horizontalSpacing1;
    private Milestones getMilestones;
    private String milestones;
    private Tasks getTasks;
    private String tasks;
    private Double verticalSpacing;
    private String verticalSpacing1;

    protected Pert(String name) {
        super(name);
        this.js.setLength(0);
        this.js.append(String.format(Locale.US, "chart = %s();", name));
        this.jsBase = "chart";
    }

    public Pert setData(SingleValueDataSet data) {
        if (!data.isEmpty()) {
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(this.jsBase).append(".data([");
            this.js.append(data.generateJs());
            this.js.append("]);");
        }
        return this;
    }

    public Pert setData(List<DataEntry> data) {
        if (!data.isEmpty()) {
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(this.jsBase).append(".data([");
            for (DataEntry dataEntry : data) {
                this.js.append(dataEntry.generateJs()).append(",");
            }
            this.js.setLength(this.js.length() - 1);
            this.js.append("]);");
        }
        return this;
    }

    public Pert setData(List<DataEntry> data, TreeFillingMethod mode) {
        if (!data.isEmpty()) {
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(this.jsBase).append(".data([");
            for (DataEntry dataEntry : data) {
                this.js.append(dataEntry.generateJs()).append(",");
            }
            this.js.setLength(this.js.length() - 1);
            this.js.append("], ").append(mode != null ? mode.generateJs() : "null").append(");");
        }
        return this;
    }

    public Pert setData(Mapping mapping) {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        this.js.append(mapping.generateJs());
        this.js.append(this.jsBase).append(".data(").append(mapping.getJsBase()).append(");");
        return this;
    }

    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        this.js.append("chart.listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            this.js.append("var result = ");
            for (String field : listener.getFields()) {
                this.js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            this.js.setLength(this.js.length() - 8);
            this.js.append(";");
            this.js.append("android.onClick(result);");
        } else {
            this.js.append("android.onClick(null);");
        }
        this.js.append("});");
        MyApplication.getInstance().getJavaScriptInterface().setOnClickListener(listener);
    }

    public CriticalPath getCriticalPath() {
        if (this.getCriticalPath == null) {
            this.getCriticalPath = new CriticalPath(this.jsBase + ".criticalPath()");
        }
        return this.getCriticalPath;
    }

    public Pert setCriticalPath(String criticalPath) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".criticalPath(%s)", Pert.wrapQuotes(criticalPath)));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".criticalPath(%s)", Pert.wrapQuotes(criticalPath)));
            this.js.setLength(0);
        }
        return this;
    }

    public Tree getData() {
        if (this.getData == null) {
            this.getData = new Tree(this.jsBase + ".data()");
        }
        return this.getData;
    }

    public Pert data(List<DataEntry> data) {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (!data.isEmpty()) {
            StringBuilder resultData = new StringBuilder();
            resultData.append("[");
            for (DataEntry dataEntry : data) {
                resultData.append(dataEntry.generateJs()).append(",");
            }
            resultData.setLength(resultData.length() - 1);
            resultData.append("]");
            this.js.append(String.format(Locale.US, "var setData" + ++variableIndex + " = " + this.jsBase + ".data(%s);", resultData.toString()));
        }
        return this;
    }

    public Pert data(View mapping) {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        this.js.append(mapping.generateJs());
        this.js.append(String.format(Locale.US, "var setData1" + ++variableIndex + " = " + this.jsBase + ".data(%s);", mapping != null ? mapping.getJsBase() : "null"));
        return this;
    }

    public Pert setHorizontalSpacing(Double horizontalSpacing) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".horizontalSpacing(%f)", horizontalSpacing));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".horizontalSpacing(%f)", horizontalSpacing));
            this.js.setLength(0);
        }
        return this;
    }

    public Pert setHorizontalSpacing(String horizontalSpacing1) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".horizontalSpacing(%s)", Pert.wrapQuotes(horizontalSpacing1)));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".horizontalSpacing(%s)", Pert.wrapQuotes(horizontalSpacing1)));
            this.js.setLength(0);
        }
        return this;
    }

    public Milestones getMilestones() {
        if (this.getMilestones == null) {
            this.getMilestones = new Milestones(this.jsBase + ".milestones()");
        }
        return this.getMilestones;
    }

    public Pert setMilestones(String milestones) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".milestones(%s)", Pert.wrapQuotes(milestones)));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".milestones(%s)", Pert.wrapQuotes(milestones)));
            this.js.setLength(0);
        }
        return this;
    }

    public Tasks getTasks() {
        if (this.getTasks == null) {
            this.getTasks = new Tasks(this.jsBase + ".tasks()");
        }
        return this.getTasks;
    }

    public Pert setTasks(String tasks) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".tasks(%s)", Pert.wrapQuotes(tasks)));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".tasks(%s)", Pert.wrapQuotes(tasks)));
            this.js.setLength(0);
        }
        return this;
    }

    public Pert setVerticalSpacing(Double verticalSpacing) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".verticalSpacing(%f)", verticalSpacing));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".verticalSpacing(%f)", verticalSpacing));
            this.js.setLength(0);
        }
        return this;
    }

    public Pert setVerticalSpacing(String verticalSpacing1) {
        if (!this.isChain) {
            this.js.append(this.jsBase);
            this.isChain = true;
        }
        this.js.append(String.format(Locale.US, ".verticalSpacing(%s)", Pert.wrapQuotes(verticalSpacing1)));
        if (this.isRendered) {
            this.onChangeListener.onChange(String.format(Locale.US, ".verticalSpacing(%s)", Pert.wrapQuotes(verticalSpacing1)));
            this.js.setLength(0);
        }
        return this;
    }

    private String generateJSgetCriticalPath() {
        if (this.getCriticalPath != null) {
            return this.getCriticalPath.generateJs();
        }
        return "";
    }

    private String generateJSgetData() {
        if (this.getData != null) {
            return this.getData.generateJs();
        }
        return "";
    }

    private String generateJSgetMilestones() {
        if (this.getMilestones != null) {
            return this.getMilestones.generateJs();
        }
        return "";
    }

    private String generateJSgetTasks() {
        if (this.getTasks != null) {
            return this.getTasks.generateJs();
        }
        return "";
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        this.js.append(this.generateJSgetCriticalPath());
        this.js.append(this.generateJSgetData());
        this.js.append(this.generateJSgetMilestones());
        this.js.append(this.generateJSgetTasks());
        this.js.append(super.generateJsGetters());
        this.js.append(super.generateJs());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

