package com.anychart.anychart;

import java.util.Locale;

// class
/**
 * Basic methods for scales.
 */
public class ScalesBase extends CoreBase {

    public ScalesBase() {
        js.setLength(0);
        js.append("var scalesBase").append(++variableIndex).append(" = anychart.scales.base();");
        jsBase = "scalesBase" + variableIndex;
    }

    protected ScalesBase(String jsBase) {
        js.setLength(0);
        this.jsBase = jsBase;
    }

    protected ScalesBase(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    protected String getJsBase() {
        return jsBase;
    }

    
    private Boolean silently;

    /**
     * Informs the scale that an auto range calculation started for the chart in past was ended.
     */
    public void finishAutoCalc(Boolean silently) {
        if (jsBase == null) {
            this.silently = silently;
        } else {
            this.silently = silently;
            if (isChain) {
                js.append(";");
                isChain = false;
            }
            
            js.append(String.format(Locale.US, "var " + ++variableIndex + " = " + jsBase + ".finishAutoCalc(%b);", silently));
            

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, jsBase + ".finishAutoCalc(%b)", silently));
                js.setLength(0);
            }
        }
    }

    private Boolean inverted;

    /**
     * Setter for scale inversion. If the scale is <b>inverted</b>, axes and series go upside-down or right-to-left
instead of bottom-to-top and left-to-right.
     */
    public ScalesBase setInverted(Boolean inverted) {
        if (jsBase == null) {
            this.inverted = inverted;
        } else {
            this.inverted = inverted;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".inverted(%b)", inverted));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".inverted(%b)", inverted));
                js.setLength(0);
            }
        }
        return this;
    }


    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();

        jsGetters.append(super.generateJsGetters());

    

        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (isChain) {
            js.append(";");
            isChain = false;
        }

        js.append(generateJsGetters());

        

        String result = js.toString();
        js.setLength(0);
        return result;
    }

}