/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.Interactivity;
import java.util.Locale;

public class StockInteractivity
extends Interactivity {
    private Boolean scrollOnMouseWheel;
    private Boolean zoomOnMouseWheel;

    public StockInteractivity() {
    }

    protected StockInteractivity(String jsBase) {
        this.jsBase = jsBase;
    }

    protected StockInteractivity(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public StockInteractivity setScrollOnMouseWheel(Boolean scrollOnMouseWheel) {
        if (this.jsBase == null) {
            this.scrollOnMouseWheel = scrollOnMouseWheel;
        } else {
            this.scrollOnMouseWheel = scrollOnMouseWheel;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".scrollOnMouseWheel(%b)", scrollOnMouseWheel));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".scrollOnMouseWheel(%b)", scrollOnMouseWheel));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public StockInteractivity setZoomOnMouseWheel(Boolean zoomOnMouseWheel) {
        if (this.jsBase == null) {
            this.zoomOnMouseWheel = zoomOnMouseWheel;
        } else {
            this.zoomOnMouseWheel = zoomOnMouseWheel;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".zoomOnMouseWheel(%b)", zoomOnMouseWheel));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".zoomOnMouseWheel(%b)", zoomOnMouseWheel));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJSscrollOnMouseWheel() {
        if (this.scrollOnMouseWheel != null) {
            return String.format(Locale.US, "scrollOnMouseWheel: %b,", this.scrollOnMouseWheel);
        }
        return "";
    }

    private String generateJSzoomOnMouseWheel() {
        if (this.zoomOnMouseWheel != null) {
            return String.format(Locale.US, "zoomOnMouseWheel: %b,", this.zoomOnMouseWheel);
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSscrollOnMouseWheel());
            this.js.append(this.generateJSzoomOnMouseWheel());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

