/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.ScalesBase;
import java.util.Locale;

public class ScatterBase
extends ScalesBase {
    private Double ratio;
    private Double maxTicksCount;
    private Double maximum;
    private Double minimum;

    public ScatterBase() {
    }

    protected ScatterBase(String jsBase) {
        this.jsBase = jsBase;
    }

    protected ScatterBase(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public void inverseTransform(Double ratio) {
        if (this.jsBase == null) {
            this.ratio = ratio;
        } else {
            this.ratio = ratio;
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(String.format(Locale.US, this.jsBase + ".inverseTransform(%f);", ratio));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, this.jsBase + ".inverseTransform(%f)", ratio));
                this.js.setLength(0);
            }
        }
    }

    public ScatterBase setMaxTicksCount(Double maxTicksCount) {
        if (this.jsBase == null) {
            this.maxTicksCount = maxTicksCount;
        } else {
            this.maxTicksCount = maxTicksCount;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".maxTicksCount(%f)", maxTicksCount));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".maxTicksCount(%f)", maxTicksCount));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public ScatterBase setMaximum(Double maximum) {
        if (this.jsBase == null) {
            this.maximum = maximum;
        } else {
            this.maximum = maximum;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".maximum(%f)", maximum));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".maximum(%f)", maximum));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public ScatterBase setMinimum(Double minimum) {
        if (this.jsBase == null) {
            this.minimum = minimum;
        } else {
            this.minimum = minimum;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".minimum(%f)", minimum));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".minimum(%f)", minimum));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJSratio() {
        if (this.ratio != null) {
            return String.format(Locale.US, "ratio: %f,", this.ratio);
        }
        return "";
    }

    private String generateJSmaxTicksCount() {
        if (this.maxTicksCount != null) {
            return String.format(Locale.US, "maxTicksCount: %f,", this.maxTicksCount);
        }
        return "";
    }

    private String generateJSmaximum() {
        if (this.maximum != null) {
            return String.format(Locale.US, "maximum: %f,", this.maximum);
        }
        return "";
    }

    private String generateJSminimum() {
        if (this.minimum != null) {
            return String.format(Locale.US, "minimum: %f,", this.minimum);
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSratio());
            this.js.append(this.generateJSmaxTicksCount());
            this.js.append(this.generateJSmaximum());
            this.js.append(this.generateJSminimum());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

