/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.CoreBase;
import com.anychart.anychart.Milestones;
import com.anychart.anychart.Tasks;
import java.util.Locale;

public class CriticalPath
extends CoreBase {
    private Milestones getMilestones;
    private String milestones;
    private Tasks getTasks;
    private String tasks;

    public CriticalPath() {
    }

    protected CriticalPath(String jsBase) {
        this.jsBase = jsBase;
    }

    protected CriticalPath(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public Milestones getMilestones() {
        if (this.getMilestones == null) {
            this.getMilestones = new Milestones(this.jsBase + ".milestones()");
        }
        return this.getMilestones;
    }

    public CriticalPath setMilestones(String milestones) {
        if (this.jsBase == null) {
            this.milestones = milestones;
        } else {
            this.milestones = milestones;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".milestones(%s)", milestones));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".milestones(%s)", milestones));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Tasks getTasks() {
        if (this.getTasks == null) {
            this.getTasks = new Tasks(this.jsBase + ".tasks()");
        }
        return this.getTasks;
    }

    public CriticalPath setTasks(String tasks) {
        if (this.jsBase == null) {
            this.tasks = tasks;
        } else {
            this.tasks = tasks;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".tasks(%s)", tasks));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".tasks(%s)", tasks));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJSgetMilestones() {
        if (this.getMilestones != null) {
            return this.getMilestones.generateJs();
        }
        return "";
    }

    private String generateJSgetTasks() {
        if (this.getTasks != null) {
            return this.getTasks.generateJs();
        }
        return "";
    }

    private String generateJSmilestones() {
        if (this.milestones != null) {
            return String.format(Locale.US, "milestones: %s,", this.milestones);
        }
        return "";
    }

    private String generateJStasks() {
        if (this.tasks != null) {
            return String.format(Locale.US, "tasks: %s,", this.tasks);
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        jsGetters.append(this.generateJSgetMilestones());
        jsGetters.append(this.generateJSgetTasks());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSmilestones());
            this.js.append(this.generateJStasks());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

