/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.converter.request;

import android.util.Log;
import com.google.gson.Gson;
import io.github.wax911.library.annotation.processor.GraphProcessor;
import io.github.wax911.library.model.request.QueryContainer;
import io.github.wax911.library.model.request.QueryContainerBuilder;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lio/github/wax911/library/converter/request/GraphRequestConverter;", "Lretrofit2/Converter;", "Lio/github/wax911/library/model/request/QueryContainerBuilder;", "Lokhttp3/RequestBody;", "methodAnnotations", "", "", "graphProcessor", "Lio/github/wax911/library/annotation/processor/GraphProcessor;", "gson", "Lcom/google/gson/Gson;", "([Ljava/lang/annotation/Annotation;Lio/github/wax911/library/annotation/processor/GraphProcessor;Lcom/google/gson/Gson;)V", "getGraphProcessor", "()Lio/github/wax911/library/annotation/processor/GraphProcessor;", "getGson", "()Lcom/google/gson/Gson;", "getMethodAnnotations", "()[Ljava/lang/annotation/Annotation;", "[Ljava/lang/annotation/Annotation;", "convert", "containerBuilder", "library_release"})
public class GraphRequestConverter
implements Converter<QueryContainerBuilder, RequestBody> {
    @NotNull
    private final Annotation[] methodAnnotations;
    @NotNull
    private final GraphProcessor graphProcessor;
    @NotNull
    private final Gson gson;

    @NotNull
    public RequestBody convert(@NotNull QueryContainerBuilder containerBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)containerBuilder, (String)"containerBuilder");
        QueryContainer queryContainer = containerBuilder.setQuery(this.graphProcessor.getQuery(this.methodAnnotations)).build();
        String queryJson = this.gson.toJson((Object)queryContainer);
        Log.d((String)"GraphRequestConverter", (String)queryJson);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/graphql"), (String)queryJson);
        Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"RequestBody.create(Media\u2026ter.MimeType), queryJson)");
        return requestBody;
    }

    @NotNull
    protected final Annotation[] getMethodAnnotations() {
        return this.methodAnnotations;
    }

    @NotNull
    protected final GraphProcessor getGraphProcessor() {
        return this.graphProcessor;
    }

    @NotNull
    protected final Gson getGson() {
        return this.gson;
    }

    public GraphRequestConverter(@NotNull Annotation[] methodAnnotations, @NotNull GraphProcessor graphProcessor2, @NotNull Gson gson) {
        Intrinsics.checkParameterIsNotNull((Object)methodAnnotations, (String)"methodAnnotations");
        Intrinsics.checkParameterIsNotNull((Object)graphProcessor2, (String)"graphProcessor");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        this.methodAnnotations = methodAnnotations;
        this.graphProcessor = graphProcessor2;
        this.gson = gson;
    }
}

