/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.util;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.github.wax911.library.model.attribute.GraphError;
import io.github.wax911.library.model.body.GraphContainer;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class GraphErrorUtil {
    private static final String TAG = "GraphErrorUtil";

    @Nullable
    public static List<GraphError> getError(@Nullable Response response) {
        try {
            List<GraphError> graphErrors;
            String message;
            ResponseBody responseBody;
            if (response != null && (responseBody = response.errorBody()) != null && !TextUtils.isEmpty((CharSequence)(message = responseBody.string())) && (graphErrors = GraphErrorUtil.getGraphQLError(message)) != null) {
                return graphErrors;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static List<GraphError> getGraphQLError(String errorJson) {
        Log.e((String)TAG, (String)errorJson);
        Gson gson = new Gson();
        Type tokenType = new TypeToken<GraphContainer<?>>(){}.getType();
        GraphContainer graphContainer = (GraphContainer)gson.fromJson(errorJson, tokenType);
        return graphContainer.getErrors();
    }
}

