/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.converter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.wax911.library.annotation.processor.GraphProcessor;
import io.github.wax911.library.model.request.QueryContainer;
import io.github.wax911.library.model.request.QueryContainerBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class GraphConverter
extends Converter.Factory {
    protected GraphProcessor graphProcessor;
    protected final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().setLenient().create();

    public static GraphConverter create(Context context) {
        return new GraphConverter(context);
    }

    protected GraphConverter(Context context) {
        this.graphProcessor = GraphProcessor.getInstance(context);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type instanceof ResponseBody) {
            return super.responseBodyConverter(type, annotations, retrofit);
        }
        return new GraphResponseConverter(type);
    }

    public Converter<QueryContainerBuilder, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return new GraphRequestConverter(methodAnnotations);
    }

    protected class GraphRequestConverter
    implements Converter<QueryContainerBuilder, RequestBody> {
        protected Annotation[] methodAnnotations;

        protected GraphRequestConverter(Annotation[] methodAnnotations) {
            this.methodAnnotations = methodAnnotations;
        }

        public RequestBody convert(@NonNull QueryContainerBuilder containerBuilder) {
            QueryContainer queryContainer = containerBuilder.setQuery(GraphConverter.this.graphProcessor.getQuery(this.methodAnnotations)).build();
            String queryJson = GraphConverter.this.gson.toJson((Object)queryContainer);
            Log.d((String)"GraphRequestConverter", (String)queryJson);
            return RequestBody.create((MediaType)MediaType.parse((String)"application/graphql"), (String)queryJson);
        }
    }

    protected class GraphResponseConverter<T>
    implements Converter<ResponseBody, T> {
        protected Type type;

        protected GraphResponseConverter(Type type) {
            this.type = type;
        }

        public T convert(@NonNull ResponseBody responseBody) {
            Object response = null;
            try {
                String responseString = responseBody.string();
                response = GraphConverter.this.gson.fromJson(responseString, this.type);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return (T)response;
        }
    }
}

